/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import org.parboiled.BaseParser;
import org.parboiled.errors.GrammarException;
import org.parboiled.transform.ParserTransformer;

public class Parboiled {
    protected Parboiled() {
    }

    public static <P extends BaseParser<V>, V> P createParser(@Nonnull Class<P> parserClass, Object ... constructorArgs) {
        Preconditions.checkNotNull(parserClass, (Object)"parserClass");
        try {
            Class<P> extendedClass = ParserTransformer.transformParser(parserClass);
            Constructor<?> constructor = Parboiled.findConstructor(extendedClass, constructorArgs);
            BaseParser ret = (BaseParser)constructor.newInstance(constructorArgs);
            return (P)ret;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating extended parser class: " + e.getMessage(), e);
        }
    }

    public static <P extends BaseParser<V>, V> byte[] getByteCode(Class<P> parserClass) {
        try {
            return ParserTransformer.getByteCode(parserClass);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to generate byte code", e);
        }
    }

    private static Constructor<?> findConstructor(Class<?> c, Object[] arguments) {
        block0: for (Constructor<?> constructor : c.getConstructors()) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (paramTypes.length != arguments.length) continue;
            for (int i = 0; i < arguments.length; ++i) {
                Object argument = arguments[i];
                if (argument != null && !paramTypes[i].isAssignableFrom(argument.getClass()) || argument == null && paramTypes[i].isPrimitive()) continue block0;
            }
            return constructor;
        }
        throw new GrammarException("No constructor found for %s and the given %s arguments", c, arguments.length);
    }
}

