/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.buffers;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.support.IndexRange;
import org.parboiled.support.Position;

public class MutableInputBuffer
implements InputBuffer {
    private final InputBuffer buffer;
    private int[] inserts = new int[0];
    private char[] chars = new char[0];

    public MutableInputBuffer(InputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public char charAt(int index) {
        int j = Arrays.binarySearch(this.inserts, index);
        return j >= 0 ? this.chars[j] : this.buffer.charAt(index + j + 1);
    }

    @Override
    public boolean test(int index, char[] characters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Position getPosition(int index) {
        return this.buffer.getPosition(this.map(index));
    }

    @Override
    public int getOriginalIndex(int index) {
        return this.buffer.getOriginalIndex(this.map(index));
    }

    @Override
    public String extractLine(int lineNumber) {
        return this.buffer.extractLine(lineNumber);
    }

    @Override
    public String extract(int start, int end) {
        return this.buffer.extract(this.map(start), this.map(end));
    }

    @Override
    public String extract(IndexRange range) {
        return this.buffer.extract(this.map(range.start), this.map(range.end));
    }

    @Override
    public int getLineCount() {
        return this.buffer.getLineCount();
    }

    private int map(int index) {
        int j = Arrays.binarySearch(this.inserts, index);
        if (j < 0) {
            j = -(j + 1);
        }
        return index - j;
    }

    public void insertChar(int index, char c) {
        int j = Arrays.binarySearch(this.inserts, index);
        if (j < 0) {
            j = -(j + 1);
        }
        char[] newChars = new char[this.chars.length + 1];
        System.arraycopy(this.chars, 0, newChars, 0, j);
        newChars[j] = c;
        System.arraycopy(this.chars, j, newChars, j + 1, this.chars.length - j);
        this.chars = newChars;
        int[] newInserts = new int[this.inserts.length + 1];
        System.arraycopy(this.inserts, 0, newInserts, 0, j);
        newInserts[j] = index;
        for (int i = j; i < this.inserts.length; ++i) {
            newInserts[i + 1] = this.inserts[i] + 1;
        }
        this.inserts = newInserts;
    }

    public char undoCharInsertion(int index) {
        int j = Arrays.binarySearch(this.inserts, index);
        Preconditions.checkArgument((j >= 0 ? 1 : 0) != 0, (Object)"Cannot undo a non-existing insertion");
        char removedChar = this.chars[j];
        char[] newChars = new char[this.chars.length - 1];
        System.arraycopy(this.chars, 0, newChars, 0, j);
        System.arraycopy(this.chars, j + 1, newChars, j, newChars.length - j);
        this.chars = newChars;
        int[] newInserts = new int[this.inserts.length - 1];
        System.arraycopy(this.inserts, 0, newInserts, 0, j);
        for (int i = j + 1; i < this.inserts.length; ++i) {
            newInserts[i - 1] = this.inserts[i] - 1;
        }
        this.inserts = newInserts;
        return removedChar;
    }

    public void replaceInsertedChar(int index, char c) {
        int j = Arrays.binarySearch(this.inserts, index);
        Preconditions.checkArgument((j >= 0 ? 1 : 0) != 0, (Object)"Can only replace chars that were previously inserted");
        this.chars[j] = c;
    }
}

