/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

import java.util.AbstractList;
import java.util.List;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Utils;

@Deprecated
public abstract class ImmutableList<T>
extends AbstractList<T> {
    private static final ImmutableList<?> EMPTY_LIST = new ImmutableList<Object>(){

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException("Empty list has no element with index " + index);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public ImmutableList<Object> append(Object element) {
            return 1.of(element);
        }
    };

    public abstract ImmutableList<T> append(T var1);

    public static <T> ImmutableList<T> copyOf(List<T> other) {
        Preconditions.checkArgNotNull(other, "other");
        return other instanceof ImmutableList ? other : new RegularList(other.toArray());
    }

    public static <T> ImmutableList<T> of() {
        return EMPTY_LIST;
    }

    public static <T> ImmutableList<T> of(T a) {
        return new SingleElementList<T>(a);
    }

    public static <T> ImmutableList<T> of(T a, T b) {
        return new TwoElementList(a, b);
    }

    public static <T> ImmutableList<T> of(T a, T b, T c) {
        return new RegularList(new Object[]{a, b, c});
    }

    public static <T> ImmutableList<T> of(T ... elements) {
        Preconditions.checkArgNotNull(elements, "elements");
        return new RegularList((Object[])elements.clone());
    }

    public static <T> ImmutableList<T> of(T first, T[] more) {
        Preconditions.checkArgNotNull(more, "more");
        return new RegularList(Utils.arrayOf(first, (Object[])more.clone()));
    }

    public static <T> ImmutableList<T> of(T[] first, T last) {
        Preconditions.checkArgNotNull(first, "first");
        return new RegularList(Utils.arrayOf((Object[])first.clone(), last));
    }

    public static <T> ImmutableList<T> of(T first, ImmutableList<T> more) {
        Preconditions.checkArgNotNull(more, "more");
        if (more instanceof SingleElementList) {
            return ImmutableList.of(first, ((SingleElementList)more).element);
        }
        if (more instanceof TwoElementList) {
            TwoElementList list = (TwoElementList)more;
            return new RegularList(new Object[]{first, list.element0, list.element1});
        }
        if (more instanceof RegularList) {
            RegularList list = (RegularList)more;
            return new RegularList(Utils.arrayOf(first, list.elements));
        }
        Preconditions.checkState(more == EMPTY_LIST);
        return ImmutableList.of(first);
    }

    public static <T> ImmutableList<T> of(ImmutableList<T> first, T last) {
        Preconditions.checkArgNotNull(first, "more");
        if (first instanceof SingleElementList) {
            return ImmutableList.of(((SingleElementList)first).element, last);
        }
        if (first instanceof TwoElementList) {
            TwoElementList list = (TwoElementList)first;
            return new RegularList(new Object[]{list.element0, list.element1, last});
        }
        if (first instanceof RegularList) {
            RegularList list = (RegularList)first;
            return new RegularList(Utils.arrayOf(list.elements, last));
        }
        Preconditions.checkState(first == EMPTY_LIST);
        return ImmutableList.of(last);
    }

    private static class RegularList
    extends ImmutableList<Object> {
        private final Object[] elements;

        private RegularList(Object[] elements) {
            this.elements = elements;
        }

        @Override
        public Object get(int index) {
            return this.elements[index];
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public ImmutableList<Object> append(Object element) {
            Object[] newElements = new Object[this.elements.length + 1];
            System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
            newElements[this.elements.length] = element;
            return new RegularList(newElements);
        }
    }

    private static class TwoElementList<T>
    extends ImmutableList<T> {
        private final T element0;
        private final T element1;

        private TwoElementList(T element0, T element1) {
            this.element0 = element0;
            this.element1 = element1;
        }

        @Override
        public T get(int index) {
            Preconditions.checkElementIndex(index, 2);
            return index == 0 ? this.element0 : this.element1;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public ImmutableList<T> append(T element) {
            return TwoElementList.of(this.element0, this.element1, element);
        }
    }

    private static class SingleElementList<T>
    extends ImmutableList<T> {
        private final T element;

        public SingleElementList(T element) {
            this.element = element;
        }

        @Override
        public T get(int index) {
            Preconditions.checkElementIndex(index, 1);
            return this.element;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public ImmutableList<T> append(T element) {
            return SingleElementList.of(this.element, element);
        }
    }
}

