/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import com.google.common.base.Preconditions;
import java.util.List;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchervisitors.MatcherVisitor;

public class ProxyMatcher
implements Matcher,
Cloneable {
    private Matcher target;
    private String label;
    private boolean nodeSuppressed;
    private boolean subnodesSuppressed;
    private boolean nodeSkipped;
    private boolean memoMismatches;
    private boolean dirty;

    @Override
    public List<Matcher> getChildren() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.getChildren();
    }

    public void setLabel(String label) {
        this.label = label;
        this.updateDirtyFlag();
    }

    private void setNodeSuppressed(boolean nodeSuppressed) {
        this.nodeSuppressed = nodeSuppressed;
        this.updateDirtyFlag();
    }

    private void setSubnodesSuppressed(boolean subnodesSuppressed) {
        this.subnodesSuppressed = subnodesSuppressed;
        this.updateDirtyFlag();
    }

    private void setNodeSkipped(boolean nodeSkipped) {
        this.nodeSkipped = nodeSkipped;
        this.updateDirtyFlag();
    }

    private void setMemoMismatches(boolean memoMismatches) {
        this.memoMismatches = memoMismatches;
        this.updateDirtyFlag();
    }

    private void updateDirtyFlag() {
        this.dirty = this.label != null || this.nodeSuppressed || this.subnodesSuppressed || this.nodeSkipped || this.memoMismatches;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (this.dirty) {
            this.apply();
        }
        return this.target.match(context);
    }

    @Override
    public String getLabel() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.getLabel();
    }

    @Override
    public boolean hasCustomLabel() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.hasCustomLabel();
    }

    @Override
    public boolean isNodeSuppressed() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.isNodeSuppressed();
    }

    @Override
    public boolean areSubnodesSuppressed() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.areSubnodesSuppressed();
    }

    @Override
    public boolean isNodeSkipped() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.isNodeSkipped();
    }

    @Override
    public boolean areMismatchesMemoed() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.areMismatchesMemoed();
    }

    @Override
    public void setTag(Object tagObject) {
        if (this.dirty) {
            this.apply();
        }
        this.target.setTag(tagObject);
    }

    @Override
    public Object getTag() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.getTag();
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkNotNull(visitor, (Object)"visitor");
        if (this.dirty) {
            this.apply();
        }
        return this.target.accept(visitor);
    }

    public String toString() {
        if (this.target == null) {
            return super.toString();
        }
        if (this.dirty) {
            this.apply();
        }
        return this.target.toString();
    }

    private void apply() {
        if (this.label != null) {
            this.label(this.label);
        }
        if (this.nodeSuppressed) {
            this.suppressNode();
        }
        if (this.subnodesSuppressed) {
            this.suppressSubnodes();
        }
        if (this.nodeSkipped) {
            this.skipNode();
        }
    }

    @Override
    public Rule label(String label) {
        if (this.target == null) {
            if (this.label == null) {
                this.setLabel(label);
                return this;
            }
            ProxyMatcher anotherProxy = this.createClone();
            anotherProxy.setLabel(label);
            anotherProxy.arm(this);
            return anotherProxy;
        }
        Matcher inner = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)inner.label(label);
        this.setLabel(null);
        return this.target;
    }

    @Override
    public Rule suppressNode() {
        if (this.target == null) {
            this.setNodeSuppressed(true);
            return this;
        }
        Matcher inner = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)inner.suppressNode();
        this.setNodeSuppressed(false);
        return this.target;
    }

    @Override
    public Rule suppressSubnodes() {
        if (this.target == null) {
            this.setSubnodesSuppressed(true);
            return this;
        }
        Matcher inner = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)inner.suppressSubnodes();
        this.setSubnodesSuppressed(false);
        return this.target;
    }

    @Override
    public Rule skipNode() {
        if (this.target == null) {
            this.setNodeSkipped(true);
            return this;
        }
        Matcher inner = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)inner.skipNode();
        this.setNodeSkipped(false);
        return this.target;
    }

    @Override
    public Rule memoMismatches() {
        if (this.target == null) {
            this.setMemoMismatches(true);
            return this;
        }
        Matcher inner = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)inner.memoMismatches();
        this.setMemoMismatches(false);
        return this.target;
    }

    public void arm(Matcher target) {
        this.target = (Matcher)Preconditions.checkNotNull((Object)target, (Object)"target");
    }

    public static Matcher unwrap(Matcher matcher) {
        if (matcher instanceof ProxyMatcher) {
            ProxyMatcher proxyMatcher = (ProxyMatcher)matcher;
            if (proxyMatcher.dirty) {
                proxyMatcher.apply();
            }
            return proxyMatcher.target == null ? proxyMatcher : proxyMatcher.target;
        }
        return matcher;
    }

    @Override
    public <V> MatcherContext<V> getSubContext(MatcherContext<V> context) {
        if (this.dirty) {
            this.apply();
        }
        return this.target.getSubContext(context);
    }

    private ProxyMatcher createClone() {
        try {
            return (ProxyMatcher)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

