/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import com.google.common.base.Preconditions;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.matchers.SequenceMatcher;

public class StringMatcher
extends SequenceMatcher {
    public final char[] characters;

    public StringMatcher(Rule[] charMatchers, char[] characters) {
        super((Rule[])Preconditions.checkNotNull((Object)charMatchers, (Object)"charMatchers"));
        this.characters = characters;
    }

    @Override
    public String getLabel() {
        return super.getLabel() != null ? super.getLabel() : '\"' + String.valueOf(this.characters) + '\"';
    }

    @Override
    public boolean hasCustomLabel() {
        return true;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (!context.fastStringMatching()) {
            return super.match(context);
        }
        if (!context.getInputBuffer().test(context.getCurrentIndex(), this.characters)) {
            return false;
        }
        context.advanceIndex(this.characters.length);
        context.createNode();
        return true;
    }
}

