/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.matchervisitors.IsSingleCharMatcherVisitor;
import org.parboiled.parserunners.AbstractParseRunner;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;

public class ErrorReportingParseRunner<V>
extends AbstractParseRunner<V>
implements MatchHandler {
    private final IsSingleCharMatcherVisitor visitor = new IsSingleCharMatcherVisitor();
    private final int errorIndex;
    private final MatchHandler inner;
    private final List<MatcherPath> failedMatchers = new ArrayList<MatcherPath>();
    private boolean seeking;

    public ErrorReportingParseRunner(Rule rule, int errorIndex) {
        this(rule, errorIndex, null);
    }

    public ErrorReportingParseRunner(Rule rule, int errorIndex, @Nullable MatchHandler inner) {
        super(rule);
        this.errorIndex = errorIndex;
        this.inner = inner;
    }

    @Override
    public ParsingResult<V> run(InputBuffer inputBuffer) {
        Preconditions.checkNotNull((Object)inputBuffer, (Object)"inputBuffer");
        this.resetValueStack();
        this.failedMatchers.clear();
        this.seeking = this.errorIndex > 0;
        MatcherContext rootContext = this.createRootContext(inputBuffer, this, false);
        boolean matched = this.match(rootContext);
        if (!matched) {
            this.parseErrors.add(new InvalidInputError(inputBuffer, this.errorIndex, this.failedMatchers, null));
        }
        return this.createParsingResult(matched, rootContext);
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        boolean matched;
        boolean bl = matched = this.inner == null ? context.getMatcher().match(context) : this.inner.match(context);
        if (context.getCurrentIndex() == this.errorIndex) {
            if (matched && this.seeking) {
                this.seeking = false;
            }
            if (!matched && !this.seeking && context.getMatcher().accept(this.visitor).booleanValue()) {
                this.failedMatchers.add(context.getPath());
            }
        }
        return matched;
    }
}

