/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.parboiled.Node;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Formatter;
import org.parboiled.support.CharsEscaper;
import org.parboiled.support.ParseTreeUtils;

public class NodeFormatter<V>
implements Formatter<Node<V>> {
    private final InputBuffer inputBuffer;

    public NodeFormatter(@Nonnull InputBuffer inputBuffer) {
        this.inputBuffer = (InputBuffer)Preconditions.checkNotNull((Object)inputBuffer);
    }

    @Override
    public String format(Node<V> node) {
        String nodeLabel = node.toString();
        String text = ParseTreeUtils.getNodeText(node, this.inputBuffer);
        String nodeText = CharsEscaper.INSTANCE.escape(text);
        return nodeText.isEmpty() ? nodeLabel : nodeLabel + " '" + nodeText + '\'';
    }
}

