/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.Rule;
import org.parboiled.matchers.VarFramingMatcher;
import org.parboiled.support.Var;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.process.RuleMethodProcessor;

public class VarFramingGenerator
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode");
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        return !method.getLocalVarVariables().isEmpty();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode");
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        InsnList instructions = method.instructions;
        AbstractInsnNode ret = instructions.getLast();
        while (ret.getOpcode() != 176) {
            ret = ret.getPrevious();
        }
        instructions.insertBefore(ret, (AbstractInsnNode)new TypeInsnNode(187, CodegenUtils.p(VarFramingMatcher.class)));
        instructions.insertBefore(ret, (AbstractInsnNode)new InsnNode(90));
        instructions.insertBefore(ret, (AbstractInsnNode)new InsnNode(95));
        VarFramingGenerator.createVarFieldArray(method, instructions, ret);
        instructions.insertBefore(ret, (AbstractInsnNode)new MethodInsnNode(183, CodegenUtils.p(VarFramingMatcher.class), "<init>", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{Rule.class, Var[].class}), false));
        method.setBodyRewritten();
    }

    private static void createVarFieldArray(RuleMethod method, InsnList instructions, AbstractInsnNode ret) {
        int count = method.getLocalVarVariables().size();
        instructions.insertBefore(ret, (AbstractInsnNode)new IntInsnNode(16, count));
        instructions.insertBefore(ret, (AbstractInsnNode)new TypeInsnNode(189, CodegenUtils.p(Var.class)));
        for (int i = 0; i < count; ++i) {
            LocalVariableNode var = method.getLocalVarVariables().get(i);
            instructions.insertBefore(ret, (AbstractInsnNode)new InsnNode(89));
            instructions.insertBefore(ret, (AbstractInsnNode)new IntInsnNode(16, i));
            instructions.insertBefore(ret, (AbstractInsnNode)new VarInsnNode(25, var.index));
            instructions.insertBefore(ret, (AbstractInsnNode)new InsnNode(89));
            instructions.insertBefore(ret, (AbstractInsnNode)new LdcInsnNode((Object)(method.name + ':' + var.name)));
            instructions.insertBefore(ret, (AbstractInsnNode)new MethodInsnNode(182, CodegenUtils.p(Var.class), "setName", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{String.class}), false));
            instructions.insertBefore(ret, (AbstractInsnNode)new InsnNode(83));
        }
    }
}

