/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.trees;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.parboiled.common.Formatter;
import org.parboiled.trees.GraphNode;

public final class GraphUtils {
    private GraphUtils() {
    }

    public static boolean hasChildren(@Nullable GraphNode<?> node) {
        return node != null && !node.getChildren().isEmpty();
    }

    @Nullable
    @Deprecated
    public static <T extends GraphNode<T>> T getFirstChild(@Nullable T node) {
        return (T)(GraphUtils.hasChildren(node) ? (GraphNode)node.getChildren().get(0) : null);
    }

    @Nullable
    @Deprecated
    public static <T extends GraphNode<T>> T getLastChild(@Nullable T node) {
        return (T)(GraphUtils.hasChildren(node) ? (GraphNode)node.getChildren().get(node.getChildren().size() - 1) : null);
    }

    public static <T extends GraphNode<T>> int countAllDistinct(@Nullable T node) {
        if (node == null) {
            return 0;
        }
        return GraphUtils.collectAllNodes(node, new HashSet()).size();
    }

    @Nonnull
    public static <T extends GraphNode<T>, C extends Collection<T>> C collectAllNodes(@Nullable T node, @Nonnull C collection) {
        Preconditions.checkNotNull(collection);
        if (node == null) {
            return collection;
        }
        if (collection.contains(node)) {
            return collection;
        }
        collection.add(node);
        for (GraphNode child : node.getChildren()) {
            GraphUtils.collectAllNodes(child, collection);
        }
        return collection;
    }

    @VisibleForTesting
    public static <T extends GraphNode<T>> String printTree(T node, Formatter<T> formatter) {
        Preconditions.checkNotNull(formatter, (Object)"formatter");
        return GraphUtils.printTree(node, formatter, Predicates.alwaysTrue(), Predicates.alwaysTrue());
    }

    @Nonnull
    public static <T extends GraphNode<T>> String printTree(@Nullable T node, @Nonnull Formatter<T> formatter, @Nonnull Predicate<T> nodeFilter, @Nonnull Predicate<T> subTreeFilter) {
        Preconditions.checkNotNull(formatter, (Object)"formatter");
        Preconditions.checkNotNull(nodeFilter, (Object)"nodeFilter");
        Preconditions.checkNotNull(subTreeFilter, (Object)"subTreeFilter");
        if (node == null) {
            return "";
        }
        return GraphUtils.printTree(node, formatter, "", new StringBuilder(), nodeFilter, subTreeFilter).toString();
    }

    private static <T extends GraphNode<T>> StringBuilder printTree(T node, Formatter<T> formatter, String indent, StringBuilder sb, Predicate<T> nodeFilter, Predicate<T> subTreeFilter) {
        String line;
        if (nodeFilter.apply(node) && (line = formatter.format(node)) != null) {
            sb.append(indent).append(line).append("\n");
            indent = indent + "  ";
        }
        if (!subTreeFilter.apply(node)) {
            return sb;
        }
        for (GraphNode sub : node.getChildren()) {
            GraphUtils.printTree(sub, formatter, indent, sb, nodeFilter, subTreeFilter);
        }
        return sb;
    }
}

