/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.apis.service.OdnoklassnikiServiceImpl;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;

public class OdnoklassnikiApi
extends DefaultApi20 {
    private static final String AUTHORIZE_URL = "https://connect.ok.ru/oauth/authorize?client_id=%s&response_type=code&redirect_uri=%s";

    protected OdnoklassnikiApi() {
    }

    public static OdnoklassnikiApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public String getAccessTokenEndpoint() {
        return "https://api.ok.ru/oauth/token.do";
    }

    public String getAuthorizationUrl(OAuthConfig config) {
        String state;
        Preconditions.checkValidUrl((String)config.getCallback(), (String)"Valid url is required for a callback. Odnoklassniki does not support OOB");
        StringBuilder urlBuilder = new StringBuilder(String.format(AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback())));
        if (config.hasScope()) {
            urlBuilder.append("&scope=").append(OAuthEncoder.encode((String)config.getScope()));
        }
        if ((state = config.getState()) != null) {
            urlBuilder.append("&state=").append(OAuthEncoder.encode((String)config.getState()));
        }
        return urlBuilder.toString();
    }

    public OAuth20Service createService(OAuthConfig config) {
        return new OdnoklassnikiServiceImpl(this, config);
    }

    private static class InstanceHolder {
        private static final OdnoklassnikiApi INSTANCE = new OdnoklassnikiApi();

        private InstanceHolder() {
        }
    }
}

