/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.collection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class TimedSizeCache {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    protected Map<String, CacheEntry> cacheMap;
    protected int maxSize;

    public TimedSizeCache(int maxSize) {
        this.maxSize = maxSize;
        this.cacheMap = new HashMap<String, CacheEntry>();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void put(String key, Object object) {
        this.put(key, object, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Object object, long timeout) {
        this.writeLock.lock();
        try {
            CacheEntry entry = new CacheEntry(key, object, timeout);
            if (this.isFull()) {
                this.pruneCache();
                if (this.isFull()) {
                    throw new IllegalStateException("exceed cache max size");
                }
            }
            this.cacheMap.put(key, entry);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        this.readLock.lock();
        try {
            CacheEntry entry = this.cacheMap.get(key);
            if (entry == null) {
                Object var3_3 = null;
                return var3_3;
            }
            if (entry.isExpired()) {
                this.cacheMap.remove(key);
                Object var3_4 = null;
                return var3_4;
            }
            Object object = entry.getObject();
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void prune() {
        this.writeLock.lock();
        try {
            this.pruneCache();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        if (this.maxSize == 0) {
            return false;
        }
        return this.cacheMap.size() >= this.maxSize;
    }

    public void remove(String key) {
        this.writeLock.lock();
        try {
            this.cacheMap.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int size() {
        return this.cacheMap.size();
    }

    private void pruneCache() {
        Iterator<CacheEntry> values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            CacheEntry entry = values.next();
            if (!entry.isExpired()) continue;
            values.remove();
        }
    }

    static class CacheEntry {
        final String key;
        final Object cachedObject;
        long expiredTime;

        CacheEntry(String key, Object object, long ttl) {
            this.key = key;
            this.cachedObject = object;
            this.expiredTime = ttl == 0L ? 0L : System.currentTimeMillis() + ttl;
        }

        boolean isExpired() {
            if (this.expiredTime == 0L) {
                return false;
            }
            return this.expiredTime < System.currentTimeMillis();
        }

        Object getObject() {
            return this.cachedObject;
        }
    }
}

