/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.io.finder;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jetbrick.io.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationClassReader {
    private static final Logger log = LoggerFactory.getLogger(AnnotationClassReader.class);
    private static final int CP_UTF8 = 1;
    private static final int CP_INTEGER = 3;
    private static final int CP_FLOAT = 4;
    private static final int CP_LONG = 5;
    private static final int CP_DOUBLE = 6;
    private static final int CP_CLASS = 7;
    private static final int CP_STRING = 8;
    private static final int CP_REF_FIELD = 9;
    private static final int CP_REF_METHOD = 10;
    private static final int CP_REF_INTERFACE = 11;
    private static final int CP_NAME_AND_TYPE = 12;
    private static final int BYTE = 66;
    private static final int CHAR = 67;
    private static final int DOUBLE = 68;
    private static final int FLOAT = 70;
    private static final int INT = 73;
    private static final int LONG = 74;
    private static final int SHORT = 83;
    private static final int BOOLEAN = 90;
    private static final int STRING = 115;
    private static final int ENUM = 101;
    private static final int CLASS = 99;
    private static final int ANNOTATION = 64;
    private static final int ARRAY = 91;
    private Set<String> annotationSet = new HashSet<String>();
    private Object[] constantPool;

    public boolean isAnnotationed(File file) {
        try {
            return this.isAnnotationed(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAnnotationed(ZipFile file, ZipEntry entry) {
        try {
            return this.isAnnotationed(file.getInputStream(entry));
        }
        catch (IOException e) {
            log.warn("IOException in load class file in jar file.", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnnotationed(InputStream classInputStream) {
        try {
            ClassFileDataInput input = new ClassFileDataInput(classInputStream);
            boolean bl = this.readClassFile(input);
            return bl;
        }
        catch (Exception e) {
            log.warn("UnknownException in parsing class file.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            IoUtils.closeQuietly(classInputStream);
        }
    }

    public void addAnnotation(Class<? extends Annotation> annoClass) {
        this.annotationSet.add('L' + annoClass.getName().replace('.', '/') + ';');
    }

    private boolean readClassFile(ClassFileDataInput di) throws IOException {
        if (!this.readMagicCode(di)) {
            return false;
        }
        if (!this.readVersion(di)) {
            return false;
        }
        this.readConstantPoolEntries(di);
        if (!this.readAccessFlags(di)) {
            return false;
        }
        this.readThisClass(di);
        this.readSuperClass(di);
        this.readInterfaces(di);
        this.readFields(di);
        this.readMethods(di);
        return this.readAttributes(di, ElementType.TYPE);
    }

    private boolean readMagicCode(ClassFileDataInput di) throws IOException {
        return di.size() > 4 && di.readInt() == -889275714;
    }

    private boolean readVersion(ClassFileDataInput di) throws IOException {
        int minor = di.readUnsignedShort();
        int major = di.readUnsignedShort();
        return major >= 49;
    }

    private void readConstantPoolEntries(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        this.constantPool = new Object[count];
        for (int i = 1; i < count; ++i) {
            if (!this.readConstantPoolEntry(di, i)) continue;
            ++i;
        }
    }

    private boolean readConstantPoolEntry(DataInput di, int index) throws IOException {
        int tag = di.readUnsignedByte();
        switch (tag) {
            case 1: {
                this.constantPool[index] = di.readUTF();
                return false;
            }
            case 3: {
                di.skipBytes(4);
                return false;
            }
            case 4: {
                di.skipBytes(4);
                return false;
            }
            case 5: {
                di.skipBytes(8);
                return true;
            }
            case 6: {
                di.skipBytes(8);
                return true;
            }
            case 7: 
            case 8: {
                this.constantPool[index] = di.readUnsignedShort();
                return false;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                di.skipBytes(4);
                return false;
            }
        }
        throw new ClassFormatError("Unknown tag value for constant pool entry: " + tag);
    }

    private boolean readAccessFlags(DataInput di) throws IOException {
        int flags = di.readUnsignedShort();
        if (!Modifier.isPublic(flags)) {
            return false;
        }
        return !Modifier.isInterface(flags) && !Modifier.isAbstract(flags);
    }

    private void readThisClass(DataInput di) throws IOException {
        di.skipBytes(2);
    }

    private void readSuperClass(DataInput di) throws IOException {
        di.skipBytes(2);
    }

    private void readInterfaces(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        di.skipBytes(count * 2);
    }

    private void readFields(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            di.skipBytes(6);
            this.readAttributes(di, ElementType.FIELD);
        }
    }

    private void readMethods(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            di.skipBytes(6);
            this.readAttributes(di, ElementType.METHOD);
        }
    }

    private boolean readAttributes(DataInput di, ElementType type) throws IOException {
        int count = di.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            String name = this.resolveUtf8(di);
            int length = di.readInt();
            if (type == ElementType.TYPE && ("RuntimeVisibleAnnotations".equals(name) || "RuntimeInvisibleAnnotations".equals(name))) {
                if (!this.readAnnotations(di)) continue;
                return true;
            }
            di.skipBytes(length);
        }
        return false;
    }

    private boolean readAnnotations(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            String annotation = this.readAnnotation(di);
            if (!this.annotationSet.contains(annotation)) continue;
            return true;
        }
        return false;
    }

    private String readAnnotation(DataInput di) throws IOException {
        String annotation = this.resolveUtf8(di);
        int count = di.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            di.skipBytes(2);
            this.readAnnotationElementValue(di);
        }
        return annotation;
    }

    private void readAnnotationElementValue(DataInput di) throws IOException {
        int tag = di.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                di.skipBytes(2);
                break;
            }
            case 101: {
                di.skipBytes(4);
                break;
            }
            case 99: {
                di.skipBytes(2);
                break;
            }
            case 64: {
                this.readAnnotation(di);
                break;
            }
            case 91: {
                int count = di.readUnsignedShort();
                for (int i = 0; i < count; ++i) {
                    this.readAnnotationElementValue(di);
                }
                break;
            }
            default: {
                throw new ClassFormatError("Not a valid annotation element type tag: 0x" + Integer.toHexString(tag));
            }
        }
    }

    private String resolveUtf8(DataInput di) throws IOException {
        int index = di.readUnsignedShort();
        Object value = this.constantPool[index];
        String s = value instanceof Integer ? (String)this.constantPool[(Integer)value] : (String)value;
        return s;
    }

    static class ClassFileDataInput
    implements DataInput {
        private byte[] buffer = new byte[8192];
        private int size;
        private int pointer;

        ClassFileDataInput(InputStream is) throws IOException {
            this.load(is);
        }

        private void load(InputStream in) throws IOException {
            int n;
            this.pointer = 0;
            this.size = 0;
            do {
                if ((n = in.read(this.buffer, this.size, this.buffer.length - this.size)) > 0) {
                    this.size += n;
                }
                this.ensureCapacity();
            } while (n >= 0);
        }

        public void seek(int position) throws IOException {
            if (position < 0) {
                throw new IllegalArgumentException("position < 0: " + position);
            }
            if (position > this.size) {
                throw new EOFException();
            }
            this.pointer = position;
        }

        public int size() {
            return this.size;
        }

        @Override
        public void readFully(byte[] bytes) throws IOException {
            this.readFully(bytes, 0, bytes.length);
        }

        @Override
        public void readFully(byte[] bytes, int offset, int length) throws IOException {
            if (length < 0 || offset < 0 || offset + length > bytes.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.pointer + length > this.size) {
                throw new EOFException();
            }
            System.arraycopy(this.buffer, this.pointer, bytes, offset, length);
            this.pointer += length;
        }

        @Override
        public int skipBytes(int n) throws IOException {
            this.seek(this.pointer + n);
            return n;
        }

        @Override
        public byte readByte() throws IOException {
            if (this.pointer >= this.size) {
                throw new EOFException();
            }
            return this.buffer[this.pointer++];
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.readByte() != 0;
        }

        @Override
        public int readUnsignedByte() throws IOException {
            if (this.pointer >= this.size) {
                throw new EOFException();
            }
            return this.read();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            if (this.pointer + 2 > this.size) {
                throw new EOFException();
            }
            return (this.read() << 8) + this.read();
        }

        @Override
        public short readShort() throws IOException {
            return (short)this.readUnsignedShort();
        }

        @Override
        public char readChar() throws IOException {
            return (char)this.readUnsignedShort();
        }

        @Override
        public int readInt() throws IOException {
            if (this.pointer + 4 > this.size) {
                throw new EOFException();
            }
            return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
        }

        @Override
        public long readLong() throws IOException {
            if (this.pointer + 8 > this.size) {
                throw new EOFException();
            }
            return ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + (long)(this.read() << 24) + (long)(this.read() << 16) + (long)(this.read() << 8) + (long)this.read();
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        @Override
        @Deprecated
        public String readLine() throws IOException {
            throw new UnsupportedOperationException("readLine() is deprecated and not supported");
        }

        @Override
        public String readUTF() throws IOException {
            return DataInputStream.readUTF(this);
        }

        private int read() {
            return this.buffer[this.pointer++] & 0xFF;
        }

        private void ensureCapacity() {
            if (this.size >= this.buffer.length) {
                byte[] newBuffer = new byte[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                this.buffer = newBuffer;
            }
        }
    }
}

