/**
 * Copyright 2013-2016 Guoqiang Chen, Shanghai, China. All rights reserved.
 *
 *   Author: Guoqiang Chen
 *    Email: subchen@gmail.com
 *   WebURL: https://github.com/subchen
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jetbrick.config;

import java.io.*;
import java.util.*;
import java.util.Map.Entry;
import jetbrick.collection.EmptyEnumeration;

@SuppressWarnings("serial")
public class EmptyProperties extends Properties {
    public static final EmptyProperties INSTANCE = new EmptyProperties();

    private EmptyProperties() {
    }

    @Override
    public String getProperty(String key) {
        return null;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return defaultValue;
    }

    @Override
    public Enumeration<?> propertyNames() {
        return EmptyEnumeration.instance();
    }

    @Override
    public Set<String> stringPropertyNames() {
        return Collections.emptySet();
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Enumeration<Object> keys() {
        return EmptyEnumeration.instance();
    }

    @Override
    public Enumeration<Object> elements() {
        return EmptyEnumeration.instance();
    }

    @Override
    public boolean contains(Object value) {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return false;
    }

    @Override
    public Object get(Object key) {
        return null;
    }

    @Override
    public Set<Object> keySet() {
        return Collections.emptySet();
    }

    @Override
    public Set<Entry<Object, Object>> entrySet() {
        return Collections.emptySet();
    }

    @Override
    public Collection<Object> values() {
        return Collections.emptyList();
    }

    @Override
    public void load(Reader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object setProperty(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}
