/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import jetbrick.config.Config;
import jetbrick.config.ExtendPropertiesLoader;
import jetbrick.config.XmlPropertiesLoader;
import jetbrick.io.IoUtils;
import jetbrick.util.ClassLoaderUtils;

public final class ConfigLoader {
    private static final Pattern PLACE_HOLDER_PATTERN = Pattern.compile("\\$\\{([^}]*)\\}");
    private final Map<String, String> config = new HashMap<String, String>(32);

    public ConfigLoader load(String name, String value) {
        this.config.put(name, value);
        return this;
    }

    public ConfigLoader load(Properties props) {
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            this.config.put(key, value);
        }
        return this;
    }

    public ConfigLoader load(Map<String, String> map) {
        this.config.putAll(map);
        return this;
    }

    public ConfigLoader load(String location) {
        if (location.startsWith("classpath:")) {
            location = location.substring("classpath:".length());
            return this.loadClasspath(location);
        }
        if (location.startsWith("file:")) {
            location = location.substring("file:".length());
            return this.load(new File(location));
        }
        return this.load(new File(location));
    }

    public ConfigLoader load(URL url) {
        String location = url.getPath();
        try {
            location = URLDecoder.decode(location, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            return this.loadInputStream(url.openStream(), location);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private ConfigLoader loadClasspath(String classpath) {
        if (classpath.startsWith("/")) {
            classpath = classpath.substring(1);
        }
        InputStream is = ClassLoaderUtils.getDefault().getResourceAsStream(classpath);
        return this.loadInputStream(is, classpath);
    }

    public ConfigLoader load(File file) {
        try {
            return this.loadInputStream(new FileInputStream(file), file.getName());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public ConfigLoader load(String location, ServletContext sc) {
        if (location.startsWith("classpath:") || location.startsWith("file:")) {
            return this.load(location);
        }
        if (location.startsWith("webroot:")) {
            location = location.substring("webroot:".length());
        }
        if (!location.startsWith("/")) {
            location = "/" + location;
        }
        InputStream is = sc.getResourceAsStream(location);
        return this.loadInputStream(is, location);
    }

    private ConfigLoader loadInputStream(InputStream is, String location) {
        if (is == null) {
            throw new IllegalStateException("InputStream not found: " + location);
        }
        if ((location = location.toLowerCase()).endsWith(".xml")) {
            Properties config = XmlPropertiesLoader.load(is, false);
            return this.load(config);
        }
        if (location.endsWith(".props")) {
            Properties config = ExtendPropertiesLoader.load(is);
            return this.load(config);
        }
        try {
            Properties config = new Properties();
            config.load(is);
            this.load(config);
            ConfigLoader configLoader = this;
            return configLoader;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    public ConfigLoader loadSystemProperties() {
        return this.load(System.getProperties());
    }

    public ConfigLoader loadSystemEnvs() {
        return this.load(System.getenv());
    }

    public ConfigLoader resolvePlaceholder() {
        for (Map.Entry<String, String> entry : this.config.entrySet()) {
            String value = entry.getValue();
            if (!value.contains("${")) continue;
            Matcher matcher = PLACE_HOLDER_PATTERN.matcher(value);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String name = matcher.group(1);
                String val = null;
                if (name.startsWith("ENV.")) {
                    name = name.substring(4);
                    val = System.getenv(name);
                } else {
                    val = this.config.get(name);
                    if (val == null) {
                        val = System.getProperty(name);
                    }
                }
                if (val == null) {
                    throw new IllegalStateException("cannot find variable `" + value + "` in environment variables");
                }
                matcher.appendReplacement(sb, Matcher.quoteReplacement(val));
            }
            matcher.appendTail(sb);
            entry.setValue(sb.toString());
        }
        return this;
    }

    public Map<String, String> asMap() {
        return Collections.unmodifiableMap(this.config);
    }

    public Properties asProperties() {
        Properties props = new Properties();
        props.putAll(this.config);
        return props;
    }

    public Config asConfig() {
        return new Config(this.config);
    }
}

