/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.io.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import jetbrick.io.resource.AbstractResource;
import jetbrick.io.resource.ResourceNotFoundException;
import jetbrick.util.ClassLoaderUtils;
import jetbrick.util.JdkUtils;
import jetbrick.util.StringUtils;
import jetbrick.util.Validate;

public final class ClasspathResource
extends AbstractResource {
    private final URL url;
    private final String path;

    public ClasspathResource(String path) {
        this(path, null);
    }

    public ClasspathResource(String path, ClassLoader loader) {
        Validate.notNull(path);
        this.path = path = StringUtils.removeStart(path, "/");
        this.relativePathName = path;
        if (loader == null) {
            loader = ClassLoaderUtils.getDefault();
        }
        this.url = loader == null ? ClassLoader.getSystemResource(path) : loader.getResource(path);
    }

    @Override
    public InputStream openStream() throws ResourceNotFoundException {
        if (this.url == null) {
            throw new ResourceNotFoundException(this.path);
        }
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public boolean exist() {
        return this.url != null;
    }

    @Override
    public boolean isDirectory() {
        return this.path.endsWith("/");
    }

    @Override
    public boolean isFile() {
        return !this.path.endsWith("/");
    }

    @Override
    public long length() {
        if (this.url == null) {
            return -1L;
        }
        try {
            if (JdkUtils.IS_AT_LEAST_JAVA_7) {
                return this.url.openConnection().getContentLengthLong();
            }
            return this.url.openConnection().getContentLength();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public long lastModified() {
        if (this.url == null) {
            return 0L;
        }
        String protocol = this.url.getProtocol();
        if ("file".equals(protocol)) {
            return new File(this.url.getFile()).lastModified();
        }
        if ("jar".equals(protocol) || "zip".equals(protocol)) {
            int pos;
            String file = this.url.getFile();
            if (file.startsWith("file:")) {
                file = file.substring("file:".length());
            }
            if ((pos = file.indexOf("!/")) != -1) {
                file = file.substring(0, pos);
            }
            return new File(file).lastModified();
        }
        try {
            return this.url.openConnection().getLastModified();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return "classpath:" + this.path;
    }
}

