/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import jetbrick.io.resource.Resource;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;
import jetbrick.util.JdkUtils;

public final class URIConvertor
implements Convertor<URI> {
    public static final URIConvertor INSTANCE = new URIConvertor();

    @Override
    public URI convert(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            throw TypeCastException.create(value, URI.class, e);
        }
    }

    @Override
    public URI convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == URI.class) {
            return (URI)value;
        }
        if (value instanceof File) {
            return ((File)value).toURI();
        }
        if (value.getClass() == URL.class) {
            try {
                return ((URL)value).toURI();
            }
            catch (URISyntaxException e) {
                throw TypeCastException.create(value, URI.class, e);
            }
        }
        if (value instanceof Resource) {
            return ((Resource)value).getURI();
        }
        if (JdkUtils.IS_AT_LEAST_JAVA_7 && value instanceof Path) {
            return ((Path)value).toUri();
        }
        return this.convert(value.toString());
    }
}

