/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import jetbrick.util.ArrayUtils;
import jetbrick.util.CharsetUtils;

public final class StringUtils {
    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNotEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean isBlank(String s) {
        int len;
        if (s == null || (len = s.length()) == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String s) {
        return !StringUtils.isBlank(s);
    }

    public static byte[] getBytes(String s, String charsetName) {
        if (s == null) {
            return null;
        }
        try {
            return s.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getUtf8Bytes(String s) {
        return s.getBytes(CharsetUtils.UTF_8);
    }

    public static String trim(String s) {
        return s == null ? null : s.trim();
    }

    public static String trimToNull(String s) {
        String ts = StringUtils.trim(s);
        return ts == null || ts.length() == 0 ? null : ts;
    }

    public static String trimToEmpty(String s) {
        return s == null ? "" : s.trim();
    }

    public static String[] trim(String[] ss) {
        if (ss != null) {
            for (int i = 0; i < ss.length; ++i) {
                String string = ss[i];
                if (string == null) continue;
                ss[i] = string.trim();
            }
        }
        return ss;
    }

    public static String defaultIfNull(String s, String defaultStr) {
        return s == null ? defaultStr : s;
    }

    public static String defaultIfEmpty(String s, String defaultStr) {
        return StringUtils.isEmpty(s) ? defaultStr : s;
    }

    public static String defaultIfBlank(String s, String defaultStr) {
        return StringUtils.isBlank(s) ? defaultStr : s;
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        if (s1 == s2) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean startsWith(String s, String prefix) {
        return StringUtils.startsWith(s, prefix, false);
    }

    public static boolean startsWithIgnoreCase(String s, String prefix) {
        return StringUtils.startsWith(s, prefix, true);
    }

    private static boolean startsWith(String s, String prefix, boolean ignoreCase) {
        if (s == null || prefix == null) {
            return s == null && prefix == null;
        }
        if (prefix.length() > s.length()) {
            return false;
        }
        return s.toString().regionMatches(ignoreCase, 0, prefix.toString(), 0, prefix.length());
    }

    public static int startsWithOne(String s, String ... dest) {
        for (int i = 0; i < dest.length; ++i) {
            String m = dest[i];
            if (m == null || !s.startsWith(m)) continue;
            return i;
        }
        return -1;
    }

    public static int startsWithOneIgnoreCase(String s, String ... dest) {
        for (int i = 0; i < dest.length; ++i) {
            String m = dest[i];
            if (m == null || !StringUtils.startsWithIgnoreCase(s, m)) continue;
            return i;
        }
        return -1;
    }

    public static boolean startsWithChar(String s, char c) {
        if (s == null || s.length() == 0) {
            return false;
        }
        return s.charAt(0) == c;
    }

    public static boolean endsWith(String s, String suffix) {
        return StringUtils.endsWith(s, suffix, false);
    }

    public static boolean endsWithIgnoreCase(String s, String suffix) {
        return StringUtils.endsWith(s, suffix, true);
    }

    private static boolean endsWith(String s, String suffix, boolean ignoreCase) {
        if (s == null || suffix == null) {
            return s == null && suffix == null;
        }
        if (suffix.length() > s.length()) {
            return false;
        }
        int strOffset = s.length() - suffix.length();
        return s.toString().regionMatches(ignoreCase, strOffset, suffix.toString(), 0, suffix.length());
    }

    public static int endsWithOne(String src, String ... dest) {
        for (int i = 0; i < dest.length; ++i) {
            String m = dest[i];
            if (m == null || !src.endsWith(m)) continue;
            return i;
        }
        return -1;
    }

    public static int endsWithOneIgnoreCase(String s, String ... dest) {
        for (int i = 0; i < dest.length; ++i) {
            String m = dest[i];
            if (m == null || !StringUtils.endsWithIgnoreCase(s, m)) continue;
            return i;
        }
        return -1;
    }

    public static boolean endsWithChar(String s, char c) {
        if (s == null || s.length() == 0) {
            return false;
        }
        return s.charAt(s.length() - 1) == c;
    }

    public static int indexOf(String s, String substr, int startIndex, int endIndex) {
        int sublen;
        int srclen;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > (srclen = s.length())) {
            endIndex = srclen;
        }
        if ((sublen = substr.length()) == 0) {
            return startIndex > srclen ? srclen : startIndex;
        }
        int total = endIndex - sublen + 1;
        char c = substr.charAt(0);
        block0: for (int i = startIndex; i < total; ++i) {
            if (s.charAt(i) != c) continue;
            int j = 1;
            int k = i + 1;
            while (j < sublen) {
                if (substr.charAt(j) != s.charAt(k)) continue block0;
                ++j;
                ++k;
            }
            return i;
        }
        return -1;
    }

    public static int indexOf(String s, char c, int startIndex, int endIndex) {
        int srclen;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > (srclen = s.length())) {
            endIndex = srclen;
        }
        for (int i = startIndex; i < endIndex; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String s, char c, int startIndex, int endIndex) {
        int srclen;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > (srclen = s.length())) {
            endIndex = srclen;
        }
        c = Character.toLowerCase(c);
        for (int i = startIndex; i < endIndex; ++i) {
            if (Character.toLowerCase(s.charAt(i)) != c) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String s, String substr) {
        return StringUtils.indexOfIgnoreCase(s, substr, 0, s.length());
    }

    public static int indexOfIgnoreCase(String s, String substr, int startIndex) {
        return StringUtils.indexOfIgnoreCase(s, substr, startIndex, s.length());
    }

    public static int indexOfIgnoreCase(String s, String substr, int startIndex, int endIndex) {
        int sublen;
        int srclen;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > (srclen = s.length())) {
            endIndex = srclen;
        }
        if ((sublen = substr.length()) == 0) {
            return startIndex > srclen ? srclen : startIndex;
        }
        substr = substr.toLowerCase();
        int total = endIndex - sublen + 1;
        char c = substr.charAt(0);
        block0: for (int i = startIndex; i < total; ++i) {
            if (Character.toLowerCase(s.charAt(i)) != c) continue;
            int j = 1;
            int k = i + 1;
            while (j < sublen) {
                char source = Character.toLowerCase(s.charAt(k));
                if (substr.charAt(j) != source) continue block0;
                ++j;
                ++k;
            }
            return i;
        }
        return -1;
    }

    public static int[] indexOf(String s, String[] arr) {
        return StringUtils.indexOf(s, arr, 0);
    }

    public static int[] indexOf(String s, String[] arr, int start) {
        int[] nArray;
        int arrLen = arr.length;
        int index = Integer.MAX_VALUE;
        int last = -1;
        for (int j = 0; j < arrLen; ++j) {
            int i = s.indexOf(arr[j], start);
            if (i == -1 || i >= index) continue;
            index = i;
            last = j;
        }
        if (last == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = last;
            nArray = nArray2;
            nArray2[1] = index;
        }
        return nArray;
    }

    public static int[] indexOf(String s, char[] c) {
        return StringUtils.indexOf(s, c, 0);
    }

    public static int[] indexOf(String s, char[] c, int start) {
        int[] nArray;
        int arrLen = c.length;
        int index = Integer.MAX_VALUE;
        int last = -1;
        for (int j = 0; j < arrLen; ++j) {
            int i = s.indexOf(c[j], start);
            if (i == -1 || i >= index) continue;
            index = i;
            last = j;
        }
        if (last == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = last;
            nArray = nArray2;
            nArray2[1] = index;
        }
        return nArray;
    }

    public static int[] indexOfIgnoreCase(String s, String[] arr) {
        return StringUtils.indexOfIgnoreCase(s, arr, 0);
    }

    public static int[] indexOfIgnoreCase(String s, String[] arr, int start) {
        int[] nArray;
        int arrLen = arr.length;
        int index = Integer.MAX_VALUE;
        int last = -1;
        for (int j = 0; j < arrLen; ++j) {
            int i = StringUtils.indexOfIgnoreCase(s, arr[j], start);
            if (i == -1 || i >= index) continue;
            index = i;
            last = j;
        }
        if (last == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = last;
            nArray = nArray2;
            nArray2[1] = index;
        }
        return nArray;
    }

    public static int lastIndexOfIgnoreCase(String s, String substr) {
        return StringUtils.lastIndexOfIgnoreCase(s, substr, s.length(), 0);
    }

    public static int lastIndexOfIgnoreCase(String s, String substr, int startIndex) {
        return StringUtils.lastIndexOfIgnoreCase(s, substr, startIndex, 0);
    }

    public static int lastIndexOfIgnoreCase(String s, String sub, int startIndex, int endIndex) {
        int sublen = sub.length();
        int srclen = s.length();
        if (sublen == 0) {
            return startIndex > srclen ? srclen : (startIndex < -1 ? -1 : startIndex);
        }
        sub = sub.toLowerCase();
        int total = srclen - sublen;
        if (total < 0) {
            return -1;
        }
        if (startIndex >= total) {
            startIndex = total;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        char c = sub.charAt(0);
        block0: for (int i = startIndex; i >= endIndex; --i) {
            if (Character.toLowerCase(s.charAt(i)) != c) continue;
            int j = 1;
            int k = i + 1;
            while (j < sublen) {
                char source = Character.toLowerCase(s.charAt(k));
                if (sub.charAt(j) != source) continue block0;
                ++j;
                ++k;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(String s, String sub, int startIndex, int endIndex) {
        int sublen = sub.length();
        int srclen = s.length();
        if (sublen == 0) {
            return startIndex > srclen ? srclen : (startIndex < -1 ? -1 : startIndex);
        }
        int total = srclen - sublen;
        if (total < 0) {
            return -1;
        }
        if (startIndex >= total) {
            startIndex = total;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        char c = sub.charAt(0);
        block0: for (int i = startIndex; i >= endIndex; --i) {
            if (s.charAt(i) != c) continue;
            int j = 1;
            int k = i + 1;
            while (j < sublen) {
                if (sub.charAt(j) != s.charAt(k)) continue block0;
                ++j;
                ++k;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(String s, char c, int startIndex, int endIndex) {
        int total = s.length() - 1;
        if (total < 0) {
            return -1;
        }
        if (startIndex >= total) {
            startIndex = total;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        for (int i = startIndex; i >= endIndex; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(String s, char c, int startIndex, int endIndex) {
        int total = s.length() - 1;
        if (total < 0) {
            return -1;
        }
        if (startIndex >= total) {
            startIndex = total;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        c = Character.toLowerCase(c);
        for (int i = startIndex; i >= endIndex; --i) {
            if (Character.toLowerCase(s.charAt(i)) != c) continue;
            return i;
        }
        return -1;
    }

    public static int[] lastIndexOf(String s, String[] arr) {
        return StringUtils.lastIndexOf(s, arr, s.length());
    }

    public static int[] lastIndexOf(String s, String[] arr, int fromIndex) {
        int[] nArray;
        int arrLen = arr.length;
        int index = -1;
        int last = -1;
        for (int j = 0; j < arrLen; ++j) {
            int i = s.lastIndexOf(arr[j], fromIndex);
            if (i == -1 || i <= index) continue;
            index = i;
            last = j;
        }
        if (last == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = last;
            nArray = nArray2;
            nArray2[1] = index;
        }
        return nArray;
    }

    public static int[] lastIndexOf(String s, char[] c) {
        return StringUtils.lastIndexOf(s, c, s.length());
    }

    public static int[] lastIndexOf(String s, char[] c, int fromIndex) {
        int[] nArray;
        int arrLen = c.length;
        int index = -1;
        int last = -1;
        for (int j = 0; j < arrLen; ++j) {
            int i = s.lastIndexOf(c[j], fromIndex);
            if (i == -1 || i <= index) continue;
            index = i;
            last = j;
        }
        if (last == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = last;
            nArray = nArray2;
            nArray2[1] = index;
        }
        return nArray;
    }

    public static int[] lastIndexOfIgnoreCase(String s, String[] arr) {
        return StringUtils.lastIndexOfIgnoreCase(s, arr, s.length());
    }

    public static int[] lastIndexOfIgnoreCase(String s, String[] arr, int fromIndex) {
        int[] nArray;
        int arrLen = arr.length;
        int index = -1;
        int last = -1;
        for (int j = 0; j < arrLen; ++j) {
            int i = StringUtils.lastIndexOfIgnoreCase(s, arr[j], fromIndex);
            if (i == -1 || i <= index) continue;
            index = i;
            last = j;
        }
        if (last == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = last;
            nArray = nArray2;
            nArray2[1] = index;
        }
        return nArray;
    }

    public static String substring(String s, int start) {
        if (s == null) {
            return null;
        }
        if (start < 0) {
            start = s.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > s.length()) {
            return "";
        }
        return s.substring(start);
    }

    public static String substring(String s, int start, int end) {
        if (s == null) {
            return null;
        }
        if (end < 0) {
            end = s.length() + end;
        }
        if (start < 0) {
            start = s.length() + start;
        }
        if (end > s.length()) {
            end = s.length();
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return s.substring(start, end);
    }

    public static String substringBefore(String s, String separator) {
        if (StringUtils.isEmpty(s) || separator == null) {
            return s;
        }
        if (separator.isEmpty()) {
            return "";
        }
        int pos = s.indexOf(separator);
        if (pos < 0) {
            return s;
        }
        return s.substring(0, pos);
    }

    public static String substringAfter(String s, String separator) {
        if (StringUtils.isEmpty(s)) {
            return s;
        }
        if (separator == null) {
            return "";
        }
        int pos = s.indexOf(separator);
        if (pos < 0) {
            return "";
        }
        return s.substring(pos + separator.length());
    }

    public static String substringBeforeLast(String s, String separator) {
        if (StringUtils.isEmpty(s) || StringUtils.isEmpty(separator)) {
            return s;
        }
        int pos = s.lastIndexOf(separator);
        if (pos < 0) {
            return s;
        }
        return s.substring(0, pos);
    }

    public static String substringAfterLast(String s, String separator) {
        if (StringUtils.isEmpty(s)) {
            return s;
        }
        if (StringUtils.isEmpty(separator)) {
            return "";
        }
        int pos = s.lastIndexOf(separator);
        if (pos < 0 || pos == s.length() - separator.length()) {
            return "";
        }
        return s.substring(pos + separator.length());
    }

    public static String substringBetween(String s, String tag) {
        return StringUtils.substringBetween(s, tag, tag);
    }

    public static String substringBetween(String s, String open, String close) {
        int end;
        if (s == null || open == null || close == null) {
            return null;
        }
        int start = s.indexOf(open);
        if (start >= 0 && (end = s.indexOf(close, start + open.length())) >= 0) {
            return s.substring(start + open.length(), end);
        }
        return null;
    }

    public static String left(String s, int len) {
        if (s == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (s.length() <= len) {
            return s;
        }
        return s.substring(0, len);
    }

    public static String right(String s, int len) {
        if (s == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (s.length() <= len) {
            return s;
        }
        return s.substring(s.length() - len);
    }

    public static String mid(String s, int pos, int len) {
        if (s == null) {
            return null;
        }
        if (len < 0 || pos > s.length()) {
            return "";
        }
        if (pos < 0) {
            pos = 0;
        }
        if (s.length() <= pos + len) {
            return s.substring(pos);
        }
        return s.substring(pos, pos + len);
    }

    public static String repeat(String s, int repeat) {
        if (s == null) {
            return null;
        }
        if (repeat <= 0) {
            return "";
        }
        int inputLength = s.length();
        if (repeat == 1 || inputLength == 0) {
            return s;
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return StringUtils.repeat(s.charAt(0), repeat);
            }
            case 2: {
                char ch0 = s.charAt(0);
                char ch1 = s.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(s);
        }
        return buf.toString();
    }

    public static String repeat(String s, String separator, int repeat) {
        if (s == null || separator == null) {
            return StringUtils.repeat(s, repeat);
        }
        String result = StringUtils.repeat(s + separator, repeat);
        return StringUtils.removeEnd(result, separator);
    }

    public static String repeat(char ch, int repeat) {
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static String leftPad(String str, int size) {
        return StringUtils.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.leftPad(str, size, String.valueOf(padChar));
        }
        return StringUtils.repeat(padChar, pads).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static String rightPad(String str, int size) {
        return StringUtils.rightPad(str, size, ' ');
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(StringUtils.repeat(padChar, pads));
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String center(String str, int size) {
        return StringUtils.center(str, size, ' ');
    }

    public static String center(String str, int size, char padChar) {
        if (str == null || size <= 0) {
            return str;
        }
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        str = StringUtils.leftPad(str, strLen + pads / 2, padChar);
        str = StringUtils.rightPad(str, size, padChar);
        return str;
    }

    public static String reverse(String s) {
        StringBuilder result = new StringBuilder(s.length());
        for (int i = s.length() - 1; i >= 0; --i) {
            result.append(s.charAt(i));
        }
        return result.toString();
    }

    public static String deleteWhitespace(String s) {
        if (StringUtils.isEmpty(s)) {
            return s;
        }
        int sz = s.length();
        char[] chs = new char[sz];
        int count = 0;
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            chs[count++] = s.charAt(i);
        }
        if (count == sz) {
            return s;
        }
        return new String(chs, 0, count);
    }

    public static String removeStart(String s, String remove) {
        if (StringUtils.isEmpty(s) || StringUtils.isEmpty(remove)) {
            return s;
        }
        if (s.startsWith(remove)) {
            return s.substring(remove.length());
        }
        return s;
    }

    public static String removeStartIgnoreCase(String s, String remove) {
        if (StringUtils.isEmpty(s) || StringUtils.isEmpty(remove)) {
            return s;
        }
        if (StringUtils.startsWithIgnoreCase(s, remove)) {
            return s.substring(remove.length());
        }
        return s;
    }

    public static String removeEnd(String s, String remove) {
        if (StringUtils.isEmpty(s) || StringUtils.isEmpty(remove)) {
            return s;
        }
        if (s.endsWith(remove)) {
            return s.substring(0, s.length() - remove.length());
        }
        return s;
    }

    public static String removeEndIgnoreCase(String s, String remove) {
        if (StringUtils.isEmpty(s) || StringUtils.isEmpty(remove)) {
            return s;
        }
        if (StringUtils.endsWithIgnoreCase(s, remove)) {
            return s.substring(0, s.length() - remove.length());
        }
        return s;
    }

    public static String remove(String s, String remove) {
        if (StringUtils.isEmpty(s) || StringUtils.isEmpty(remove)) {
            return s;
        }
        return StringUtils.replace(s, remove, "", -1);
    }

    public static String remove(String s, char remove) {
        if (StringUtils.isEmpty(s) || s.indexOf(remove) < 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == remove) continue;
            chars[pos++] = chars[i];
        }
        return new String(chars, 0, pos);
    }

    public static String removeChars(String s, String chars) {
        int i = s.length();
        StringBuilder sb = new StringBuilder(i);
        for (int j = 0; j < i; ++j) {
            char c = s.charAt(j);
            if (chars.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String removeChars(String s, char ... chars) {
        int i = s.length();
        StringBuilder sb = new StringBuilder(i);
        block0: for (int j = 0; j < i; ++j) {
            char c = s.charAt(j);
            for (char aChar : chars) {
                if (c == aChar) continue block0;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String prefix(String s, String prefix) {
        if (!s.startsWith(prefix)) {
            s = prefix + s;
        }
        return s;
    }

    public static String suffix(String s, String suffix) {
        if (!s.endsWith(suffix)) {
            s = s + suffix;
        }
        return s;
    }

    public static String replaceOnce(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, 1);
    }

    public static String replacePattern(String source, String regex, String replacement) {
        return Pattern.compile(regex, 32).matcher(source).replaceAll(replacement);
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end >= 0) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end >= 0) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        return StringUtils.replaceEach(text, searchList, replacementList, false, 0);
    }

    public static String replaceEachRepeatedly(String text, String[] searchList, String[] replacementList) {
        int timeToLive = searchList == null ? 0 : searchList.length;
        return StringUtils.replaceEach(text, searchList, replacementList, true, timeToLive);
    }

    private static String replaceEach(String text, String[] searchList, String[] replacementList, boolean repeat, int timeToLive) {
        if (text == null || text.isEmpty() || searchList == null || searchList.length == 0 || replacementList == null || replacementList.length == 0) {
            return text;
        }
        if (timeToLive < 0) {
            throw new IllegalStateException("Aborting to protect against StackOverflowError - output of one loop is the input of another");
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        int tempIndex = -1;
        for (int i = 0; i < searchLength; ++i) {
            if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].isEmpty() || replacementList[i] == null) continue;
            tempIndex = text.indexOf(searchList[i]);
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = 0;
        for (int i = 0; i < searchList.length; ++i) {
            int greater;
            if (searchList[i] == null || replacementList[i] == null || (greater = replacementList[i].length() - searchList[i].length()) <= 0) continue;
            increase += 3 * greater;
        }
        increase = Math.min(increase, text.length() / 5);
        StringBuilder buf = new StringBuilder(text.length() + increase);
        while (textIndex != -1) {
            int i;
            for (i = start; i < textIndex; ++i) {
                buf.append(text.charAt(i));
            }
            buf.append(replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            textIndex = -1;
            replaceIndex = -1;
            tempIndex = -1;
            for (i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].isEmpty() || replacementList[i] == null) continue;
                tempIndex = text.indexOf(searchList[i], start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
        }
        int textLength = text.length();
        for (int i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        String result = buf.toString();
        if (!repeat) {
            return result;
        }
        return StringUtils.replaceEach(result, searchList, replacementList, repeat, timeToLive - 1);
    }

    public static String replaceChars(String str, char searchChar, char replaceChar) {
        if (str == null) {
            return null;
        }
        return str.replace(searchChar, replaceChar);
    }

    public static String replaceChars(String str, String searchChars, String replaceChars) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(searchChars)) {
            return str;
        }
        if (replaceChars == null) {
            replaceChars = "";
        }
        boolean modified = false;
        int replaceCharsLength = replaceChars.length();
        int strLength = str.length();
        StringBuilder buf = new StringBuilder(strLength);
        for (int i = 0; i < strLength; ++i) {
            char ch = str.charAt(i);
            int index = searchChars.indexOf(ch);
            if (index >= 0) {
                modified = true;
                if (index >= replaceCharsLength) continue;
                buf.append(replaceChars.charAt(index));
                continue;
            }
            buf.append(ch);
        }
        if (modified) {
            return buf.toString();
        }
        return str;
    }

    public static String[] split(String str, String delimiter) {
        if (str == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        int ipos = 0;
        int lastpos = 0;
        while ((ipos = str.indexOf(delimiter, lastpos)) != -1) {
            results.add(str.substring(lastpos, ipos));
            lastpos = ipos + delimiter.length();
        }
        results.add(str.substring(lastpos));
        return results.toArray(new String[results.size()]);
    }

    public static String[] split(String str, char delimiter) {
        if (str == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        int ipos = 0;
        int lastpos = 0;
        while ((ipos = str.indexOf(delimiter, lastpos)) != -1) {
            results.add(str.substring(lastpos, ipos));
            lastpos = ipos + 1;
        }
        results.add(str.substring(lastpos));
        return results.toArray(new String[results.size()]);
    }

    public static String[] splitChars(String str, String delimiters) {
        if (str == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        int lastpos = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (delimiters.indexOf(c) == -1) continue;
            results.add(str.substring(lastpos, i));
            lastpos = i + 1;
        }
        results.add(str.substring(lastpos));
        return results.toArray(new String[results.size()]);
    }

    public static String[] splitChars(String str, char ... delimiters) {
        if (str == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        int lastpos = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!ArrayUtils.contains(delimiters, c)) continue;
            results.add(str.substring(lastpos, i));
            lastpos = i + 1;
        }
        results.add(str.substring(lastpos));
        return results.toArray(new String[results.size()]);
    }

    public static String[] splitCSV(String str) {
        if (str == null) {
            return null;
        }
        String[] parts = StringUtils.split(str, ',');
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < parts.length; ++i) {
            String s = parts[i].trim();
            if (s.length() == 0) {
                results.add(s);
                continue;
            }
            char c = s.charAt(0);
            if (c == '\"' || c == '\'' || c == '`') {
                StringBuilder sb = new StringBuilder();
                sb.append(s);
                while (i + 1 < parts.length && (sb.length() <= 1 || s.length() <= 0 || s.charAt(s.length() - 1) != c)) {
                    s = parts[++i];
                    sb.append(',').append(s);
                }
                s = sb.toString().trim();
                if (s.charAt(s.length() - 1) == c) {
                    s = s.substring(1, s.length() - 1);
                }
                results.add(s);
                continue;
            }
            results.add(s);
        }
        return results.toArray(new String[results.size()]);
    }

    public static String join(String ... parts) {
        StringBuilder sb = new StringBuilder(parts.length);
        for (String part : parts) {
            sb.append(part);
        }
        return sb.toString();
    }

    public static String join(Iterable<?> elements, String separator) {
        if (elements == null) {
            return "";
        }
        return StringUtils.join(elements.iterator(), separator);
    }

    public static String join(Iterator<?> elements, String separator) {
        if (elements == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (elements.hasNext()) {
            Object o = elements.next();
            if (sb.length() > 0 && separator != null) {
                sb.append(separator);
            }
            sb.append(o);
        }
        return sb.toString();
    }

    public static String join(Object[] elements, String separator) {
        if (elements == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : elements) {
            if (sb.length() > 0 && separator != null) {
                sb.append(separator);
            }
            sb.append(o);
        }
        return sb.toString();
    }

    public static int count(String source, String substr) {
        return StringUtils.count(source, substr, 0);
    }

    public static int count(String source, String substr, int start) {
        int i;
        if (source == null || source.length() == 0) {
            return 0;
        }
        int count = 0;
        int j = start;
        int sublen = substr.length();
        if (sublen == 0) {
            return 0;
        }
        while ((i = source.indexOf(substr, j)) != -1) {
            ++count;
            j = i + sublen;
        }
        return count;
    }

    public static int count(String source, char c) {
        return StringUtils.count(source, c, 0);
    }

    public static int count(String source, char c, int start) {
        int i;
        if (source == null || source.length() == 0) {
            return 0;
        }
        int count = 0;
        int j = start;
        while ((i = source.indexOf(c, j)) != -1) {
            ++count;
            j = i + 1;
        }
        return count;
    }
}

