/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util;

import jetbrick.util.StringUtils;
import jetbrick.util.WildcharUtils;

public class WildcharPathUtils {
    protected static final String PATH_MATCH = "**";
    protected static final String PATH_SEPARATORS = "/\\";

    public static boolean matchPath(String path, String pattern) {
        String[] pathElements = StringUtils.splitChars(path, PATH_SEPARATORS);
        String[] patternElements = StringUtils.splitChars(pattern, PATH_SEPARATORS);
        return WildcharPathUtils.matchTokens(pathElements, patternElements);
    }

    public static int matchPathOne(String path, String[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            if (!WildcharPathUtils.matchPath(path, patterns[i])) continue;
            return i;
        }
        return -1;
    }

    protected static boolean matchTokens(String[] tokens, String[] patterns) {
        String patDir;
        int tokNdxStart;
        int patNdxStart = 0;
        int patNdxEnd = patterns.length - 1;
        int tokNdxEnd = tokens.length - 1;
        for (tokNdxStart = 0; patNdxStart <= patNdxEnd && tokNdxStart <= tokNdxEnd && !(patDir = patterns[patNdxStart]).equals(PATH_MATCH); ++patNdxStart, ++tokNdxStart) {
            if (WildcharUtils.match(tokens[tokNdxStart], patDir)) continue;
            return false;
        }
        if (tokNdxStart > tokNdxEnd) {
            for (int i = patNdxStart; i <= patNdxEnd; ++i) {
                if (patterns[i].equals(PATH_MATCH)) continue;
                return false;
            }
            return true;
        }
        if (patNdxStart > patNdxEnd) {
            return false;
        }
        while (patNdxStart <= patNdxEnd && tokNdxStart <= tokNdxEnd && !(patDir = patterns[patNdxEnd]).equals(PATH_MATCH)) {
            if (!WildcharUtils.match(tokens[tokNdxEnd], patDir)) {
                return false;
            }
            --patNdxEnd;
            --tokNdxEnd;
        }
        if (tokNdxStart > tokNdxEnd) {
            for (int i = patNdxStart; i <= patNdxEnd; ++i) {
                if (patterns[i].equals(PATH_MATCH)) continue;
                return false;
            }
            return true;
        }
        while (patNdxStart != patNdxEnd && tokNdxStart <= tokNdxEnd) {
            int patIdxTmp = -1;
            for (int i = patNdxStart + 1; i <= patNdxEnd; ++i) {
                if (!patterns[i].equals(PATH_MATCH)) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patNdxStart + 1) {
                ++patNdxStart;
                continue;
            }
            int patLength = patIdxTmp - patNdxStart - 1;
            int strLength = tokNdxEnd - tokNdxStart + 1;
            int ndx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subStr = tokens[tokNdxStart + i + j];
                    String subPat = patterns[patNdxStart + j + 1];
                    if (!WildcharUtils.match(subStr, subPat)) continue block6;
                }
                ndx = tokNdxStart + i;
                break;
            }
            if (ndx == -1) {
                return false;
            }
            patNdxStart = patIdxTmp;
            tokNdxStart = ndx + patLength;
        }
        for (int i = patNdxStart; i <= patNdxEnd; ++i) {
            if (patterns[i].equals(PATH_MATCH)) continue;
            return false;
        }
        return true;
    }
}

