/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.web.springboot;

import java.util.Properties;
import jetbrick.template.JetEngine;
import jetbrick.template.loader.ClasspathResourceLoader;
import jetbrick.template.web.springboot.JetTemplateProperties;
import jetbrick.template.web.springmvc.JetTemplateViewResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={JetEngine.class})
@ConditionalOnProperty(value={"spring.jetbrick.template.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={JetTemplateProperties.class})
public class JetTemplateAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={JetTemplateViewResolver.class})
    public JetTemplateViewResolver jetTemplateViewResolver(JetTemplateProperties properties) {
        Properties config = properties.getConfig();
        if (config == null) {
            config = new Properties();
        }
        if (!config.containsKey("jetx.template.loaders")) {
            config.put("jetx.template.loaders", ClasspathResourceLoader.class.getName());
        }
        JetTemplateViewResolver resolver = new JetTemplateViewResolver();
        resolver.setPrefix(properties.getPrefix());
        resolver.setSuffix(properties.getSuffix());
        resolver.setCache(properties.isCache());
        resolver.setViewNames(properties.getViewNames());
        resolver.setContentType(properties.getContentType().toString());
        resolver.setOrder(properties.getOrder());
        resolver.setConfigProperties(config);
        resolver.setConfigLocation(properties.getConfigLocation());
        return resolver;
    }
}

