/**
 * Copyright 2013-2014 Guoqiang Chen, Shanghai, China. All rights reserved.
 *
 *   Author: Guoqiang Chen
 *    Email: subchen@gmail.com
 *   WebURL: https://github.com/subchen
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jetbrick.web.mvc;

import jetbrick.util.builder.ToStringBuilder;
import jetbrick.web.mvc.action.ActionInfo;
import jetbrick.web.mvc.action.PathVariables;

/**
 * 路由匹配结果（包括路径参数）
 */
public class RouteInfo {
    public static final RouteInfo NOT_FOUND = new RouteInfo(null);
    private final ActionInfo action;
    private final PathVariables pathVariables;

    public RouteInfo(ActionInfo action) {
        this.action = action;
        this.pathVariables = null;
    }

    public RouteInfo(ActionInfo action, PathVariables pathVariables) {
        this.action = action;
        this.pathVariables = pathVariables;
    }

    public ActionInfo getAction() {
        return action;
    }

    public String getPathVariable(String name) {
        if (pathVariables != null) {
            return pathVariables.getValue(name);
        }
        return null;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflection(this);
    }
}
