/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.TextType;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ContentTypes {
    private static final Map<String, String> COMMON_MIME_TYPES = ImmutableMap.builder().put((Object)"image/jpeg", (Object)"jpeg").put((Object)"image/gif", (Object)"gif").put((Object)"image/tiff", (Object)"tiff").put((Object)"image/png", (Object)"png").put((Object)"image/x-icon", (Object)"ico").put((Object)"image/svg+xml", (Object)"svg").put((Object)"audio/x-aiff", (Object)"aiff").put((Object)"video/x-ms-asf", (Object)"asf").put((Object)"video/mpeg", (Object)"mp2").put((Object)"audio/mpeg", (Object)"mp3").put((Object)"video/quicktime", (Object)"mov").put((Object)"application/pdf", (Object)"pdf").build();
    public static final List<String> TEXT_FILE_EXTENSIONS = Arrays.asList("txt", "json", "xml", "html", "htm", "yaml", "csv");
    public static final List<String> TEXT_MIME_TYPE_PATTERNS = Arrays.asList(".*text.*", ".*json.*", ".*xml.*", ".*html.*", ".*yaml.*", ".*csv.*", ".*x-www-form-urlencoded.*");

    public static String determineFileExtension(String url, ContentTypeHeader contentTypeHeader, byte[] responseBody) {
        String path;
        String lastPathSegment;
        if (contentTypeHeader.isPresent()) {
            if (contentTypeHeader.mimeTypePart().contains("json")) {
                return "json";
            }
            if (contentTypeHeader.mimeTypePart().contains("xml")) {
                return "xml";
            }
            if (contentTypeHeader.mimeTypePart().contains("text")) {
                return "txt";
            }
            String extension = COMMON_MIME_TYPES.get(contentTypeHeader.mimeTypePart());
            if (extension != null) {
                return extension;
            }
        }
        if ((lastPathSegment = StringUtils.substringAfterLast((String)(path = URI.create(url).getPath()), (String)"/")).indexOf(46) != -1) {
            return StringUtils.substringAfterLast((String)lastPathSegment, (String)".");
        }
        return ContentTypes.determineTextFileExtension(Strings.stringFromBytes(responseBody, contentTypeHeader.charset()));
    }

    public static TextType determineTextType(String content) {
        try {
            Json.read(content, JsonNode.class);
            return TextType.JSON;
        }
        catch (Exception e) {
            try {
                Xml.read(content);
                return TextType.XML;
            }
            catch (Exception e1) {
                return TextType.PLAIN_TEXT;
            }
        }
    }

    public static String determineTextFileExtension(String content) {
        TextType textType = ContentTypes.determineTextType(content);
        switch (textType) {
            case JSON: {
                return "json";
            }
            case XML: {
                return "xml";
            }
        }
        return "txt";
    }

    public static boolean determineIsTextFromExtension(String extension) {
        return TEXT_FILE_EXTENSIONS.contains(extension);
    }

    public static boolean determineIsTextFromMimeType(final String mimeType) {
        return Iterables.any(TEXT_MIME_TYPE_PATTERNS, (Predicate)new Predicate<String>(){

            public boolean apply(String pattern) {
                return mimeType != null && mimeType.matches(pattern);
            }
        });
    }

    public static boolean determineIsText(String extension, String mimeType) {
        return ContentTypes.determineIsTextFromExtension(extension) || ContentTypes.determineIsTextFromMimeType(mimeType);
    }
}

