/*
 * Decompiled with CFR 0.152.
 */
package com.wf.captcha.utils;

import com.wf.captcha.Captcha;
import com.wf.captcha.GifCaptcha;
import com.wf.captcha.SpecCaptcha;
import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CaptchaUtil {
    private static final String SESSION_KEY = "captcha";

    public static boolean ver(String code, HttpServletRequest request) {
        if (code != null && !code.trim().isEmpty()) {
            String captcha = (String)request.getSession().getAttribute(SESSION_KEY);
            return code.trim().toLowerCase().equals(captcha);
        }
        return false;
    }

    public static void out(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.out(5, request, response);
    }

    public static void out(int len, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.out(130, 48, len, request, response);
    }

    public static void out(int len, Font font, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.out(130, 48, len, font, request, response);
    }

    public static void out(int width, int height, int len, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.out(width, height, len, null, request, response);
    }

    public static void out(int width, int height, int len, Font font, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.outCaptcha(width, height, len, font, 1, request, response);
    }

    public static void outPng(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.outPng(5, request, response);
    }

    public static void outPng(int len, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.outPng(130, 48, len, request, response);
    }

    public static void outPng(int len, Font font, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.outPng(130, 48, len, font, request, response);
    }

    public static void outPng(int width, int height, int len, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.outPng(width, height, len, null, request, response);
    }

    public static void outPng(int width, int height, int len, Font font, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.outCaptcha(width, height, len, font, 0, request, response);
    }

    private static void outCaptcha(int width, int height, int len, Font font, int cType, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.setHeader(response);
        Captcha captcha = null;
        if (cType == 0) {
            captcha = new SpecCaptcha(width, height, len);
        } else if (cType == 1) {
            captcha = new GifCaptcha(width, height, len);
        }
        if (font != null) {
            captcha.setFont(font);
        }
        request.getSession().setAttribute(SESSION_KEY, (Object)captcha.text().toLowerCase());
        captcha.out((OutputStream)response.getOutputStream());
    }

    public static void clear(HttpServletRequest request) {
        request.getSession().removeAttribute(SESSION_KEY);
    }

    public static void setHeader(HttpServletResponse response) {
        response.setContentType("image/gif");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
    }
}

