/*
 * Decompiled with CFR 0.152.
 */
package com.multilevel.treelist;

import com.multilevel.treelist.Node;
import java.util.ArrayList;
import java.util.List;

public class TreeHelper {
    public static List<Node> getSortedNodes(List<Node> datas, int defaultExpandLevel) {
        ArrayList<Node> result = new ArrayList<Node>();
        List<Node> nodes = TreeHelper.convetData2Node(datas);
        List<Node> rootNodes = TreeHelper.getRootNodes(nodes);
        for (Node node : rootNodes) {
            TreeHelper.addNode(result, node, defaultExpandLevel, 1);
        }
        return result;
    }

    public static List<Node> filterVisibleNode(List<Node> nodes) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!node.isRoot() && !node.isParentExpand()) continue;
            TreeHelper.setNodeIcon(node);
            result.add(node);
        }
        return result;
    }

    private static List<Node> convetData2Node(List<Node> nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node n = nodes.get(i);
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node m = nodes.get(j);
                if (m.getpId() instanceof String) {
                    if (m.getpId().equals(n.getId())) {
                        n.getChildren().add(m);
                        m.setParent(n);
                        continue;
                    }
                    if (!m.getId().equals(n.getpId())) continue;
                    m.getChildren().add(n);
                    n.setParent(m);
                    continue;
                }
                if (m.getpId() == n.getId()) {
                    n.getChildren().add(m);
                    m.setParent(n);
                    continue;
                }
                if (m.getId() != n.getpId()) continue;
                m.getChildren().add(n);
                n.setParent(m);
            }
        }
        return nodes;
    }

    private static List<Node> getRootNodes(List<Node> nodes) {
        ArrayList<Node> root = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!node.isRoot()) continue;
            root.add(node);
        }
        return root;
    }

    private static <T, B> void addNode(List<Node> nodes, Node<T, B> node, int defaultExpandLeval, int currentLevel) {
        nodes.add(node);
        if (node.isNewAdd && defaultExpandLeval >= currentLevel) {
            node.setExpand(true);
        }
        if (node.isLeaf()) {
            return;
        }
        for (int i = 0; i < node.getChildren().size(); ++i) {
            TreeHelper.addNode(nodes, node.getChildren().get(i), defaultExpandLeval, currentLevel + 1);
        }
    }

    private static void setNodeIcon(Node node) {
        if (node.getChildren().size() > 0 && node.isExpand()) {
            node.setIcon(node.iconExpand);
        } else if (node.getChildren().size() > 0 && !node.isExpand()) {
            node.setIcon(node.iconNoExpand);
        } else {
            node.setIcon(-1);
        }
    }
}

