/*
 * Decompiled with CFR 0.152.
 */
package com.multilevel.treelist;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import com.multilevel.treelist.Node;
import com.multilevel.treelist.OnTreeNodeClickListener;
import com.multilevel.treelist.TreeHelper;
import java.util.ArrayList;
import java.util.List;

public abstract class TreeListViewAdapter
extends BaseAdapter {
    protected Context mContext;
    protected List<Node> mNodes = new ArrayList<Node>();
    protected LayoutInflater mInflater;
    protected List<Node> mAllNodes = new ArrayList<Node>();
    private OnTreeNodeClickListener onTreeNodeClickListener;
    private int defaultExpandLevel = 0;
    private int iconExpand = -1;
    private int iconNoExpand = -1;

    public void setOnTreeNodeClickListener(OnTreeNodeClickListener onTreeNodeClickListener) {
        this.onTreeNodeClickListener = onTreeNodeClickListener;
    }

    public TreeListViewAdapter(ListView mTree, Context context, List<Node> datas, int defaultExpandLevel, int iconExpand, int iconNoExpand) {
        this.iconExpand = iconExpand;
        this.iconNoExpand = iconNoExpand;
        for (Node node : datas) {
            node.getChildren().clear();
            node.iconExpand = iconExpand;
            node.iconNoExpand = iconNoExpand;
        }
        this.defaultExpandLevel = defaultExpandLevel;
        this.mContext = context;
        this.mAllNodes = TreeHelper.getSortedNodes(datas, defaultExpandLevel);
        this.mNodes = TreeHelper.filterVisibleNode(this.mAllNodes);
        this.mInflater = LayoutInflater.from((Context)context);
        mTree.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                TreeListViewAdapter.this.expandOrCollapse(position);
                if (TreeListViewAdapter.this.onTreeNodeClickListener != null) {
                    TreeListViewAdapter.this.onTreeNodeClickListener.onClick(TreeListViewAdapter.this.mNodes.get(position), position);
                }
            }
        });
    }

    public TreeListViewAdapter(ListView mTree, Context context, List<Node> datas, int defaultExpandLevel) {
        this(mTree, context, datas, defaultExpandLevel, -1, -1);
    }

    public void addDataAll(List<Node> mlists, int defaultExpandLevel) {
        this.mAllNodes.clear();
        this.addData(-1, mlists, defaultExpandLevel);
    }

    public void addData(int index, List<Node> mlists, int defaultExpandLevel) {
        this.defaultExpandLevel = defaultExpandLevel;
        this.notifyData(index, mlists);
    }

    public void addData(int index, List<Node> mlists) {
        this.notifyData(index, mlists);
    }

    public void addData(List<Node> mlists) {
        this.addData(mlists, this.defaultExpandLevel);
    }

    public void addData(List<Node> mlists, int defaultExpandLevel) {
        this.defaultExpandLevel = defaultExpandLevel;
        this.notifyData(-1, mlists);
    }

    public void addData(Node node) {
        this.addData(node, this.defaultExpandLevel);
    }

    public void addData(Node node, int defaultExpandLevel) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(node);
        this.defaultExpandLevel = defaultExpandLevel;
        this.notifyData(-1, nodes);
    }

    public void removeData(Node node) {
        if (node == null) {
            return;
        }
        this.removeDeleteNode(node);
        for (Node n : this.mAllNodes) {
            n.getChildren().clear();
        }
        this.mAllNodes = TreeHelper.getSortedNodes(this.mAllNodes, this.defaultExpandLevel);
        this.mNodes = TreeHelper.filterVisibleNode(this.mAllNodes);
        this.notifyDataSetChanged();
    }

    public void removeData(List<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        for (Node node : nodes) {
            this.removeDeleteNode(node);
        }
        for (Node n : this.mAllNodes) {
            n.getChildren().clear();
        }
        this.mAllNodes = TreeHelper.getSortedNodes(this.mAllNodes, this.defaultExpandLevel);
        this.mNodes = TreeHelper.filterVisibleNode(this.mAllNodes);
        this.notifyDataSetChanged();
    }

    private void removeDeleteNode(Node node) {
        if (node == null) {
            return;
        }
        List<Node> childrens = node.getChildren();
        if (childrens != null && !childrens.isEmpty()) {
            for (Node n : childrens) {
                this.removeDeleteNode(n);
            }
        }
        this.mAllNodes.remove(node);
    }

    private void notifyData(int index, List<Node> mListNodes) {
        Node node;
        int i;
        for (i = 0; i < mListNodes.size(); ++i) {
            node = mListNodes.get(i);
            node.getChildren().clear();
            node.iconExpand = this.iconExpand;
            node.iconNoExpand = this.iconNoExpand;
        }
        for (i = 0; i < this.mAllNodes.size(); ++i) {
            node = this.mAllNodes.get(i);
            node.getChildren().clear();
            node.isNewAdd = false;
        }
        if (index != -1) {
            this.mAllNodes.addAll(index, mListNodes);
        } else {
            this.mAllNodes.addAll(mListNodes);
        }
        this.mAllNodes = TreeHelper.getSortedNodes(this.mAllNodes, this.defaultExpandLevel);
        this.mNodes = TreeHelper.filterVisibleNode(this.mAllNodes);
        this.notifyDataSetChanged();
    }

    public List<Node> getAllNodes() {
        if (this.mAllNodes == null) {
            this.mAllNodes = new ArrayList<Node>();
        }
        return this.mAllNodes;
    }

    public void expandOrCollapse(int position) {
        Node n = this.mNodes.get(position);
        if (n != null && !n.isLeaf()) {
            n.setExpand(!n.isExpand());
            this.mNodes = TreeHelper.filterVisibleNode(this.mAllNodes);
            this.notifyDataSetChanged();
        }
    }

    public int getCount() {
        return this.mNodes.size();
    }

    public Object getItem(int position) {
        return this.mNodes.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Node node = this.mNodes.get(position);
        convertView = this.getConvertView(node, position, convertView, parent);
        convertView.setPadding(node.getLevel() * 30, 3, 3, 3);
        return convertView;
    }

    protected void setChecked(Node node, boolean checked) {
        node.setChecked(checked);
        this.setChildChecked(node, checked);
        if (node.getParent() != null) {
            this.setNodeParentChecked(node.getParent(), checked);
        }
        this.notifyDataSetChanged();
    }

    public <T, B> void setChildChecked(Node<T, B> node, boolean checked) {
        if (!node.isLeaf()) {
            node.setChecked(checked);
            for (Node childrenNode : node.getChildren()) {
                this.setChildChecked(childrenNode, checked);
            }
        } else {
            node.setChecked(checked);
        }
    }

    private void setNodeParentChecked(Node node, boolean checked) {
        if (checked) {
            node.setChecked(checked);
            if (node.getParent() != null) {
                this.setNodeParentChecked(node.getParent(), checked);
            }
        } else {
            List<Node> childrens = node.getChildren();
            boolean isChecked = false;
            for (Node children : childrens) {
                if (!children.isChecked()) continue;
                isChecked = true;
            }
            if (!isChecked) {
                node.setChecked(checked);
            }
            if (node.getParent() != null) {
                this.setNodeParentChecked(node.getParent(), checked);
            }
        }
    }

    public abstract View getConvertView(Node var1, int var2, View var3, ViewGroup var4);
}

