/*
 * Decompiled with CFR 0.152.
 */
package com.zyyoona7.wheel;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.media.AudioManager;
import android.media.SoundPool;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.Scroller;
import com.zyyoona7.wheel.IWheelEntity;
import com.zyyoona7.wheel.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class WheelView<T>
extends View
implements Runnable {
    private static final String TAG = "WheelView";
    private static final float DEFAULT_LINE_SPACING = WheelView.dp2px(2.0f);
    private static final float DEFAULT_TEXT_SIZE = WheelView.sp2px(15.0f);
    private static final float DEFAULT_TEXT_BOUNDARY_MARGIN = WheelView.dp2px(2.0f);
    private static final float DEFAULT_DIVIDER_HEIGHT = WheelView.dp2px(1.0f);
    private static final int DEFAULT_NORMAL_TEXT_COLOR = -12303292;
    private static final int DEFAULT_SELECTED_TEXT_COLOR = -16777216;
    private static final int DEFAULT_VISIBLE_ITEM = 5;
    private static final int DEFAULT_SCROLL_DURATION = 250;
    private static final long DEFAULT_CLICK_CONFIRM = 120L;
    private static final String DEFAULT_INTEGER_FORMAT = "%02d";
    private static final float DEFAULT_REFRACT_RATIO = 1.0f;
    public static final int TEXT_ALIGN_LEFT = 0;
    public static final int TEXT_ALIGN_CENTER = 1;
    public static final int TEXT_ALIGN_RIGHT = 2;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SCROLLING = 2;
    public static final int CURVED_ARC_DIRECTION_LEFT = 0;
    public static final int CURVED_ARC_DIRECTION_CENTER = 1;
    public static final int CURVED_ARC_DIRECTION_RIGHT = 2;
    public static final float DEFAULT_CURVED_FACTOR = 0.75f;
    public static final int DIVIDER_TYPE_FILL = 0;
    public static final int DIVIDER_TYPE_WRAP = 1;
    private Paint mPaint = new Paint(1);
    private float mTextSize;
    private boolean isAutoFitTextSize;
    private Paint.FontMetrics mFontMetrics;
    private int mItemHeight;
    private int mMaxTextWidth;
    private int mCenterToBaselineY;
    private int mVisibleItems;
    private float mLineSpacing;
    private boolean isCyclic;
    private int mTextAlign;
    private int mTextColor;
    private int mSelectedItemTextColor;
    private boolean isShowDivider;
    private int mDividerColor;
    private float mDividerSize;
    private int mDividerType;
    private float mDividerPaddingForWrap;
    private Paint.Cap mDividerCap = Paint.Cap.ROUND;
    private float mDividerOffset;
    private boolean isDrawSelectedRect;
    private int mSelectedRectColor;
    private int mStartX;
    private int mCenterX;
    private int mCenterY;
    private int mSelectedItemTopLimit;
    private int mSelectedItemBottomLimit;
    private int mClipLeft;
    private int mClipTop;
    private int mClipRight;
    private int mClipBottom;
    private Rect mDrawRect;
    private float mTextBoundaryMargin;
    private boolean isIntegerNeedFormat;
    private String mIntegerFormat;
    private Camera mCamera;
    private Matrix mMatrix;
    private boolean isCurved;
    private int mCurvedArcDirection;
    private float mCurvedArcDirectionFactor;
    private float mRefractRatio;
    @NonNull
    private List<T> mDataList = new ArrayList<T>(1);
    private boolean isResetSelectedPosition = false;
    private VelocityTracker mVelocityTracker;
    private int mMaxFlingVelocity;
    private int mMinFlingVelocity;
    private Scroller mScroller;
    private int mMinScrollY;
    private int mMaxScrollY;
    private int mScrollOffsetY;
    private int mScrolledY = 0;
    private float mLastTouchY;
    private long mDownStartTime;
    private boolean isForceFinishScroll = false;
    private boolean isFlingScroll;
    private int mSelectedItemPosition;
    private int mCurrentScrollPosition;
    private boolean mIsBoldForSelectedItem = false;
    private Typeface mNormalTypeface = null;
    private Typeface mBoldTypeface = null;
    private OnItemSelectedListener<T> mOnItemSelectedListener;
    private OnWheelChangedListener mOnWheelChangedListener;
    private SoundHelper mSoundHelper;
    private boolean isSoundEffect = false;

    public WheelView(Context context) {
        this(context, null);
    }

    public WheelView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WheelView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrsAndDefault(context, attrs);
        this.initValue(context);
    }

    private void initAttrsAndDefault(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.WheelView);
        this.mTextSize = typedArray.getDimension(R.styleable.WheelView_wv_textSize, DEFAULT_TEXT_SIZE);
        this.isAutoFitTextSize = typedArray.getBoolean(R.styleable.WheelView_wv_autoFitTextSize, false);
        this.mTextAlign = typedArray.getInt(R.styleable.WheelView_wv_textAlign, 1);
        this.mTextBoundaryMargin = typedArray.getDimension(R.styleable.WheelView_wv_textBoundaryMargin, DEFAULT_TEXT_BOUNDARY_MARGIN);
        this.mTextColor = typedArray.getColor(R.styleable.WheelView_wv_normalItemTextColor, -12303292);
        this.mSelectedItemTextColor = typedArray.getColor(R.styleable.WheelView_wv_selectedItemTextColor, -16777216);
        this.mLineSpacing = typedArray.getDimension(R.styleable.WheelView_wv_lineSpacing, DEFAULT_LINE_SPACING);
        this.isIntegerNeedFormat = typedArray.getBoolean(R.styleable.WheelView_wv_integerNeedFormat, false);
        this.mIntegerFormat = typedArray.getString(R.styleable.WheelView_wv_integerFormat);
        if (TextUtils.isEmpty((CharSequence)this.mIntegerFormat)) {
            this.mIntegerFormat = DEFAULT_INTEGER_FORMAT;
        }
        this.mVisibleItems = typedArray.getInt(R.styleable.WheelView_wv_visibleItems, 5);
        this.mVisibleItems = this.adjustVisibleItems(this.mVisibleItems);
        this.mCurrentScrollPosition = this.mSelectedItemPosition = typedArray.getInt(R.styleable.WheelView_wv_selectedItemPosition, 0);
        this.isCyclic = typedArray.getBoolean(R.styleable.WheelView_wv_cyclic, false);
        this.isShowDivider = typedArray.getBoolean(R.styleable.WheelView_wv_showDivider, false);
        this.mDividerType = typedArray.getInt(R.styleable.WheelView_wv_dividerType, 0);
        this.mDividerSize = typedArray.getDimension(R.styleable.WheelView_wv_dividerHeight, DEFAULT_DIVIDER_HEIGHT);
        this.mDividerColor = typedArray.getColor(R.styleable.WheelView_wv_dividerColor, -16777216);
        this.mDividerPaddingForWrap = typedArray.getDimension(R.styleable.WheelView_wv_dividerPaddingForWrap, DEFAULT_TEXT_BOUNDARY_MARGIN);
        this.mDividerOffset = typedArray.getDimensionPixelOffset(R.styleable.WheelView_wv_dividerOffset, 0);
        this.isDrawSelectedRect = typedArray.getBoolean(R.styleable.WheelView_wv_drawSelectedRect, false);
        this.mSelectedRectColor = typedArray.getColor(R.styleable.WheelView_wv_selectedRectColor, 0);
        this.isCurved = typedArray.getBoolean(R.styleable.WheelView_wv_curved, true);
        this.mCurvedArcDirection = typedArray.getInt(R.styleable.WheelView_wv_curvedArcDirection, 1);
        this.mCurvedArcDirectionFactor = typedArray.getFloat(R.styleable.WheelView_wv_curvedArcDirectionFactor, 0.75f);
        float curvedRefractRatio = typedArray.getFloat(R.styleable.WheelView_wv_curvedRefractRatio, 0.9f);
        this.mRefractRatio = typedArray.getFloat(R.styleable.WheelView_wv_refractRatio, 1.0f);
        float f = this.mRefractRatio = this.isCurved ? Math.min(curvedRefractRatio, this.mRefractRatio) : this.mRefractRatio;
        if (this.mRefractRatio > 1.0f) {
            this.mRefractRatio = 1.0f;
        } else if (this.mRefractRatio < 0.0f) {
            this.mRefractRatio = 1.0f;
        }
        typedArray.recycle();
    }

    private void initValue(Context context) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mMaxFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mMinFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mScroller = new Scroller(context);
        this.mDrawRect = new Rect();
        this.mCamera = new Camera();
        this.mMatrix = new Matrix();
        if (!this.isInEditMode()) {
            this.mSoundHelper = SoundHelper.obtain();
            this.initDefaultVolume(context);
        }
        this.calculateTextSize();
        this.updateTextAlign();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mSoundHelper != null) {
            this.mSoundHelper.release();
        }
    }

    private void initDefaultVolume(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null) {
            int currentVolume = audioManager.getStreamVolume(3);
            int maxVolume = audioManager.getStreamMaxVolume(3);
            this.mSoundHelper.setPlayVolume((float)currentVolume * 1.0f / (float)maxVolume);
        } else {
            this.mSoundHelper.setPlayVolume(0.3f);
        }
    }

    private void calculateTextSize() {
        this.mPaint.setTextSize(this.mTextSize);
        for (int i = 0; i < this.mDataList.size(); ++i) {
            int textWidth = (int)this.mPaint.measureText(this.getDataText(this.mDataList.get(i)));
            this.mMaxTextWidth = Math.max(textWidth, this.mMaxTextWidth);
        }
        this.mFontMetrics = this.mPaint.getFontMetrics();
        this.mItemHeight = (int)(this.mFontMetrics.bottom - this.mFontMetrics.top + this.mLineSpacing);
    }

    private void updateTextAlign() {
        switch (this.mTextAlign) {
            case 0: {
                this.mPaint.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 2: {
                this.mPaint.setTextAlign(Paint.Align.RIGHT);
                break;
            }
            default: {
                this.mPaint.setTextAlign(Paint.Align.CENTER);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = this.isCurved ? (int)((double)(this.mItemHeight * this.mVisibleItems * 2) / Math.PI + (double)this.getPaddingTop() + (double)this.getPaddingBottom()) : this.mItemHeight * this.mVisibleItems + this.getPaddingTop() + this.getPaddingBottom();
        int width = (int)((float)(this.mMaxTextWidth + this.getPaddingLeft() + this.getPaddingRight()) + this.mTextBoundaryMargin * 2.0f);
        if (this.isCurved) {
            int towardRange = (int)(Math.sin(0.06544984694978735) * (double)height);
            width += towardRange;
        }
        this.setMeasuredDimension(WheelView.resolveSizeAndState((int)width, (int)widthMeasureSpec, (int)0), WheelView.resolveSizeAndState((int)height, (int)heightMeasureSpec, (int)0));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mDrawRect.set(this.getPaddingLeft(), this.getPaddingTop(), this.getWidth() - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom());
        this.mCenterX = this.mDrawRect.centerX();
        this.mCenterY = this.mDrawRect.centerY();
        this.mSelectedItemTopLimit = (int)((float)(this.mCenterY - this.mItemHeight / 2) - this.mDividerOffset);
        this.mSelectedItemBottomLimit = (int)((float)(this.mCenterY + this.mItemHeight / 2) + this.mDividerOffset);
        this.mClipLeft = this.getPaddingLeft();
        this.mClipTop = this.getPaddingTop();
        this.mClipRight = this.getWidth() - this.getPaddingRight();
        this.mClipBottom = this.getHeight() - this.getPaddingBottom();
        this.calculateDrawStart();
        this.calculateLimitY();
        int itemDistance = this.calculateItemDistance(this.mSelectedItemPosition);
        if (itemDistance > 0) {
            this.doScroll(itemDistance);
        }
    }

    private void calculateDrawStart() {
        switch (this.mTextAlign) {
            case 0: {
                this.mStartX = (int)((float)this.getPaddingLeft() + this.mTextBoundaryMargin);
                break;
            }
            case 2: {
                this.mStartX = (int)((float)(this.getWidth() - this.getPaddingRight()) - this.mTextBoundaryMargin);
                break;
            }
            default: {
                this.mStartX = this.getWidth() / 2;
            }
        }
        this.mCenterToBaselineY = (int)(this.mFontMetrics.ascent + (this.mFontMetrics.descent - this.mFontMetrics.ascent) / 2.0f);
    }

    private void calculateLimitY() {
        this.mMinScrollY = this.isCyclic ? Integer.MIN_VALUE : 0;
        this.mMaxScrollY = this.isCyclic ? Integer.MAX_VALUE : (this.mDataList.size() - 1) * this.mItemHeight;
    }

    protected void onDraw(Canvas canvas) {
        int maxIndex;
        int minIndex;
        super.onDraw(canvas);
        this.drawSelectedRect(canvas);
        this.drawDivider(canvas);
        int scrolledItem = this.mScrollOffsetY / this.dividedItemHeight();
        int scrolledOffset = this.mScrollOffsetY % this.dividedItemHeight();
        int halfItem = (this.mVisibleItems + 1) / 2;
        if (scrolledOffset < 0) {
            minIndex = scrolledItem - halfItem - 1;
            maxIndex = scrolledItem + halfItem;
        } else if (scrolledOffset > 0) {
            minIndex = scrolledItem - halfItem;
            maxIndex = scrolledItem + halfItem + 1;
        } else {
            minIndex = scrolledItem - halfItem;
            maxIndex = scrolledItem + halfItem;
        }
        for (int i = minIndex; i < maxIndex; ++i) {
            if (this.isCurved) {
                this.draw3DItem(canvas, i, scrolledOffset);
                continue;
            }
            this.drawItem(canvas, i, scrolledOffset);
        }
    }

    private void drawSelectedRect(Canvas canvas) {
        if (this.isDrawSelectedRect) {
            this.mPaint.setColor(this.mSelectedRectColor);
            canvas.drawRect((float)this.mClipLeft, (float)this.mSelectedItemTopLimit, (float)this.mClipRight, (float)this.mSelectedItemBottomLimit, this.mPaint);
        }
    }

    private void drawDivider(Canvas canvas) {
        if (this.isShowDivider) {
            this.mPaint.setColor(this.mDividerColor);
            float originStrokeWidth = this.mPaint.getStrokeWidth();
            this.mPaint.setStrokeJoin(Paint.Join.ROUND);
            this.mPaint.setStrokeCap(Paint.Cap.ROUND);
            this.mPaint.setStrokeWidth(this.mDividerSize);
            if (this.mDividerType == 0) {
                canvas.drawLine((float)this.mClipLeft, (float)this.mSelectedItemTopLimit, (float)this.mClipRight, (float)this.mSelectedItemTopLimit, this.mPaint);
                canvas.drawLine((float)this.mClipLeft, (float)this.mSelectedItemBottomLimit, (float)this.mClipRight, (float)this.mSelectedItemBottomLimit, this.mPaint);
            } else {
                int startX = (int)((float)(this.mCenterX - this.mMaxTextWidth / 2) - this.mDividerPaddingForWrap);
                int stopX = (int)((float)(this.mCenterX + this.mMaxTextWidth / 2) + this.mDividerPaddingForWrap);
                int wrapStartX = startX < this.mClipLeft ? this.mClipLeft : startX;
                int wrapStopX = stopX > this.mClipRight ? this.mClipRight : stopX;
                canvas.drawLine((float)wrapStartX, (float)this.mSelectedItemTopLimit, (float)wrapStopX, (float)this.mSelectedItemTopLimit, this.mPaint);
                canvas.drawLine((float)wrapStartX, (float)this.mSelectedItemBottomLimit, (float)wrapStopX, (float)this.mSelectedItemBottomLimit, this.mPaint);
            }
            this.mPaint.setStrokeWidth(originStrokeWidth);
        }
    }

    private void drawItem(Canvas canvas, int index, int scrolledOffset) {
        int centerToBaselineY;
        String text = this.getDataByIndex(index);
        if (text == null) {
            return;
        }
        int item2CenterOffsetY = (index - this.mScrollOffsetY / this.dividedItemHeight()) * this.mItemHeight - scrolledOffset;
        int startX = this.mStartX;
        int n = centerToBaselineY = this.isAutoFitTextSize ? this.remeasureTextSize(text) : this.mCenterToBaselineY;
        if (Math.abs(item2CenterOffsetY) <= 0) {
            this.mPaint.setColor(this.mSelectedItemTextColor);
            this.clipAndDraw2DText(canvas, text, this.mSelectedItemTopLimit, this.mSelectedItemBottomLimit, item2CenterOffsetY, centerToBaselineY);
        } else if (item2CenterOffsetY > 0 && item2CenterOffsetY < this.mItemHeight) {
            this.mPaint.setColor(this.mSelectedItemTextColor);
            this.clipAndDraw2DText(canvas, text, this.mSelectedItemTopLimit, this.mSelectedItemBottomLimit, item2CenterOffsetY, centerToBaselineY);
            this.mPaint.setColor(this.mTextColor);
            float textSize = this.mPaint.getTextSize();
            this.mPaint.setTextSize(textSize * this.mRefractRatio);
            this.changeTypefaceIfBoldForSelectedItem();
            this.clipAndDraw2DText(canvas, text, this.mSelectedItemBottomLimit, this.mClipBottom, item2CenterOffsetY, centerToBaselineY);
            this.mPaint.setTextSize(textSize);
            this.resetTypefaceIfBoldForSelectedItem();
        } else if (item2CenterOffsetY < 0 && item2CenterOffsetY > -this.mItemHeight) {
            this.mPaint.setColor(this.mSelectedItemTextColor);
            this.clipAndDraw2DText(canvas, text, this.mSelectedItemTopLimit, this.mSelectedItemBottomLimit, item2CenterOffsetY, centerToBaselineY);
            this.mPaint.setColor(this.mTextColor);
            float textSize = this.mPaint.getTextSize();
            this.mPaint.setTextSize(textSize * this.mRefractRatio);
            this.changeTypefaceIfBoldForSelectedItem();
            this.clipAndDraw2DText(canvas, text, this.mClipTop, this.mSelectedItemTopLimit, item2CenterOffsetY, centerToBaselineY);
            this.mPaint.setTextSize(textSize);
            this.resetTypefaceIfBoldForSelectedItem();
        } else {
            this.mPaint.setColor(this.mTextColor);
            float textSize = this.mPaint.getTextSize();
            this.mPaint.setTextSize(textSize * this.mRefractRatio);
            this.changeTypefaceIfBoldForSelectedItem();
            this.clipAndDraw2DText(canvas, text, this.mClipTop, this.mClipBottom, item2CenterOffsetY, centerToBaselineY);
            this.mPaint.setTextSize(textSize);
            this.resetTypefaceIfBoldForSelectedItem();
        }
        if (this.isAutoFitTextSize) {
            this.mPaint.setTextSize(this.mTextSize);
            this.mStartX = startX;
        }
    }

    private void clipAndDraw2DText(Canvas canvas, String text, int clipTop, int clipBottom, int item2CenterOffsetY, int centerToBaselineY) {
        canvas.save();
        canvas.clipRect(this.mClipLeft, clipTop, this.mClipRight, clipBottom);
        canvas.drawText(text, 0, text.length(), (float)this.mStartX, (float)(this.mCenterY + item2CenterOffsetY - centerToBaselineY), this.mPaint);
        canvas.restore();
    }

    private int remeasureTextSize(String contentText) {
        float textWidth = this.mPaint.measureText(contentText);
        float textMargin = this.mTextBoundaryMargin * 2.0f;
        float drawWidth = this.getWidth();
        if (textMargin > drawWidth / 10.0f) {
            drawWidth = drawWidth * 9.0f / 10.0f;
            textMargin = drawWidth / 10.0f;
        } else {
            drawWidth -= textMargin;
        }
        if (drawWidth <= 0.0f) {
            return this.mCenterToBaselineY;
        }
        float textSize = this.mTextSize;
        while (textWidth > drawWidth && !((textSize -= 1.0f) <= 0.0f)) {
            this.mPaint.setTextSize(textSize);
            textWidth = this.mPaint.measureText(contentText);
        }
        this.recalculateStartX(textMargin / 2.0f);
        return this.recalculateCenterToBaselineY();
    }

    private void recalculateStartX(float textMargin) {
        switch (this.mTextAlign) {
            case 0: {
                this.mStartX = (int)textMargin;
                break;
            }
            case 2: {
                this.mStartX = (int)((float)this.getWidth() - textMargin);
                break;
            }
            default: {
                this.mStartX = this.getWidth() / 2;
            }
        }
    }

    private int recalculateCenterToBaselineY() {
        Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
        return (int)(fontMetrics.ascent + (fontMetrics.descent - fontMetrics.ascent) / 2.0f);
    }

    private void draw3DItem(Canvas canvas, int index, int scrolledOffset) {
        int centerToBaselineY;
        String text = this.getDataByIndex(index);
        if (text == null) {
            return;
        }
        int radius = (this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) / 2;
        int item2CenterOffsetY = (index - this.mScrollOffsetY / this.dividedItemHeight()) * this.mItemHeight - scrolledOffset;
        if ((double)Math.abs(item2CenterOffsetY) > (double)radius * Math.PI / 2.0) {
            return;
        }
        double angle = (double)item2CenterOffsetY / (double)radius;
        float rotateX = (float)Math.toDegrees(-angle);
        float translateY = (float)(Math.sin(angle) * (double)radius);
        float translateZ = (float)((1.0 - Math.cos(angle)) * (double)radius);
        int alpha = (int)(Math.cos(angle) * 255.0);
        int startX = this.mStartX;
        int n = centerToBaselineY = this.isAutoFitTextSize ? this.remeasureTextSize(text) : this.mCenterToBaselineY;
        if (Math.abs(item2CenterOffsetY) <= 0) {
            this.mPaint.setColor(this.mSelectedItemTextColor);
            this.mPaint.setAlpha(255);
            this.clipAndDraw3DText(canvas, text, this.mSelectedItemTopLimit, this.mSelectedItemBottomLimit, rotateX, translateY, translateZ, centerToBaselineY);
        } else if (item2CenterOffsetY > 0 && item2CenterOffsetY < this.mItemHeight) {
            this.mPaint.setColor(this.mSelectedItemTextColor);
            this.mPaint.setAlpha(255);
            this.clipAndDraw3DText(canvas, text, this.mSelectedItemTopLimit, this.mSelectedItemBottomLimit, rotateX, translateY, translateZ, centerToBaselineY);
            this.mPaint.setColor(this.mTextColor);
            this.mPaint.setAlpha(alpha);
            float textSize = this.mPaint.getTextSize();
            this.mPaint.setTextSize(textSize * this.mRefractRatio);
            this.changeTypefaceIfBoldForSelectedItem();
            int reCenterToBaselineY = this.recalculateCenterToBaselineY();
            this.clipAndDraw3DText(canvas, text, this.mSelectedItemBottomLimit, this.mClipBottom, rotateX, translateY, translateZ, reCenterToBaselineY);
            this.mPaint.setTextSize(textSize);
            this.resetTypefaceIfBoldForSelectedItem();
        } else if (item2CenterOffsetY < 0 && item2CenterOffsetY > -this.mItemHeight) {
            this.mPaint.setColor(this.mSelectedItemTextColor);
            this.mPaint.setAlpha(255);
            this.clipAndDraw3DText(canvas, text, this.mSelectedItemTopLimit, this.mSelectedItemBottomLimit, rotateX, translateY, translateZ, centerToBaselineY);
            this.mPaint.setColor(this.mTextColor);
            this.mPaint.setAlpha(alpha);
            float textSize = this.mPaint.getTextSize();
            this.mPaint.setTextSize(textSize * this.mRefractRatio);
            this.changeTypefaceIfBoldForSelectedItem();
            int reCenterToBaselineY = this.recalculateCenterToBaselineY();
            this.clipAndDraw3DText(canvas, text, this.mClipTop, this.mSelectedItemTopLimit, rotateX, translateY, translateZ, reCenterToBaselineY);
            this.mPaint.setTextSize(textSize);
            this.resetTypefaceIfBoldForSelectedItem();
        } else {
            this.mPaint.setColor(this.mTextColor);
            this.mPaint.setAlpha(alpha);
            float textSize = this.mPaint.getTextSize();
            this.mPaint.setTextSize(textSize * this.mRefractRatio);
            this.changeTypefaceIfBoldForSelectedItem();
            int reCenterToBaselineY = this.recalculateCenterToBaselineY();
            this.clipAndDraw3DText(canvas, text, this.mClipTop, this.mClipBottom, rotateX, translateY, translateZ, reCenterToBaselineY);
            this.mPaint.setTextSize(textSize);
            this.resetTypefaceIfBoldForSelectedItem();
        }
        if (this.isAutoFitTextSize) {
            this.mPaint.setTextSize(this.mTextSize);
            this.mStartX = startX;
        }
    }

    private void clipAndDraw3DText(Canvas canvas, String text, int clipTop, int clipBottom, float rotateX, float offsetY, float offsetZ, int centerToBaselineY) {
        canvas.save();
        canvas.clipRect(this.mClipLeft, clipTop, this.mClipRight, clipBottom);
        this.draw3DText(canvas, text, rotateX, offsetY, offsetZ, centerToBaselineY);
        canvas.restore();
    }

    private void draw3DText(Canvas canvas, String text, float rotateX, float offsetY, float offsetZ, int centerToBaselineY) {
        this.mCamera.save();
        this.mCamera.translate(0.0f, 0.0f, offsetZ);
        this.mCamera.rotateX(rotateX);
        this.mCamera.getMatrix(this.mMatrix);
        this.mCamera.restore();
        float centerX = this.mCenterX;
        if (this.mCurvedArcDirection == 0) {
            centerX = (float)this.mCenterX * (1.0f + this.mCurvedArcDirectionFactor);
        } else if (this.mCurvedArcDirection == 2) {
            centerX = (float)this.mCenterX * (1.0f - this.mCurvedArcDirectionFactor);
        }
        float centerY = (float)this.mCenterY + offsetY;
        this.mMatrix.preTranslate(-centerX, -centerY);
        this.mMatrix.postTranslate(centerX, centerY);
        canvas.concat(this.mMatrix);
        canvas.drawText(text, 0, text.length(), (float)this.mStartX, centerY - (float)centerToBaselineY, this.mPaint);
    }

    private void changeTypefaceIfBoldForSelectedItem() {
        if (this.mIsBoldForSelectedItem) {
            this.mPaint.setTypeface(this.mNormalTypeface);
        }
    }

    private void resetTypefaceIfBoldForSelectedItem() {
        if (this.mIsBoldForSelectedItem) {
            this.mPaint.setTypeface(this.mBoldTypeface);
        }
    }

    private String getDataByIndex(int index) {
        int dataSize = this.mDataList.size();
        if (dataSize == 0) {
            return null;
        }
        String itemText = null;
        if (this.isCyclic) {
            int i = index % dataSize;
            if (i < 0) {
                i += dataSize;
            }
            itemText = this.getDataText(this.mDataList.get(i));
        } else if (index >= 0 && index < dataSize) {
            itemText = this.getDataText(this.mDataList.get(index));
        }
        return itemText;
    }

    protected String getDataText(T item) {
        if (item == null) {
            return "";
        }
        if (item instanceof IWheelEntity) {
            return ((IWheelEntity)item).getWheelText();
        }
        if (item instanceof Integer) {
            return this.isIntegerNeedFormat ? String.format(Locale.getDefault(), this.mIntegerFormat, item) : String.valueOf(item);
        }
        if (item instanceof String) {
            return (String)item;
        }
        return item.toString();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled() || this.mDataList.isEmpty()) {
            return super.onTouchEvent(event);
        }
        this.initVelocityTracker();
        this.mVelocityTracker.addMovement(event);
        switch (event.getActionMasked()) {
            case 0: {
                if (this.getParent() != null) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (!this.mScroller.isFinished()) {
                    this.mScroller.forceFinished(true);
                    this.isForceFinishScroll = true;
                }
                this.mLastTouchY = event.getY();
                this.mDownStartTime = System.currentTimeMillis();
                break;
            }
            case 2: {
                float moveY = event.getY();
                float deltaY = moveY - this.mLastTouchY;
                if (this.mOnWheelChangedListener != null) {
                    this.mOnWheelChangedListener.onWheelScrollStateChanged(1);
                }
                this.onWheelScrollStateChanged(1);
                if (Math.abs(deltaY) < 1.0f) break;
                this.doScroll((int)(-deltaY));
                this.mLastTouchY = moveY;
                this.invalidateIfYChanged();
                break;
            }
            case 1: {
                this.isForceFinishScroll = false;
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxFlingVelocity);
                float velocityY = this.mVelocityTracker.getYVelocity();
                if (Math.abs(velocityY) > (float)this.mMinFlingVelocity) {
                    this.mScroller.forceFinished(true);
                    this.isFlingScroll = true;
                    this.mScroller.fling(0, this.mScrollOffsetY, 0, (int)(-velocityY), 0, 0, this.mMinScrollY, this.mMaxScrollY);
                } else {
                    boolean isInMaxRange;
                    int scrollRange;
                    int clickToCenterDistance = 0;
                    if (System.currentTimeMillis() - this.mDownStartTime <= 120L) {
                        clickToCenterDistance = (int)(event.getY() - (float)this.mCenterY);
                    }
                    boolean isInMinRange = (scrollRange = clickToCenterDistance + this.calculateDistanceToEndPoint((this.mScrollOffsetY + clickToCenterDistance) % this.dividedItemHeight())) < 0 && this.mScrollOffsetY + scrollRange >= this.mMinScrollY;
                    boolean bl = isInMaxRange = scrollRange > 0 && this.mScrollOffsetY + scrollRange <= this.mMaxScrollY;
                    if (isInMinRange || isInMaxRange) {
                        this.mScroller.startScroll(0, this.mScrollOffsetY, 0, scrollRange);
                    }
                }
                this.invalidateIfYChanged();
                ViewCompat.postOnAnimation((View)this, (Runnable)this);
                this.recycleVelocityTracker();
                break;
            }
            case 3: {
                this.recycleVelocityTracker();
            }
        }
        return true;
    }

    private void initVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void doScroll(int distance) {
        this.mScrollOffsetY += distance;
        if (!this.isCyclic) {
            if (this.mScrollOffsetY < this.mMinScrollY) {
                this.mScrollOffsetY = this.mMinScrollY;
            } else if (this.mScrollOffsetY > this.mMaxScrollY) {
                this.mScrollOffsetY = this.mMaxScrollY;
            }
        }
    }

    private void invalidateIfYChanged() {
        if (this.mScrollOffsetY != this.mScrolledY) {
            this.mScrolledY = this.mScrollOffsetY;
            if (this.mOnWheelChangedListener != null) {
                this.mOnWheelChangedListener.onWheelScroll(this.mScrollOffsetY);
            }
            this.onWheelScroll(this.mScrollOffsetY);
            this.observeItemChanged();
            this.invalidate();
        }
    }

    private void observeItemChanged() {
        int oldPosition = this.mCurrentScrollPosition;
        int newPosition = this.getCurrentPosition();
        if (oldPosition != newPosition) {
            if (this.mOnWheelChangedListener != null) {
                this.mOnWheelChangedListener.onWheelItemChanged(oldPosition, newPosition);
            }
            this.onWheelItemChanged(oldPosition, newPosition);
            this.playSoundEffect();
            this.mCurrentScrollPosition = newPosition;
        }
    }

    public void playSoundEffect() {
        if (this.mSoundHelper != null && this.isSoundEffect) {
            this.mSoundHelper.playSoundEffect();
        }
    }

    public void forceFinishScroll() {
        if (!this.mScroller.isFinished()) {
            this.mScroller.forceFinished(true);
        }
    }

    public void abortFinishScroll() {
        if (!this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
    }

    private int calculateDistanceToEndPoint(int remainder) {
        if (Math.abs(remainder) > this.mItemHeight / 2) {
            if (this.mScrollOffsetY < 0) {
                return -this.mItemHeight - remainder;
            }
            return this.mItemHeight - remainder;
        }
        return -remainder;
    }

    @Override
    public void run() {
        if (this.mScroller.isFinished() && !this.isForceFinishScroll && !this.isFlingScroll) {
            if (this.mItemHeight == 0) {
                return;
            }
            if (this.mOnWheelChangedListener != null) {
                this.mOnWheelChangedListener.onWheelScrollStateChanged(0);
            }
            this.onWheelScrollStateChanged(0);
            int currentItemPosition = this.getCurrentPosition();
            if (currentItemPosition == this.mSelectedItemPosition) {
                return;
            }
            this.mCurrentScrollPosition = this.mSelectedItemPosition = currentItemPosition;
            if (this.mOnItemSelectedListener != null) {
                this.mOnItemSelectedListener.onItemSelected(this, this.mDataList.get(this.mSelectedItemPosition), this.mSelectedItemPosition);
            }
            this.onItemSelected(this.mDataList.get(this.mSelectedItemPosition), this.mSelectedItemPosition);
            if (this.mOnWheelChangedListener != null) {
                this.mOnWheelChangedListener.onWheelSelected(this.mSelectedItemPosition);
            }
            this.onWheelSelected(this.mSelectedItemPosition);
        }
        if (this.mScroller.computeScrollOffset()) {
            int oldY = this.mScrollOffsetY;
            this.mScrollOffsetY = this.mScroller.getCurrY();
            if (oldY != this.mScrollOffsetY) {
                if (this.mOnWheelChangedListener != null) {
                    this.mOnWheelChangedListener.onWheelScrollStateChanged(2);
                }
                this.onWheelScrollStateChanged(2);
            }
            this.invalidateIfYChanged();
            ViewCompat.postOnAnimation((View)this, (Runnable)this);
        } else if (this.isFlingScroll) {
            this.isFlingScroll = false;
            this.mScroller.startScroll(0, this.mScrollOffsetY, 0, this.calculateDistanceToEndPoint(this.mScrollOffsetY % this.dividedItemHeight()));
            this.invalidateIfYChanged();
            ViewCompat.postOnAnimation((View)this, (Runnable)this);
        }
    }

    private int getCurrentPosition() {
        if (this.mDataList.isEmpty()) {
            return -1;
        }
        int itemPosition = this.mScrollOffsetY < 0 ? (this.mScrollOffsetY - this.mItemHeight / 2) / this.dividedItemHeight() : (this.mScrollOffsetY + this.mItemHeight / 2) / this.dividedItemHeight();
        int currentPosition = itemPosition % this.mDataList.size();
        if (currentPosition < 0) {
            currentPosition += this.mDataList.size();
        }
        return currentPosition;
    }

    private int dividedItemHeight() {
        return this.mItemHeight > 0 ? this.mItemHeight : 1;
    }

    public boolean isSoundEffect() {
        return this.isSoundEffect;
    }

    public void setSoundEffect(boolean isSoundEffect) {
        this.isSoundEffect = isSoundEffect;
    }

    public void setSoundEffectResource(@RawRes int rawResId) {
        if (this.mSoundHelper != null) {
            this.mSoundHelper.load(this.getContext(), rawResId);
        }
    }

    public float getPlayVolume() {
        return this.mSoundHelper == null ? 0.0f : this.mSoundHelper.getPlayVolume();
    }

    public void setPlayVolume(@FloatRange(from=0.0, to=1.0) float playVolume) {
        if (this.mSoundHelper != null) {
            this.mSoundHelper.setPlayVolume(playVolume);
        }
    }

    @Nullable
    public T getItemData(int position) {
        if (this.isPositionInRange(position)) {
            return this.mDataList.get(position);
        }
        if (this.mDataList.size() > 0 && position >= this.mDataList.size()) {
            return this.mDataList.get(this.mDataList.size() - 1);
        }
        if (this.mDataList.size() > 0 && position < 0) {
            return this.mDataList.get(0);
        }
        return null;
    }

    public T getSelectedItemData() {
        return this.getItemData(this.mSelectedItemPosition);
    }

    public List<T> getData() {
        return this.mDataList;
    }

    public void setData(List<T> dataList) {
        if (dataList == null) {
            return;
        }
        this.mDataList = dataList;
        if (!this.isResetSelectedPosition && this.mDataList.size() > 0) {
            if (this.mSelectedItemPosition >= this.mDataList.size()) {
                this.mCurrentScrollPosition = this.mSelectedItemPosition = this.mDataList.size() - 1;
            }
        } else {
            this.mSelectedItemPosition = 0;
            this.mCurrentScrollPosition = 0;
        }
        this.forceFinishScroll();
        this.calculateTextSize();
        this.calculateLimitY();
        this.mScrollOffsetY = this.mSelectedItemPosition * this.mItemHeight;
        this.requestLayout();
        this.invalidate();
    }

    public boolean isResetSelectedPosition() {
        return this.isResetSelectedPosition;
    }

    public void setResetSelectedPosition(boolean isResetSelectedPosition) {
        this.isResetSelectedPosition = isResetSelectedPosition;
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(float textSize) {
        this.setTextSize(textSize, false);
    }

    public void setTextSize(float textSize, boolean isSp) {
        float tempTextSize = this.mTextSize;
        float f = this.mTextSize = isSp ? WheelView.sp2px(textSize) : textSize;
        if (tempTextSize == this.mTextSize) {
            return;
        }
        this.forceFinishScroll();
        this.calculateTextSize();
        this.calculateDrawStart();
        this.calculateLimitY();
        this.mScrollOffsetY = this.mSelectedItemPosition * this.mItemHeight;
        this.requestLayout();
        this.invalidate();
    }

    public boolean isAutoFitTextSize() {
        return this.isAutoFitTextSize;
    }

    public void setAutoFitTextSize(boolean isAutoFitTextSize) {
        this.isAutoFitTextSize = isAutoFitTextSize;
        this.invalidate();
    }

    public Typeface getTypeface() {
        return this.mPaint.getTypeface();
    }

    public void setTypeface(Typeface typeface) {
        this.setTypeface(typeface, false);
    }

    public void setTypeface(Typeface typeface, boolean isBoldForSelectedItem) {
        if (typeface == null || this.mPaint.getTypeface() == typeface) {
            return;
        }
        this.forceFinishScroll();
        this.mIsBoldForSelectedItem = isBoldForSelectedItem;
        if (this.mIsBoldForSelectedItem) {
            if (typeface.isBold()) {
                this.mNormalTypeface = Typeface.create((Typeface)typeface, (int)0);
                this.mBoldTypeface = typeface;
            } else {
                this.mNormalTypeface = typeface;
                this.mBoldTypeface = Typeface.create((Typeface)typeface, (int)1);
            }
            this.mPaint.setTypeface(this.mBoldTypeface);
        } else {
            this.mPaint.setTypeface(typeface);
        }
        this.calculateTextSize();
        this.calculateDrawStart();
        this.mScrollOffsetY = this.mSelectedItemPosition * this.mItemHeight;
        this.calculateLimitY();
        this.requestLayout();
        this.invalidate();
    }

    public int getTextAlign() {
        return this.mTextAlign;
    }

    public void setTextAlign(int textAlign) {
        if (this.mTextAlign == textAlign) {
            return;
        }
        this.mTextAlign = textAlign;
        this.updateTextAlign();
        this.calculateDrawStart();
        this.invalidate();
    }

    public int getNormalItemTextColor() {
        return this.mTextColor;
    }

    public void setNormalItemTextColorRes(@ColorRes int textColorRes) {
        this.setNormalItemTextColor(ContextCompat.getColor((Context)this.getContext(), (int)textColorRes));
    }

    public void setNormalItemTextColor(@ColorInt int textColor) {
        if (this.mTextColor == textColor) {
            return;
        }
        this.mTextColor = textColor;
        this.invalidate();
    }

    public int getSelectedItemTextColor() {
        return this.mSelectedItemTextColor;
    }

    public void setSelectedItemTextColorRes(@ColorRes int selectedItemColorRes) {
        this.setSelectedItemTextColor(ContextCompat.getColor((Context)this.getContext(), (int)selectedItemColorRes));
    }

    public void setSelectedItemTextColor(@ColorInt int selectedItemTextColor) {
        if (this.mSelectedItemTextColor == selectedItemTextColor) {
            return;
        }
        this.mSelectedItemTextColor = selectedItemTextColor;
        this.invalidate();
    }

    public float getTextBoundaryMargin() {
        return this.mTextBoundaryMargin;
    }

    public void setTextBoundaryMargin(float textBoundaryMargin) {
        this.setTextBoundaryMargin(textBoundaryMargin, false);
    }

    public void setTextBoundaryMargin(float textBoundaryMargin, boolean isDp) {
        float tempTextBoundaryMargin = this.mTextBoundaryMargin;
        float f = this.mTextBoundaryMargin = isDp ? WheelView.dp2px(textBoundaryMargin) : textBoundaryMargin;
        if (tempTextBoundaryMargin == this.mTextBoundaryMargin) {
            return;
        }
        this.requestLayout();
        this.invalidate();
    }

    public float getLineSpacing() {
        return this.mLineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.setLineSpacing(lineSpacing, false);
    }

    public void setLineSpacing(float lineSpacing, boolean isDp) {
        float tempLineSpace = this.mLineSpacing;
        float f = this.mLineSpacing = isDp ? WheelView.dp2px(lineSpacing) : lineSpacing;
        if (tempLineSpace == this.mLineSpacing) {
            return;
        }
        this.mScrollOffsetY = 0;
        this.calculateTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public boolean isIntegerNeedFormat() {
        return this.isIntegerNeedFormat;
    }

    public void setIntegerNeedFormat(boolean isIntegerNeedFormat) {
        if (this.isIntegerNeedFormat == isIntegerNeedFormat) {
            return;
        }
        this.isIntegerNeedFormat = isIntegerNeedFormat;
        this.calculateTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public void setIntegerNeedFormat(String integerFormat) {
        this.isIntegerNeedFormat = true;
        this.mIntegerFormat = integerFormat;
        this.calculateTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public String getIntegerFormat() {
        return this.mIntegerFormat;
    }

    public void setIntegerFormat(String integerFormat) {
        if (TextUtils.isEmpty((CharSequence)integerFormat) || integerFormat.equals(this.mIntegerFormat)) {
            return;
        }
        this.mIntegerFormat = integerFormat;
        this.calculateTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public int getVisibleItems() {
        return this.mVisibleItems;
    }

    public void setVisibleItems(int visibleItems) {
        if (this.mVisibleItems == visibleItems) {
            return;
        }
        this.mVisibleItems = this.adjustVisibleItems(visibleItems);
        this.mScrollOffsetY = 0;
        this.requestLayout();
        this.invalidate();
    }

    private int adjustVisibleItems(int visibleItems) {
        return Math.abs(visibleItems / 2 * 2 + 1);
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void setCyclic(boolean isCyclic) {
        if (this.isCyclic == isCyclic) {
            return;
        }
        this.isCyclic = isCyclic;
        this.forceFinishScroll();
        this.calculateLimitY();
        this.mScrollOffsetY = this.mSelectedItemPosition * this.mItemHeight;
        this.invalidate();
    }

    public int getSelectedItemPosition() {
        return this.mSelectedItemPosition;
    }

    public void setSelectedItemPosition(int position) {
        this.setSelectedItemPosition(position, false);
    }

    public void setSelectedItemPosition(int position, boolean isSmoothScroll) {
        this.setSelectedItemPosition(position, isSmoothScroll, 0);
    }

    public void setSelectedItemPosition(int position, boolean isSmoothScroll, int smoothDuration) {
        if (!this.isPositionInRange(position)) {
            return;
        }
        int itemDistance = this.calculateItemDistance(position);
        if (itemDistance == 0) {
            return;
        }
        this.abortFinishScroll();
        if (isSmoothScroll) {
            this.mScroller.startScroll(0, this.mScrollOffsetY, 0, itemDistance, smoothDuration > 0 ? smoothDuration : 250);
            this.invalidateIfYChanged();
            ViewCompat.postOnAnimation((View)this, (Runnable)this);
        } else {
            this.doScroll(itemDistance);
            this.mSelectedItemPosition = position;
            if (this.mOnItemSelectedListener != null) {
                this.mOnItemSelectedListener.onItemSelected(this, this.mDataList.get(this.mSelectedItemPosition), this.mSelectedItemPosition);
            }
            this.onItemSelected(this.mDataList.get(this.mSelectedItemPosition), this.mSelectedItemPosition);
            if (this.mOnWheelChangedListener != null) {
                this.mOnWheelChangedListener.onWheelSelected(this.mSelectedItemPosition);
            }
            this.onWheelSelected(this.mSelectedItemPosition);
            this.invalidateIfYChanged();
        }
    }

    private int calculateItemDistance(int position) {
        return position * this.mItemHeight - this.mScrollOffsetY;
    }

    public boolean isPositionInRange(int position) {
        return position >= 0 && position < this.mDataList.size();
    }

    public boolean isShowDivider() {
        return this.isShowDivider;
    }

    public void setShowDivider(boolean isShowDivider) {
        if (this.isShowDivider == isShowDivider) {
            return;
        }
        this.isShowDivider = isShowDivider;
        this.invalidate();
    }

    public int getDividerColor() {
        return this.mDividerColor;
    }

    public void setDividerColorRes(@ColorRes int dividerColorRes) {
        this.setDividerColor(ContextCompat.getColor((Context)this.getContext(), (int)dividerColorRes));
    }

    public void setDividerColor(@ColorInt int dividerColor) {
        if (this.mDividerColor == dividerColor) {
            return;
        }
        this.mDividerColor = dividerColor;
        this.invalidate();
    }

    public float getDividerHeight() {
        return this.mDividerSize;
    }

    public void setDividerHeight(float dividerHeight) {
        this.setDividerHeight(dividerHeight, false);
    }

    public void setDividerHeight(float dividerHeight, boolean isDp) {
        float tempDividerHeight = this.mDividerSize;
        float f = this.mDividerSize = isDp ? WheelView.dp2px(dividerHeight) : dividerHeight;
        if (tempDividerHeight == this.mDividerSize) {
            return;
        }
        this.invalidate();
    }

    public int getDividerType() {
        return this.mDividerType;
    }

    public void setDividerType(int dividerType) {
        if (this.mDividerType == dividerType) {
            return;
        }
        this.mDividerType = dividerType;
        this.invalidate();
    }

    public float getDividerPaddingForWrap() {
        return this.mDividerPaddingForWrap;
    }

    public void setDividerPaddingForWrap(float dividerPaddingForWrap) {
        this.setDividerPaddingForWrap(dividerPaddingForWrap, false);
    }

    public void setDividerPaddingForWrap(float dividerPaddingForWrap, boolean isDp) {
        float tempDividerPadding = this.mDividerPaddingForWrap;
        float f = this.mDividerPaddingForWrap = isDp ? WheelView.dp2px(dividerPaddingForWrap) : dividerPaddingForWrap;
        if (tempDividerPadding == this.mDividerPaddingForWrap) {
            return;
        }
        this.invalidate();
    }

    public Paint.Cap getDividerCap() {
        return this.mDividerCap;
    }

    public void setDividerCap(Paint.Cap dividerCap) {
        if (this.mDividerCap == dividerCap) {
            return;
        }
        this.mDividerCap = dividerCap;
        this.invalidate();
    }

    public boolean isDrawSelectedRect() {
        return this.isDrawSelectedRect;
    }

    public void setDrawSelectedRect(boolean isDrawSelectedRect) {
        this.isDrawSelectedRect = isDrawSelectedRect;
        this.invalidate();
    }

    public int getSelectedRectColor() {
        return this.mSelectedRectColor;
    }

    public void setSelectedRectColorRes(@ColorRes int selectedRectColorRes) {
        this.setSelectedRectColor(ContextCompat.getColor((Context)this.getContext(), (int)selectedRectColorRes));
    }

    public void setSelectedRectColor(@ColorInt int selectedRectColor) {
        this.mSelectedRectColor = selectedRectColor;
        this.invalidate();
    }

    public boolean isCurved() {
        return this.isCurved;
    }

    public void setCurved(boolean isCurved) {
        if (this.isCurved == isCurved) {
            return;
        }
        this.isCurved = isCurved;
        this.calculateTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public int getCurvedArcDirection() {
        return this.mCurvedArcDirection;
    }

    public void setCurvedArcDirection(int curvedArcDirection) {
        if (this.mCurvedArcDirection == curvedArcDirection) {
            return;
        }
        this.mCurvedArcDirection = curvedArcDirection;
        this.invalidate();
    }

    public float getCurvedArcDirectionFactor() {
        return this.mCurvedArcDirectionFactor;
    }

    public void setCurvedArcDirectionFactor(@FloatRange(from=0.0, to=1.0) float curvedArcDirectionFactor) {
        if (this.mCurvedArcDirectionFactor == curvedArcDirectionFactor) {
            return;
        }
        if (curvedArcDirectionFactor < 0.0f) {
            curvedArcDirectionFactor = 0.0f;
        } else if (curvedArcDirectionFactor > 1.0f) {
            curvedArcDirectionFactor = 1.0f;
        }
        this.mCurvedArcDirectionFactor = curvedArcDirectionFactor;
        this.invalidate();
    }

    public float getRefractRatio() {
        return this.mRefractRatio;
    }

    public void setRefractRatio(@FloatRange(from=0.0, to=1.0) float refractRatio) {
        float tempRefractRatio = this.mRefractRatio;
        this.mRefractRatio = refractRatio;
        if (this.mRefractRatio > 1.0f) {
            this.mRefractRatio = 1.0f;
        } else if (this.mRefractRatio < 0.0f) {
            this.mRefractRatio = 1.0f;
        }
        if (tempRefractRatio == this.mRefractRatio) {
            return;
        }
        this.invalidate();
    }

    @Deprecated
    public float getCurvedRefractRatio() {
        return this.mRefractRatio;
    }

    @Deprecated
    public void setCurvedRefractRatio(@FloatRange(from=0.0, to=1.0) float refractRatio) {
        this.setRefractRatio(refractRatio);
    }

    public OnItemSelectedListener<T> getOnItemSelectedListener() {
        return this.mOnItemSelectedListener;
    }

    public void setOnItemSelectedListener(OnItemSelectedListener<T> onItemSelectedListener) {
        this.mOnItemSelectedListener = onItemSelectedListener;
    }

    public OnWheelChangedListener getOnWheelChangedListener() {
        return this.mOnWheelChangedListener;
    }

    public void setOnWheelChangedListener(OnWheelChangedListener onWheelChangedListener) {
        this.mOnWheelChangedListener = onWheelChangedListener;
    }

    protected void onWheelScroll(int scrollOffsetY) {
    }

    protected void onWheelItemChanged(int oldPosition, int newPosition) {
    }

    protected void onWheelSelected(int position) {
    }

    protected void onWheelScrollStateChanged(int state) {
    }

    protected void onItemSelected(T data, int position) {
    }

    protected static float dp2px(float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    protected static float sp2px(float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    private static class SoundHelper {
        private SoundPool mSoundPool = Build.VERSION.SDK_INT >= 21 ? new SoundPool.Builder().build() : new SoundPool(1, 1, 1);
        private int mSoundId;
        private float mPlayVolume;

        private SoundHelper() {
        }

        static SoundHelper obtain() {
            return new SoundHelper();
        }

        void load(Context context, @RawRes int resId) {
            if (this.mSoundPool != null) {
                this.mSoundId = this.mSoundPool.load(context, resId, 1);
            }
        }

        void setPlayVolume(@FloatRange(from=0.0, to=1.0) float playVolume) {
            this.mPlayVolume = playVolume;
        }

        float getPlayVolume() {
            return this.mPlayVolume;
        }

        void playSoundEffect() {
            if (this.mSoundPool != null && this.mSoundId != 0) {
                this.mSoundPool.play(this.mSoundId, this.mPlayVolume, this.mPlayVolume, 1, 0, 1.0f);
            }
        }

        void release() {
            if (this.mSoundPool != null) {
                this.mSoundPool.release();
                this.mSoundPool = null;
            }
        }
    }

    public static interface OnWheelChangedListener {
        public void onWheelScroll(int var1);

        public void onWheelItemChanged(int var1, int var2);

        public void onWheelSelected(int var1);

        public void onWheelScrollStateChanged(int var1);
    }

    public static interface OnItemSelectedListener<T> {
        public void onItemSelected(WheelView<T> var1, T var2, int var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DividerType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CurvedArcDirection {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextAlign {
    }
}

