/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.block.procedure.primitive;

import java.io.Serializable;

/**
 * A FloatCharProcedure is a two argument lambda or closure which has no return argument and takes a primitive float as the first and
 * a primitive char as the second argument.
 * This file was automatically generated from template file primitivePrimitiveProcedure.stg.
 *
 * @since 3.0.
 */
public interface FloatCharProcedure
        extends Serializable
{
    void value(float argument1, char argument2);
}
