/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.bag.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.bag.primitive.ImmutableFloatBag;

/**
 * A factory which creates instances of type {@link ImmutableFloatBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableFloatBagFactory
{
    /**
     * Same as {@link #with()}.
     */
    ImmutableFloatBag of();

    ImmutableFloatBag with();

    /**
     * Same as {@link #with(float)}.
     */
    ImmutableFloatBag of(float one);

    ImmutableFloatBag with(float one);

    /**
     * Same as {@link #with(float[])}.
     */
    ImmutableFloatBag of(float... items);

    ImmutableFloatBag with(float... items);

    /**
     * Same as {@link #withAll(FloatIterable)}.
     */
    ImmutableFloatBag ofAll(FloatIterable items);

    ImmutableFloatBag withAll(FloatIterable items);
}
