/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.list.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.list.primitive.ImmutableByteList;

/**
 * A factory which creates instances of type {@link ImmutableByteList}.
 * This file was automatically generated from template file immutablePrimitiveListFactory.stg.
 *
 * @since 3.2.
 */
public interface ImmutableByteListFactory
{
    /**
     * Same as {@link #with()}.
     */
    ImmutableByteList of();

    ImmutableByteList with();

    /**
     * Same as {@link #with(byte)}.
     */
    ImmutableByteList of(byte one);

    ImmutableByteList with(byte one);

    /**
     * Same as {@link #with(byte[])}.
     */
    ImmutableByteList of(byte... items);

    ImmutableByteList with(byte... items);

    /**
     * Same as {@link #withAll(ByteIterable)}.
     */
    ImmutableByteList ofAll(ByteIterable items);

    ImmutableByteList withAll(ByteIterable items);
}
