/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortShortPredicate;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableShortShortMap extends ShortShortMap
{
    ImmutableShortShortMap select(ShortShortPredicate predicate);

    ImmutableShortShortMap reject(ShortShortPredicate predicate);

    ImmutableShortCollection select(ShortPredicate predicate);

    ImmutableShortCollection reject(ShortPredicate predicate);

    <V> ImmutableCollection<V> collect(ShortToObjectFunction<? extends V> function);

    ImmutableShortShortMap newWithKeyValue(short key, short value);

    ImmutableShortShortMap newWithoutKey(short key);

    ImmutableShortShortMap newWithoutAllKeys(ShortIterable keys);
}
