/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.function.primitive.ByteToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.predicate.primitive.ByteFloatPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableByteFloatMap extends ByteFloatMap
{
    void clear();

    void put(byte key, float value);

    void putAll(ByteFloatMap map);

    void removeKey(byte key);

    void remove(byte key);

    float removeKeyIfAbsent(byte key, float value);

    float getIfAbsentPut(byte key, float value);

    float getIfAbsentPut(byte key, FloatFunction0 function);

    float getIfAbsentPutWithKey(byte key, ByteToFloatFunction function);

    <P> float getIfAbsentPutWith(byte key, FloatFunction<? super P> function, P parameter);

    float updateValue(byte key, float initialValueIfAbsent, FloatToFloatFunction function);

    MutableByteFloatMap select(ByteFloatPredicate predicate);

    MutableByteFloatMap reject(ByteFloatPredicate predicate);

    MutableFloatCollection select(FloatPredicate predicate);

    MutableFloatCollection reject(FloatPredicate predicate);

    <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function);

    MutableByteFloatMap withKeyValue(byte key, float value);

    MutableByteFloatMap withoutKey(byte key);

    MutableByteFloatMap withoutAllKeys(ByteIterable keys);

    MutableByteFloatMap asUnmodifiable();

    MutableByteFloatMap asSynchronized();

    float addToValue(byte key, float toBeAdded);
}
