/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.function.primitive.IntToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.predicate.primitive.IntFloatPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableIntFloatMap extends IntFloatMap
{
    void clear();

    void put(int key, float value);

    void putAll(IntFloatMap map);

    void removeKey(int key);

    void remove(int key);

    float removeKeyIfAbsent(int key, float value);

    float getIfAbsentPut(int key, float value);

    float getIfAbsentPut(int key, FloatFunction0 function);

    float getIfAbsentPutWithKey(int key, IntToFloatFunction function);

    <P> float getIfAbsentPutWith(int key, FloatFunction<? super P> function, P parameter);

    float updateValue(int key, float initialValueIfAbsent, FloatToFloatFunction function);

    MutableIntFloatMap select(IntFloatPredicate predicate);

    MutableIntFloatMap reject(IntFloatPredicate predicate);

    MutableFloatCollection select(FloatPredicate predicate);

    MutableFloatCollection reject(FloatPredicate predicate);

    <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function);

    MutableIntFloatMap withKeyValue(int key, float value);

    MutableIntFloatMap withoutKey(int key);

    MutableIntFloatMap withoutAllKeys(IntIterable keys);

    MutableIntFloatMap asUnmodifiable();

    MutableIntFloatMap asSynchronized();

    float addToValue(int key, float toBeAdded);
}
