/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.primitive.LongObjectPredicate;
import com.gs.collections.api.collection.MutableCollection;

/**
 * This file was automatically generated from template file mutablePrimitiveObjectMap.stg.
 *
 * @since 3.0.
 */
public interface MutableLongObjectMap<V> extends LongObjectMap<V>, MutablePrimitiveObjectMap<V>
{
    V put(long key, V value);

    /**
     * @since 5.0.
     */
    void putAll(LongObjectMap<? extends V> map);

    V removeKey(long key);

    V remove(long key);

    V getIfAbsentPut(long key, V value);

    V getIfAbsentPut(long key, Function0<? extends V> function);

    V getIfAbsentPutWithKey(long key, LongToObjectFunction<? extends V> function);

    <P> V getIfAbsentPutWith(long key, Function<? super P, ? extends V> function, P parameter);

    /**
     * Look up the value associated with {@code key}, apply the {@code function} to it, and replace the value. If there
     * is no value associated with {@code key}, start it off with a value supplied by {@code factory}.
     */
    V updateValue(long key, Function0<? extends V> factory, Function<? super V, ? extends V> function);

    /**
     * Same as {@link #updateValue(long, Function0, Function)} with a Function2 and specified parameter which is
     * passed to the function.
     */
    <P> V updateValueWith(long key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter);

    MutableLongObjectMap<V> select(LongObjectPredicate<? super V> predicate);

    MutableLongObjectMap<V> reject(LongObjectPredicate<? super V> predicate);

    MutableCollection<V> select(Predicate<? super V> predicate);

    MutableCollection<V> reject(Predicate<? super V> predicate);

    <V1> MutableCollection<V1> collect(Function<? super V, ? extends V1> function);

    <P, VV> MutableCollection<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter);

    MutableLongObjectMap<V> withKeyValue(long key, V value);

    MutableLongObjectMap<V> withoutKey(long key);

    MutableLongObjectMap<V> withoutAllKeys(LongIterable keys);

    MutableLongObjectMap<V> asUnmodifiable();

    MutableLongObjectMap<V> asSynchronized();
}
