/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.manifest;

import android.net.Uri;
import com.google.android.exoplayer2.util.UriUtil;

public final class RangedUri {
    public final long start;
    public final long length;
    private final String referenceUri;
    private int hashCode;

    public RangedUri(String referenceUri, long start, long length) {
        this.referenceUri = referenceUri == null ? "" : referenceUri;
        this.start = start;
        this.length = length;
    }

    public Uri resolveUri(String baseUri) {
        return UriUtil.resolveToUri((String)baseUri, (String)this.referenceUri);
    }

    public String resolveUriString(String baseUri) {
        return UriUtil.resolve((String)baseUri, (String)this.referenceUri);
    }

    public RangedUri attemptMerge(RangedUri other, String baseUri) {
        String resolvedUri = this.resolveUriString(baseUri);
        if (other == null || !resolvedUri.equals(other.resolveUriString(baseUri))) {
            return null;
        }
        if (this.length != -1L && this.start + this.length == other.start) {
            return new RangedUri(resolvedUri, this.start, other.length == -1L ? -1L : this.length + other.length);
        }
        if (other.length != -1L && other.start + other.length == this.start) {
            return new RangedUri(resolvedUri, other.start, this.length == -1L ? -1L : other.length + this.length);
        }
        return null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + (int)this.start;
            result = 31 * result + (int)this.length;
            this.hashCode = result = 31 * result + this.referenceUri.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RangedUri other = (RangedUri)obj;
        return this.start == other.start && this.length == other.length && this.referenceUri.equals(other.referenceUri);
    }
}

