/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.mediasession;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.util.Pair;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.ext.mediasession.DefaultPlaybackController;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ErrorMessageProvider;
import com.google.android.exoplayer2.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MediaSessionConnector {
    public static final int DEFAULT_REPEAT_TOGGLE_MODES = 3;
    public static final String EXTRAS_PITCH = "EXO_PITCH";
    private static final int BASE_MEDIA_SESSION_FLAGS = 3;
    private static final int EDITOR_MEDIA_SESSION_FLAGS = 7;
    public final MediaSessionCompat mediaSession;
    @Nullable
    private final MediaMetadataProvider mediaMetadataProvider;
    private final ExoPlayerEventListener exoPlayerEventListener;
    private final MediaSessionCallback mediaSessionCallback;
    private final PlaybackController playbackController;
    private final Map<String, CommandReceiver> commandMap;
    private Player player;
    private CustomActionProvider[] customActionProviders;
    private Map<String, CustomActionProvider> customActionMap;
    @Nullable
    private ErrorMessageProvider<? super ExoPlaybackException> errorMessageProvider;
    @Nullable
    private Pair<Integer, CharSequence> customError;
    private PlaybackPreparer playbackPreparer;
    private QueueNavigator queueNavigator;
    private QueueEditor queueEditor;
    private RatingCallback ratingCallback;

    public MediaSessionConnector(MediaSessionCompat mediaSession) {
        this(mediaSession, null);
    }

    public MediaSessionConnector(MediaSessionCompat mediaSession, PlaybackController playbackController) {
        this(mediaSession, playbackController, new DefaultMediaMetadataProvider(mediaSession.getController(), null));
    }

    @Deprecated
    public MediaSessionConnector(MediaSessionCompat mediaSession, @Nullable PlaybackController playbackController, boolean doMaintainMetadata, @Nullable String metadataExtrasPrefix) {
        this(mediaSession, playbackController, doMaintainMetadata ? new DefaultMediaMetadataProvider(mediaSession.getController(), metadataExtrasPrefix) : null);
    }

    public MediaSessionConnector(MediaSessionCompat mediaSession, @Nullable PlaybackController playbackController, @Nullable MediaMetadataProvider mediaMetadataProvider) {
        this.mediaSession = mediaSession;
        this.playbackController = playbackController != null ? playbackController : new DefaultPlaybackController();
        this.mediaMetadataProvider = mediaMetadataProvider;
        mediaSession.setFlags(3);
        this.mediaSessionCallback = new MediaSessionCallback();
        this.exoPlayerEventListener = new ExoPlayerEventListener();
        this.customActionMap = Collections.emptyMap();
        this.commandMap = new HashMap<String, CommandReceiver>();
        this.registerCommandReceiver(playbackController);
    }

    public void setPlayer(@Nullable Player player, @Nullable PlaybackPreparer playbackPreparer, CustomActionProvider ... customActionProviders) {
        Assertions.checkArgument((player == null || player.getApplicationLooper() == Looper.myLooper() ? 1 : 0) != 0);
        if (this.player != null) {
            this.player.removeListener((Player.EventListener)this.exoPlayerEventListener);
            this.mediaSession.setCallback(null);
        }
        this.unregisterCommandReceiver(this.playbackPreparer);
        this.player = player;
        this.playbackPreparer = playbackPreparer;
        this.registerCommandReceiver(playbackPreparer);
        CustomActionProvider[] customActionProviderArray = this.customActionProviders = player != null && customActionProviders != null ? customActionProviders : new CustomActionProvider[]{};
        if (player != null) {
            Handler handler = new Handler(Util.getLooper());
            this.mediaSession.setCallback((MediaSessionCompat.Callback)this.mediaSessionCallback, handler);
            player.addListener((Player.EventListener)this.exoPlayerEventListener);
        }
        this.invalidateMediaSessionPlaybackState();
        this.invalidateMediaSessionMetadata();
    }

    public void setErrorMessageProvider(@Nullable ErrorMessageProvider<? super ExoPlaybackException> errorMessageProvider) {
        if (this.errorMessageProvider != errorMessageProvider) {
            this.errorMessageProvider = errorMessageProvider;
            this.invalidateMediaSessionPlaybackState();
        }
    }

    public void setQueueNavigator(QueueNavigator queueNavigator) {
        if (this.queueNavigator != queueNavigator) {
            this.unregisterCommandReceiver(this.queueNavigator);
            this.queueNavigator = queueNavigator;
            this.registerCommandReceiver(queueNavigator);
        }
    }

    public void setQueueEditor(QueueEditor queueEditor) {
        if (this.queueEditor != queueEditor) {
            this.unregisterCommandReceiver(this.queueEditor);
            this.queueEditor = queueEditor;
            this.registerCommandReceiver(queueEditor);
            this.mediaSession.setFlags(queueEditor == null ? 3 : 7);
        }
    }

    public void setRatingCallback(RatingCallback ratingCallback) {
        if (this.ratingCallback != ratingCallback) {
            this.unregisterCommandReceiver(this.ratingCallback);
            this.ratingCallback = ratingCallback;
            this.registerCommandReceiver(this.ratingCallback);
        }
    }

    public void setCustomErrorMessage(@Nullable CharSequence message) {
        int code = message == null ? 0 : 1;
        this.setCustomErrorMessage(message, code);
    }

    public void setCustomErrorMessage(@Nullable CharSequence message, int code) {
        this.customError = message == null ? null : new Pair((Object)code, (Object)message);
        this.invalidateMediaSessionPlaybackState();
    }

    public final void invalidateMediaSessionMetadata() {
        if (this.mediaMetadataProvider != null && this.player != null) {
            this.mediaSession.setMetadata(this.mediaMetadataProvider.getMetadata(this.player));
        }
    }

    public final void invalidateMediaSessionPlaybackState() {
        int sessionPlaybackState;
        PlaybackStateCompat.Builder builder = new PlaybackStateCompat.Builder();
        if (this.player == null) {
            builder.setActions(this.buildPlaybackActions()).setState(0, 0L, 0.0f, 0L);
            this.mediaSession.setPlaybackState(builder.build());
            return;
        }
        HashMap<String, CustomActionProvider> currentActions = new HashMap<String, CustomActionProvider>();
        for (CustomActionProvider customActionProvider : this.customActionProviders) {
            PlaybackStateCompat.CustomAction customAction = customActionProvider.getCustomAction();
            if (customAction == null) continue;
            currentActions.put(customAction.getAction(), customActionProvider);
            builder.addCustomAction(customAction);
        }
        this.customActionMap = Collections.unmodifiableMap(currentActions);
        int playbackState = this.player.getPlaybackState();
        ExoPlaybackException playbackError = playbackState == 1 ? this.player.getPlaybackError() : null;
        boolean reportError = playbackError != null || this.customError != null;
        int n = sessionPlaybackState = reportError ? 7 : this.mapPlaybackState(this.player.getPlaybackState(), this.player.getPlayWhenReady());
        if (this.customError != null) {
            builder.setErrorMessage(((Integer)this.customError.first).intValue(), (CharSequence)this.customError.second);
        } else if (playbackError != null && this.errorMessageProvider != null) {
            Pair message = this.errorMessageProvider.getErrorMessage((Throwable)playbackError);
            builder.setErrorMessage(((Integer)message.first).intValue(), (CharSequence)message.second);
        }
        long activeQueueItemId = this.queueNavigator != null ? this.queueNavigator.getActiveQueueItemId(this.player) : -1L;
        Bundle extras = new Bundle();
        extras.putFloat(EXTRAS_PITCH, this.player.getPlaybackParameters().pitch);
        builder.setActions(this.buildPlaybackActions()).setActiveQueueItemId(activeQueueItemId).setBufferedPosition(this.player.getBufferedPosition()).setState(sessionPlaybackState, this.player.getCurrentPosition(), this.player.getPlaybackParameters().speed, SystemClock.elapsedRealtime()).setExtras(extras);
        this.mediaSession.setPlaybackState(builder.build());
    }

    public final void invalidateMediaSessionQueue() {
        if (this.queueNavigator != null && this.player != null) {
            this.queueNavigator.onTimelineChanged(this.player);
        }
    }

    private void registerCommandReceiver(CommandReceiver commandReceiver) {
        if (commandReceiver != null && commandReceiver.getCommands() != null) {
            for (String command : commandReceiver.getCommands()) {
                this.commandMap.put(command, commandReceiver);
            }
        }
    }

    private void unregisterCommandReceiver(CommandReceiver commandReceiver) {
        if (commandReceiver != null && commandReceiver.getCommands() != null) {
            for (String command : commandReceiver.getCommands()) {
                this.commandMap.remove(command);
            }
        }
    }

    private long buildPlaybackActions() {
        long actions = 0x24034FL & this.playbackController.getSupportedPlaybackActions(this.player);
        if (this.playbackPreparer != null) {
            actions |= 0x3EC00L & this.playbackPreparer.getSupportedPrepareActions();
        }
        if (this.queueNavigator != null) {
            actions |= 0x1030L & this.queueNavigator.getSupportedQueueNavigatorActions(this.player);
        }
        if (this.ratingCallback != null) {
            actions |= 0x80L;
        }
        return actions;
    }

    private int mapPlaybackState(int exoPlayerPlaybackState, boolean playWhenReady) {
        switch (exoPlayerPlaybackState) {
            case 2: {
                return 6;
            }
            case 3: {
                return playWhenReady ? 3 : 2;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    private boolean canDispatchToPlaybackPreparer(long action) {
        return this.playbackPreparer != null && (this.playbackPreparer.getSupportedPrepareActions() & 0x3EC00L & action) != 0L;
    }

    private boolean canDispatchToRatingCallback(long action) {
        return this.ratingCallback != null && (0x80L & action) != 0L;
    }

    private boolean canDispatchToPlaybackController(long action) {
        return (this.playbackController.getSupportedPlaybackActions(this.player) & 0x24034FL & action) != 0L;
    }

    private boolean canDispatchToQueueNavigator(long action) {
        return this.queueNavigator != null && (this.queueNavigator.getSupportedQueueNavigatorActions(this.player) & 0x1030L & action) != 0L;
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.mediasession");
    }

    private class MediaSessionCallback
    extends MediaSessionCompat.Callback {
        private MediaSessionCallback() {
        }

        public void onPlay() {
            if (MediaSessionConnector.this.canDispatchToPlaybackController(4L)) {
                MediaSessionConnector.this.playbackController.onPlay(MediaSessionConnector.this.player);
            }
        }

        public void onPause() {
            if (MediaSessionConnector.this.canDispatchToPlaybackController(2L)) {
                MediaSessionConnector.this.playbackController.onPause(MediaSessionConnector.this.player);
            }
        }

        public void onSeekTo(long position) {
            if (MediaSessionConnector.this.canDispatchToPlaybackController(256L)) {
                MediaSessionConnector.this.playbackController.onSeekTo(MediaSessionConnector.this.player, position);
            }
        }

        public void onFastForward() {
            if (MediaSessionConnector.this.canDispatchToPlaybackController(64L)) {
                MediaSessionConnector.this.playbackController.onFastForward(MediaSessionConnector.this.player);
            }
        }

        public void onRewind() {
            if (MediaSessionConnector.this.canDispatchToPlaybackController(8L)) {
                MediaSessionConnector.this.playbackController.onRewind(MediaSessionConnector.this.player);
            }
        }

        public void onStop() {
            if (MediaSessionConnector.this.canDispatchToPlaybackController(1L)) {
                MediaSessionConnector.this.playbackController.onStop(MediaSessionConnector.this.player);
            }
        }

        public void onSetShuffleMode(int shuffleMode) {
            if (MediaSessionConnector.this.canDispatchToPlaybackController(0x200000L)) {
                MediaSessionConnector.this.playbackController.onSetShuffleMode(MediaSessionConnector.this.player, shuffleMode);
            }
        }

        public void onSetRepeatMode(int repeatMode) {
            if (MediaSessionConnector.this.canDispatchToPlaybackController(262144L)) {
                MediaSessionConnector.this.playbackController.onSetRepeatMode(MediaSessionConnector.this.player, repeatMode);
            }
        }

        public void onSkipToNext() {
            if (MediaSessionConnector.this.canDispatchToQueueNavigator(32L)) {
                MediaSessionConnector.this.queueNavigator.onSkipToNext(MediaSessionConnector.this.player);
            }
        }

        public void onSkipToPrevious() {
            if (MediaSessionConnector.this.canDispatchToQueueNavigator(16L)) {
                MediaSessionConnector.this.queueNavigator.onSkipToPrevious(MediaSessionConnector.this.player);
            }
        }

        public void onSkipToQueueItem(long id) {
            if (MediaSessionConnector.this.canDispatchToQueueNavigator(4096L)) {
                MediaSessionConnector.this.queueNavigator.onSkipToQueueItem(MediaSessionConnector.this.player, id);
            }
        }

        public void onCustomAction(@NonNull String action, @Nullable Bundle extras) {
            Map actionMap = MediaSessionConnector.this.customActionMap;
            if (actionMap.containsKey(action)) {
                ((CustomActionProvider)actionMap.get(action)).onCustomAction(action, extras);
                MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
            }
        }

        public void onCommand(String command, Bundle extras, ResultReceiver cb) {
            CommandReceiver commandReceiver = (CommandReceiver)MediaSessionConnector.this.commandMap.get(command);
            if (commandReceiver != null) {
                commandReceiver.onCommand(MediaSessionConnector.this.player, command, extras, cb);
            }
        }

        public void onPrepare() {
            if (MediaSessionConnector.this.canDispatchToPlaybackPreparer(16384L)) {
                MediaSessionConnector.this.player.stop();
                MediaSessionConnector.this.player.setPlayWhenReady(false);
                MediaSessionConnector.this.playbackPreparer.onPrepare();
            }
        }

        public void onPrepareFromMediaId(String mediaId, Bundle extras) {
            if (MediaSessionConnector.this.canDispatchToPlaybackPreparer(32768L)) {
                MediaSessionConnector.this.player.stop();
                MediaSessionConnector.this.player.setPlayWhenReady(false);
                MediaSessionConnector.this.playbackPreparer.onPrepareFromMediaId(mediaId, extras);
            }
        }

        public void onPrepareFromSearch(String query, Bundle extras) {
            if (MediaSessionConnector.this.canDispatchToPlaybackPreparer(65536L)) {
                MediaSessionConnector.this.player.stop();
                MediaSessionConnector.this.player.setPlayWhenReady(false);
                MediaSessionConnector.this.playbackPreparer.onPrepareFromSearch(query, extras);
            }
        }

        public void onPrepareFromUri(Uri uri, Bundle extras) {
            if (MediaSessionConnector.this.canDispatchToPlaybackPreparer(131072L)) {
                MediaSessionConnector.this.player.stop();
                MediaSessionConnector.this.player.setPlayWhenReady(false);
                MediaSessionConnector.this.playbackPreparer.onPrepareFromUri(uri, extras);
            }
        }

        public void onPlayFromMediaId(String mediaId, Bundle extras) {
            if (MediaSessionConnector.this.canDispatchToPlaybackPreparer(1024L)) {
                MediaSessionConnector.this.player.stop();
                MediaSessionConnector.this.player.setPlayWhenReady(true);
                MediaSessionConnector.this.playbackPreparer.onPrepareFromMediaId(mediaId, extras);
            }
        }

        public void onPlayFromSearch(String query, Bundle extras) {
            if (MediaSessionConnector.this.canDispatchToPlaybackPreparer(2048L)) {
                MediaSessionConnector.this.player.stop();
                MediaSessionConnector.this.player.setPlayWhenReady(true);
                MediaSessionConnector.this.playbackPreparer.onPrepareFromSearch(query, extras);
            }
        }

        public void onPlayFromUri(Uri uri, Bundle extras) {
            if (MediaSessionConnector.this.canDispatchToPlaybackPreparer(8192L)) {
                MediaSessionConnector.this.player.stop();
                MediaSessionConnector.this.player.setPlayWhenReady(true);
                MediaSessionConnector.this.playbackPreparer.onPrepareFromUri(uri, extras);
            }
        }

        public void onSetRating(RatingCompat rating) {
            if (MediaSessionConnector.this.canDispatchToRatingCallback(128L)) {
                MediaSessionConnector.this.ratingCallback.onSetRating(MediaSessionConnector.this.player, rating);
            }
        }

        public void onSetRating(RatingCompat rating, Bundle extras) {
            if (MediaSessionConnector.this.canDispatchToRatingCallback(128L)) {
                MediaSessionConnector.this.ratingCallback.onSetRating(MediaSessionConnector.this.player, rating, extras);
            }
        }

        public void onAddQueueItem(MediaDescriptionCompat description) {
            if (MediaSessionConnector.this.queueEditor != null) {
                MediaSessionConnector.this.queueEditor.onAddQueueItem(MediaSessionConnector.this.player, description);
            }
        }

        public void onAddQueueItem(MediaDescriptionCompat description, int index) {
            if (MediaSessionConnector.this.queueEditor != null) {
                MediaSessionConnector.this.queueEditor.onAddQueueItem(MediaSessionConnector.this.player, description, index);
            }
        }

        public void onRemoveQueueItem(MediaDescriptionCompat description) {
            if (MediaSessionConnector.this.queueEditor != null) {
                MediaSessionConnector.this.queueEditor.onRemoveQueueItem(MediaSessionConnector.this.player, description);
            }
        }
    }

    private class ExoPlayerEventListener
    implements Player.EventListener {
        private int currentWindowIndex;
        private int currentWindowCount;

        private ExoPlayerEventListener() {
        }

        public void onTimelineChanged(Timeline timeline, @Nullable Object manifest, int reason) {
            int windowCount = MediaSessionConnector.this.player.getCurrentTimeline().getWindowCount();
            int windowIndex = MediaSessionConnector.this.player.getCurrentWindowIndex();
            if (MediaSessionConnector.this.queueNavigator != null) {
                MediaSessionConnector.this.queueNavigator.onTimelineChanged(MediaSessionConnector.this.player);
                MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
            } else if (this.currentWindowCount != windowCount || this.currentWindowIndex != windowIndex) {
                MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
            }
            this.currentWindowCount = windowCount;
            this.currentWindowIndex = windowIndex;
            MediaSessionConnector.this.invalidateMediaSessionMetadata();
        }

        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
        }

        public void onRepeatModeChanged(int repeatMode) {
            MediaSessionConnector.this.mediaSession.setRepeatMode(repeatMode == 1 ? 1 : (repeatMode == 2 ? 2 : 0));
            MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
        }

        public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
            MediaSessionConnector.this.mediaSession.setShuffleMode(shuffleModeEnabled ? 1 : 0);
            MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
        }

        public void onPositionDiscontinuity(int reason) {
            if (this.currentWindowIndex != MediaSessionConnector.this.player.getCurrentWindowIndex()) {
                if (MediaSessionConnector.this.queueNavigator != null) {
                    MediaSessionConnector.this.queueNavigator.onCurrentWindowIndexChanged(MediaSessionConnector.this.player);
                }
                this.currentWindowIndex = MediaSessionConnector.this.player.getCurrentWindowIndex();
                MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
                MediaSessionConnector.this.invalidateMediaSessionMetadata();
                return;
            }
            MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
        }

        public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
        }
    }

    public static final class DefaultMediaMetadataProvider
    implements MediaMetadataProvider {
        private final MediaControllerCompat mediaController;
        private final String metadataExtrasPrefix;

        public DefaultMediaMetadataProvider(MediaControllerCompat mediaController, @Nullable String metadataExtrasPrefix) {
            this.mediaController = mediaController;
            this.metadataExtrasPrefix = metadataExtrasPrefix != null ? metadataExtrasPrefix : "";
        }

        @Override
        public MediaMetadataCompat getMetadata(Player player) {
            if (player.getCurrentTimeline().isEmpty()) {
                return null;
            }
            MediaMetadataCompat.Builder builder = new MediaMetadataCompat.Builder();
            if (player.isPlayingAd()) {
                builder.putLong("android.media.metadata.ADVERTISEMENT", 1L);
            }
            builder.putLong("android.media.metadata.DURATION", player.getDuration() == -9223372036854775807L ? -1L : player.getDuration());
            long activeQueueItemId = this.mediaController.getPlaybackState().getActiveQueueItemId();
            if (activeQueueItemId != -1L) {
                List queue = this.mediaController.getQueue();
                for (int i = 0; queue != null && i < queue.size(); ++i) {
                    MediaSessionCompat.QueueItem queueItem = (MediaSessionCompat.QueueItem)queue.get(i);
                    if (queueItem.getQueueId() != activeQueueItemId) continue;
                    MediaDescriptionCompat description = queueItem.getDescription();
                    Bundle extras = description.getExtras();
                    if (extras != null) {
                        for (String key : extras.keySet()) {
                            Object value = extras.get(key);
                            if (value instanceof String) {
                                builder.putString(this.metadataExtrasPrefix + key, (String)value);
                                continue;
                            }
                            if (value instanceof CharSequence) {
                                builder.putText(this.metadataExtrasPrefix + key, (CharSequence)value);
                                continue;
                            }
                            if (value instanceof Long) {
                                builder.putLong(this.metadataExtrasPrefix + key, ((Long)value).longValue());
                                continue;
                            }
                            if (value instanceof Integer) {
                                builder.putLong(this.metadataExtrasPrefix + key, (long)((Integer)value).intValue());
                                continue;
                            }
                            if (value instanceof Bitmap) {
                                builder.putBitmap(this.metadataExtrasPrefix + key, (Bitmap)value);
                                continue;
                            }
                            if (!(value instanceof RatingCompat)) continue;
                            builder.putRating(this.metadataExtrasPrefix + key, (RatingCompat)value);
                        }
                    }
                    if (description.getTitle() != null) {
                        String title = String.valueOf(description.getTitle());
                        builder.putString("android.media.metadata.TITLE", title);
                        builder.putString("android.media.metadata.DISPLAY_TITLE", title);
                    }
                    if (description.getSubtitle() != null) {
                        builder.putString("android.media.metadata.DISPLAY_SUBTITLE", String.valueOf(description.getSubtitle()));
                    }
                    if (description.getDescription() != null) {
                        builder.putString("android.media.metadata.DISPLAY_DESCRIPTION", String.valueOf(description.getDescription()));
                    }
                    if (description.getIconBitmap() != null) {
                        builder.putBitmap("android.media.metadata.DISPLAY_ICON", description.getIconBitmap());
                    }
                    if (description.getIconUri() != null) {
                        builder.putString("android.media.metadata.DISPLAY_ICON_URI", String.valueOf(description.getIconUri()));
                    }
                    if (description.getMediaId() != null) {
                        builder.putString("android.media.metadata.MEDIA_ID", String.valueOf(description.getMediaId()));
                    }
                    if (description.getMediaUri() == null) break;
                    builder.putString("android.media.metadata.MEDIA_URI", String.valueOf(description.getMediaUri()));
                    break;
                }
            }
            return builder.build();
        }
    }

    public static interface MediaMetadataProvider {
        public MediaMetadataCompat getMetadata(Player var1);
    }

    public static interface CustomActionProvider {
        public void onCustomAction(String var1, Bundle var2);

        public PlaybackStateCompat.CustomAction getCustomAction();
    }

    public static interface RatingCallback
    extends CommandReceiver {
        public static final long ACTIONS = 128L;

        public void onSetRating(Player var1, RatingCompat var2);

        public void onSetRating(Player var1, RatingCompat var2, Bundle var3);
    }

    public static interface QueueEditor
    extends CommandReceiver {
        public void onAddQueueItem(Player var1, MediaDescriptionCompat var2);

        public void onAddQueueItem(Player var1, MediaDescriptionCompat var2, int var3);

        public void onRemoveQueueItem(Player var1, MediaDescriptionCompat var2);
    }

    public static interface QueueNavigator
    extends CommandReceiver {
        public static final long ACTIONS = 4144L;

        public long getSupportedQueueNavigatorActions(@Nullable Player var1);

        public void onTimelineChanged(Player var1);

        public void onCurrentWindowIndexChanged(Player var1);

        public long getActiveQueueItemId(@Nullable Player var1);

        public void onSkipToPrevious(Player var1);

        public void onSkipToQueueItem(Player var1, long var2);

        public void onSkipToNext(Player var1);
    }

    public static interface PlaybackController
    extends CommandReceiver {
        public static final long ACTIONS = 2360143L;

        public long getSupportedPlaybackActions(@Nullable Player var1);

        public void onPlay(Player var1);

        public void onPause(Player var1);

        public void onSeekTo(Player var1, long var2);

        public void onFastForward(Player var1);

        public void onRewind(Player var1);

        public void onStop(Player var1);

        public void onSetShuffleMode(Player var1, int var2);

        public void onSetRepeatMode(Player var1, int var2);
    }

    public static interface PlaybackPreparer
    extends CommandReceiver {
        public static final long ACTIONS = 257024L;

        public long getSupportedPrepareActions();

        public void onPrepare();

        public void onPrepareFromMediaId(String var1, Bundle var2);

        public void onPrepareFromSearch(String var1, Bundle var2);

        public void onPrepareFromUri(Uri var1, Bundle var2);
    }

    public static interface CommandReceiver {
        public String[] getCommands();

        public void onCommand(Player var1, String var2, Bundle var3, ResultReceiver var4);
    }
}

