/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.mediasession;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.media.session.PlaybackStateCompat;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.ext.mediasession.MediaSessionConnector;
import com.google.android.exoplayer2.ext.mediasession.R;
import com.google.android.exoplayer2.util.RepeatModeUtil;

public final class RepeatModeActionProvider
implements MediaSessionConnector.CustomActionProvider {
    private static final String ACTION_REPEAT_MODE = "ACTION_EXO_REPEAT_MODE";
    private final Player player;
    private final int repeatToggleModes;
    private final CharSequence repeatAllDescription;
    private final CharSequence repeatOneDescription;
    private final CharSequence repeatOffDescription;

    public RepeatModeActionProvider(Context context, Player player) {
        this(context, player, 3);
    }

    public RepeatModeActionProvider(Context context, Player player, int repeatToggleModes) {
        this.player = player;
        this.repeatToggleModes = repeatToggleModes;
        this.repeatAllDescription = context.getString(R.string.exo_media_action_repeat_all_description);
        this.repeatOneDescription = context.getString(R.string.exo_media_action_repeat_one_description);
        this.repeatOffDescription = context.getString(R.string.exo_media_action_repeat_off_description);
    }

    @Override
    public void onCustomAction(String action, Bundle extras) {
        int proposedMode;
        int mode = this.player.getRepeatMode();
        if (mode != (proposedMode = RepeatModeUtil.getNextRepeatMode((int)mode, (int)this.repeatToggleModes))) {
            this.player.setRepeatMode(proposedMode);
        }
    }

    @Override
    public PlaybackStateCompat.CustomAction getCustomAction() {
        int iconResourceId;
        CharSequence actionLabel;
        switch (this.player.getRepeatMode()) {
            case 1: {
                actionLabel = this.repeatOneDescription;
                iconResourceId = R.drawable.exo_media_action_repeat_one;
                break;
            }
            case 2: {
                actionLabel = this.repeatAllDescription;
                iconResourceId = R.drawable.exo_media_action_repeat_all;
                break;
            }
            default: {
                actionLabel = this.repeatOffDescription;
                iconResourceId = R.drawable.exo_media_action_repeat_off;
            }
        }
        PlaybackStateCompat.CustomAction.Builder repeatBuilder = new PlaybackStateCompat.CustomAction.Builder(ACTION_REPEAT_MODE, actionLabel, iconResourceId);
        return repeatBuilder.build();
    }
}

