/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.mediasession;

import android.os.Bundle;
import android.os.ResultReceiver;
import android.support.annotation.Nullable;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.session.MediaSessionCompat;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.ext.mediasession.MediaSessionConnector;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Collections;

public abstract class TimelineQueueNavigator
implements MediaSessionConnector.QueueNavigator {
    public static final long MAX_POSITION_FOR_SEEK_TO_PREVIOUS = 3000L;
    public static final int DEFAULT_MAX_QUEUE_SIZE = 10;
    private final MediaSessionCompat mediaSession;
    private final Timeline.Window window;
    protected final int maxQueueSize;
    private long activeQueueItemId;

    public TimelineQueueNavigator(MediaSessionCompat mediaSession) {
        this(mediaSession, 10);
    }

    public TimelineQueueNavigator(MediaSessionCompat mediaSession, int maxQueueSize) {
        this.mediaSession = mediaSession;
        this.maxQueueSize = maxQueueSize;
        this.activeQueueItemId = -1L;
        this.window = new Timeline.Window();
    }

    public abstract MediaDescriptionCompat getMediaDescription(Player var1, int var2);

    @Override
    public long getSupportedQueueNavigatorActions(Player player) {
        if (player == null) {
            return 0L;
        }
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty() || player.isPlayingAd()) {
            return 0L;
        }
        long actions = 0L;
        if (timeline.getWindowCount() > 1) {
            actions |= 0x1000L;
        }
        if (this.window.isSeekable || !this.window.isDynamic || player.hasPrevious()) {
            actions |= 0x10L;
        }
        if (this.window.isDynamic || player.hasNext()) {
            actions |= 0x20L;
        }
        return actions;
    }

    @Override
    public final void onTimelineChanged(Player player) {
        this.publishFloatingQueueWindow(player);
    }

    @Override
    public final void onCurrentWindowIndexChanged(Player player) {
        if (this.activeQueueItemId == -1L || player.getCurrentTimeline().getWindowCount() > this.maxQueueSize) {
            this.publishFloatingQueueWindow(player);
        } else if (!player.getCurrentTimeline().isEmpty()) {
            this.activeQueueItemId = player.getCurrentWindowIndex();
        }
    }

    @Override
    public final long getActiveQueueItemId(@Nullable Player player) {
        return this.activeQueueItemId;
    }

    @Override
    public void onSkipToPrevious(Player player) {
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty() || player.isPlayingAd()) {
            return;
        }
        int windowIndex = player.getCurrentWindowIndex();
        timeline.getWindow(windowIndex, this.window);
        int previousWindowIndex = player.getPreviousWindowIndex();
        if (previousWindowIndex != -1 && (player.getCurrentPosition() <= 3000L || this.window.isDynamic && !this.window.isSeekable)) {
            player.seekTo(previousWindowIndex, -9223372036854775807L);
        } else {
            player.seekTo(0L);
        }
    }

    @Override
    public void onSkipToQueueItem(Player player, long id) {
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty() || player.isPlayingAd()) {
            return;
        }
        int windowIndex = (int)id;
        if (0 <= windowIndex && windowIndex < timeline.getWindowCount()) {
            player.seekTo(windowIndex, -9223372036854775807L);
        }
    }

    @Override
    public void onSkipToNext(Player player) {
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty() || player.isPlayingAd()) {
            return;
        }
        int windowIndex = player.getCurrentWindowIndex();
        int nextWindowIndex = player.getNextWindowIndex();
        if (nextWindowIndex != -1) {
            player.seekTo(nextWindowIndex, -9223372036854775807L);
        } else if (timeline.getWindow((int)windowIndex, (Timeline.Window)this.window).isDynamic) {
            player.seekTo(windowIndex, -9223372036854775807L);
        }
    }

    @Override
    public String[] getCommands() {
        return null;
    }

    @Override
    public void onCommand(Player player, String command, Bundle extras, ResultReceiver cb) {
    }

    private void publishFloatingQueueWindow(Player player) {
        if (player.getCurrentTimeline().isEmpty()) {
            this.mediaSession.setQueue(Collections.emptyList());
            this.activeQueueItemId = -1L;
            return;
        }
        int windowCount = player.getCurrentTimeline().getWindowCount();
        int currentWindowIndex = player.getCurrentWindowIndex();
        int queueSize = Math.min(this.maxQueueSize, windowCount);
        int startIndex = Util.constrainValue((int)(currentWindowIndex - (queueSize - 1) / 2), (int)0, (int)(windowCount - queueSize));
        ArrayList<MediaSessionCompat.QueueItem> queue = new ArrayList<MediaSessionCompat.QueueItem>();
        for (int i = startIndex; i < startIndex + queueSize; ++i) {
            queue.add(new MediaSessionCompat.QueueItem(this.getMediaDescription(player, i), (long)i));
        }
        this.mediaSession.setQueue(queue);
        this.activeQueueItemId = currentWindowIndex;
    }
}

