/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.base.zar;

@KeepForSdk
public final class ListenerHolder<L> {
    private final zaa zajm;
    private volatile L zajn;
    private final ListenerKey<L> zajo;

    @KeepForSdk
    ListenerHolder(@NonNull Looper looper, @NonNull L l, @NonNull String string2) {
        this.zajm = new zaa(looper);
        this.zajn = Preconditions.checkNotNull(l, (Object)"Listener must not be null");
        this.zajo = new ListenerKey<L>(l, Preconditions.checkNotEmpty((String)string2));
    }

    @KeepForSdk
    public final void notifyListener(Notifier<? super L> notifier) {
        Preconditions.checkNotNull(notifier, (Object)"Notifier must not be null");
        Message message = this.zajm.obtainMessage(1, notifier);
        this.zajm.sendMessage(message);
    }

    @KeepForSdk
    public final boolean hasListener() {
        return this.zajn != null;
    }

    @KeepForSdk
    public final void clear() {
        this.zajn = null;
    }

    @NonNull
    @KeepForSdk
    public final ListenerKey<L> getListenerKey() {
        return this.zajo;
    }

    @KeepForSdk
    final void notifyListenerInternal(Notifier<? super L> notifier) {
        L l = this.zajn;
        if (l == null) {
            notifier.onNotifyListenerFailed();
            return;
        }
        try {
            notifier.notifyListener(l);
            return;
        }
        catch (RuntimeException runtimeException) {
            notifier.onNotifyListenerFailed();
            throw runtimeException;
        }
    }

    @KeepForSdk
    public static final class ListenerKey<L> {
        private final L zajn;
        private final String zajp;

        @KeepForSdk
        ListenerKey(L l, String string2) {
            this.zajn = l;
            this.zajp = string2;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ListenerKey)) {
                return false;
            }
            ListenerKey listenerKey = (ListenerKey)object;
            return this.zajn == listenerKey.zajn && this.zajp.equals(listenerKey.zajp);
        }

        public final int hashCode() {
            int n = System.identityHashCode(this.zajn);
            return n * 31 + this.zajp.hashCode();
        }
    }

    private final class zaa
    extends zar {
        public zaa(Looper looper) {
            super(looper);
        }

        public final void handleMessage(Message message) {
            Preconditions.checkArgument((message.what == 1 ? 1 : 0) != 0);
            Notifier notifier = (Notifier)message.obj;
            ListenerHolder.this.notifyListenerInternal(notifier);
        }
    }

    @KeepForSdk
    public static interface Notifier<L> {
        @KeepForSdk
        public void notifyListener(L var1);

        @KeepForSdk
        public void onNotifyListenerFailed();
    }
}

