/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.zaaj;
import com.google.android.gms.common.api.internal.zaal;
import com.google.android.gms.common.api.internal.zaam;
import com.google.android.gms.common.api.internal.zaaq;
import com.google.android.gms.common.api.internal.zaar;
import com.google.android.gms.common.api.internal.zabb;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabf;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.internal.zak;
import com.google.android.gms.signin.zac;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zaak
implements zabb {
    private final zabe zafv;
    private final Lock zaer;
    private final Context mContext;
    private final GoogleApiAvailabilityLight zaey;
    private ConnectionResult zafi;
    private int zaga;
    private int zagb = 0;
    private int zagc;
    private final Bundle zagd = new Bundle();
    private final Set<Api.AnyClientKey> zage = new HashSet<Api.AnyClientKey>();
    private zac zagf;
    private boolean zagg;
    private boolean zagh;
    private boolean zagi;
    private IAccountAccessor zagj;
    private boolean zagk;
    private boolean zagl;
    private final ClientSettings zafa;
    private final Map<Api<?>, Boolean> zaew;
    private final Api.AbstractClientBuilder<? extends zac, SignInOptions> zacf;
    private ArrayList<Future<?>> zagm = new ArrayList();

    public zaak(zabe zabe2, ClientSettings clientSettings, Map<Api<?>, Boolean> map, GoogleApiAvailabilityLight googleApiAvailabilityLight, Api.AbstractClientBuilder<? extends zac, SignInOptions> abstractClientBuilder, Lock lock, Context context) {
        this.zafv = zabe2;
        this.zafa = clientSettings;
        this.zaew = map;
        this.zaey = googleApiAvailabilityLight;
        this.zacf = abstractClientBuilder;
        this.zaer = lock;
        this.mContext = context;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void begin() {
        this.zafv.zaht.clear();
        this.zagh = false;
        this.zafi = null;
        this.zagb = 0;
        this.zagg = true;
        this.zagi = false;
        this.zagk = false;
        boolean bl = false;
        HashMap<Api.Client, zaam> hashMap = new HashMap<Api.Client, zaam>();
        for (Api<?> api : this.zaew.keySet()) {
            Api.Client client = this.zafv.zahd.get(api.getClientKey());
            bl |= api.zah().getPriority() == 1;
            boolean bl2 = this.zaew.get(api);
            if (client.requiresSignIn()) {
                this.zagh = true;
                if (bl2) {
                    this.zage.add(api.getClientKey());
                } else {
                    this.zagg = false;
                }
            }
            hashMap.put(client, new zaam(this, api, bl2));
        }
        if (bl) {
            this.zagh = false;
        }
        if (this.zagh) {
            this.zafa.setClientSessionId(System.identityHashCode(this.zafv.zaeh));
            zaar zaar2 = new zaar(this, null);
            this.zagf = this.zacf.buildClient(this.mContext, ((GoogleApiClient)this.zafv.zaeh).getLooper(), this.zafa, this.zafa.getSignInOptions(), zaar2, zaar2);
        }
        this.zagc = this.zafv.zahd.size();
        this.zagm.add(zabf.zaaz().submit(new zaal(this, hashMap)));
    }

    @GuardedBy(value="mLock")
    private final boolean zaam() {
        --this.zagc;
        if (this.zagc > 0) {
            return false;
        }
        if (this.zagc < 0) {
            Log.w((String)"GACConnecting", (String)this.zafv.zaeh.zaaw());
            Log.wtf((String)"GACConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zae(new ConnectionResult(8, null));
            return false;
        }
        if (this.zafi != null) {
            this.zafv.zahw = this.zaga;
            this.zae(this.zafi);
            return false;
        }
        return true;
    }

    @GuardedBy(value="mLock")
    private final void zaa(zak zak2) {
        if (!this.zac(0)) {
            return;
        }
        ConnectionResult connectionResult = zak2.getConnectionResult();
        if (connectionResult.isSuccess()) {
            ResolveAccountResponse resolveAccountResponse = zak2.zacv();
            ConnectionResult connectionResult2 = resolveAccountResponse.getConnectionResult();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"GACConnecting", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zae(connectionResult2);
                return;
            }
            this.zagi = true;
            this.zagj = resolveAccountResponse.getAccountAccessor();
            this.zagk = resolveAccountResponse.getSaveDefaultAccount();
            this.zagl = resolveAccountResponse.isFromCrossClientAuth();
            this.zaan();
            return;
        }
        if (this.zad(connectionResult)) {
            this.zaap();
            this.zaan();
            return;
        }
        this.zae(connectionResult);
    }

    @GuardedBy(value="mLock")
    private final void zaan() {
        if (this.zagc != 0) {
            return;
        }
        if (!this.zagh || this.zagi) {
            zaak zaak2 = this;
            ArrayList<Api.Client> arrayList = new ArrayList<Api.Client>();
            zaak2.zagb = 1;
            zaak2.zagc = zaak2.zafv.zahd.size();
            for (Api.AnyClientKey<?> anyClientKey : zaak2.zafv.zahd.keySet()) {
                if (zaak2.zafv.zaht.containsKey(anyClientKey)) {
                    if (!zaak2.zaam()) continue;
                    zaak2.zaao();
                    continue;
                }
                arrayList.add(zaak2.zafv.zahd.get(anyClientKey));
            }
            if (!arrayList.isEmpty()) {
                zaak2.zagm.add(zabf.zaaz().submit(new zaaq(zaak2, arrayList)));
            }
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void onConnected(Bundle bundle) {
        if (!this.zac(1)) {
            return;
        }
        if (bundle != null) {
            this.zagd.putAll(bundle);
        }
        if (this.zaam()) {
            this.zaao();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (!this.zac(1)) {
            return;
        }
        this.zab(connectionResult, api, bl);
        if (this.zaam()) {
            this.zaao();
        }
    }

    @GuardedBy(value="mLock")
    private final void zaao() {
        this.zafv.zaay();
        zabf.zaaz().execute(new zaaj(this));
        if (this.zagf != null) {
            if (this.zagk) {
                this.zagf.zaa(this.zagj, this.zagl);
            }
            this.zab(false);
        }
        for (Api.AnyClientKey<?> anyClientKey : this.zafv.zaht.keySet()) {
            this.zafv.zahd.get(anyClientKey).disconnect();
        }
        Bundle bundle = this.zagd.isEmpty() ? null : this.zagd;
        this.zafv.zahx.zab(bundle);
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(T t) {
        this.zafv.zaeh.zafd.add(t);
        return t;
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public final void connect() {
    }

    @Override
    @GuardedBy(value="mLock")
    public final boolean disconnect() {
        this.zaaq();
        this.zab(true);
        this.zafv.zaf(null);
        return true;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void onConnectionSuspended(int n) {
        this.zae(new ConnectionResult(8, null));
    }

    /*
     * Unable to fully structure code
     */
    @GuardedBy(value="mLock")
    private final void zab(ConnectionResult var1_1, Api<?> var2_2, boolean var3_3) {
        block3: {
            var4_4 = var2_2.zah().getPriority();
            var7_5 = var1_1;
            var6_6 = var3_3;
            var5_7 = this;
            if (!var6_6) break block3;
            var9_8 = var7_5;
            var8_9 = var5_7;
            if (!(var9_8.hasResolution() != false ? true : var8_9.zaey.getErrorResolutionIntent(var9_8.getErrorCode()) != null)) ** GOTO lbl-1000
        }
        if (var5_7.zafi == null || var4_4 < var5_7.zaga) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (v0) {
            this.zafi = var1_1;
            this.zaga = var4_4;
        }
        this.zafv.zaht.put(var2_2.getClientKey(), var1_1);
    }

    @GuardedBy(value="mLock")
    private final void zaap() {
        this.zagh = false;
        this.zafv.zaeh.zahe = Collections.emptySet();
        for (Api.AnyClientKey anyClientKey : this.zage) {
            if (this.zafv.zaht.containsKey(anyClientKey)) continue;
            this.zafv.zaht.put(anyClientKey, new ConnectionResult(17, null));
        }
    }

    @GuardedBy(value="mLock")
    private final boolean zad(ConnectionResult connectionResult) {
        return this.zagg && !connectionResult.hasResolution();
    }

    @GuardedBy(value="mLock")
    private final void zae(ConnectionResult connectionResult) {
        this.zaaq();
        this.zab(!connectionResult.hasResolution());
        this.zafv.zaf(connectionResult);
        this.zafv.zahx.zac(connectionResult);
    }

    @GuardedBy(value="mLock")
    private final void zab(boolean bl) {
        if (this.zagf != null) {
            if (this.zagf.isConnected() && bl) {
                this.zagf.zacu();
            }
            this.zagf.disconnect();
            if (this.zafa.isSignInClientDisconnectFixEnabled()) {
                this.zagf = null;
            }
            this.zagj = null;
        }
    }

    private final void zaaq() {
        ArrayList<Future<?>> arrayList = this.zagm;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Future<?> future = arrayList.get(i);
            future.cancel(true);
        }
        this.zagm.clear();
    }

    private final Set<Scope> zaar() {
        if (this.zafa == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zafa.getRequiredScopes());
        Map<Api<?>, ClientSettings.OptionalApiSettings> map = this.zafa.getOptionalApiSettings();
        for (Api<?> api : map.keySet()) {
            if (this.zafv.zaht.containsKey(api.getClientKey())) continue;
            hashSet.addAll(map.get(api).mScopes);
        }
        return hashSet;
    }

    @GuardedBy(value="mLock")
    private final boolean zac(int n) {
        if (this.zagb != n) {
            Log.w((String)"GACConnecting", (String)this.zafv.zaeh.zaaw());
            String string2 = String.valueOf(this);
            Log.w((String)"GACConnecting", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Unexpected callback in ").append(string2).toString());
            int n2 = this.zagc;
            Log.w((String)"GACConnecting", (String)new StringBuilder(33).append("mRemainingConnections=").append(n2).toString());
            String string3 = zaak.zad(this.zagb);
            String string4 = zaak.zad(n);
            Log.e((String)"GACConnecting", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("GoogleApiClient connecting is in step ").append(string3).append(" but received callback for step ").append(string4).toString(), (Throwable)new Exception());
            this.zae(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private static String zad(int n) {
        switch (n) {
            case 0: {
                return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
            }
            case 1: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ Context zaa(zaak zaak2) {
        return zaak2.mContext;
    }

    static /* synthetic */ GoogleApiAvailabilityLight zab(zaak zaak2) {
        return zaak2.zaey;
    }

    static /* synthetic */ Lock zac(zaak zaak2) {
        return zaak2.zaer;
    }

    static /* synthetic */ zabe zad(zaak zaak2) {
        return zaak2.zafv;
    }

    static /* synthetic */ void zaa(zaak zaak2, ConnectionResult connectionResult) {
        zaak2.zae(connectionResult);
    }

    static /* synthetic */ boolean zae(zaak zaak2) {
        return zaak2.zagh;
    }

    static /* synthetic */ zac zaf(zaak zaak2) {
        return zaak2.zagf;
    }

    static /* synthetic */ Set zag(zaak zaak2) {
        return zaak2.zaar();
    }

    static /* synthetic */ IAccountAccessor zah(zaak zaak2) {
        return zaak2.zagj;
    }

    static /* synthetic */ ClientSettings zai(zaak zaak2) {
        return zaak2.zafa;
    }

    static /* synthetic */ boolean zab(zaak zaak2, ConnectionResult connectionResult) {
        return zaak2.zad(connectionResult);
    }

    static /* synthetic */ void zaj(zaak zaak2) {
        zaak2.zaap();
    }

    static /* synthetic */ void zak(zaak zaak2) {
        zaak2.zaan();
    }

    static /* synthetic */ boolean zaa(zaak zaak2, int n) {
        return zaak2.zac(0);
    }

    static /* synthetic */ void zaa(zaak zaak2, ConnectionResult connectionResult, Api api, boolean bl) {
        zaak2.zab(connectionResult, api, bl);
    }

    static /* synthetic */ boolean zal(zaak zaak2) {
        return zaak2.zaam();
    }

    static /* synthetic */ void zaa(zaak zaak2, zak zak2) {
        zaak2.zaa(zak2);
    }
}

