/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.LifecycleActivity;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.api.internal.zaav;
import com.google.android.gms.common.api.internal.zaax;
import com.google.android.gms.common.api.internal.zaay;
import com.google.android.gms.common.api.internal.zaaz;
import com.google.android.gms.common.api.internal.zaba;
import com.google.android.gms.common.api.internal.zabc;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabq;
import com.google.android.gms.common.api.internal.zabr;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zack;
import com.google.android.gms.common.api.internal.zacp;
import com.google.android.gms.common.api.internal.zai;
import com.google.android.gms.common.api.internal.zap;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.api.internal.zav;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClientEventManager;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.Common;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zac;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zaaw
extends GoogleApiClient
implements zabs {
    private final Lock zaer;
    private boolean zaci;
    private final GmsClientEventManager zagw;
    private zabr zagx = null;
    private final int zacc;
    private final Context mContext;
    private final Looper zabl;
    @VisibleForTesting
    final Queue<BaseImplementation.ApiMethodImpl<?, ?>> zafd = new LinkedList();
    private volatile boolean zagy;
    private long zagz = ClientLibraryUtils.isPackageSide() ? 10000L : 120000L;
    private long zaha = 5000L;
    private final zaaz zahb;
    private final GoogleApiAvailability zace;
    @VisibleForTesting
    private zabq zahc;
    final Map<Api.AnyClientKey<?>, Api.Client> zahd;
    Set<Scope> zahe = new HashSet<Scope>();
    private final ClientSettings zafa;
    private final Map<Api<?>, Boolean> zaew;
    private final Api.AbstractClientBuilder<? extends zac, SignInOptions> zacf;
    private final ListenerHolders zahf = new ListenerHolders();
    private final ArrayList<zap> zahg;
    private Integer zahh = null;
    Set<zack> zahi = null;
    final zacp zahj;
    private final GmsClientEventManager.GmsClientEventState zahk = new zaav(this);

    public zaaw(Context context, Lock lock, Looper looper, ClientSettings clientSettings, GoogleApiAvailability googleApiAvailability, Api.AbstractClientBuilder<? extends zac, SignInOptions> abstractClientBuilder, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.AnyClientKey<?>, Api.Client> map2, int n, int n2, ArrayList<zap> arrayList, boolean bl) {
        this.mContext = context;
        this.zaer = lock;
        this.zaci = false;
        this.zagw = new GmsClientEventManager(looper, this.zahk);
        this.zabl = looper;
        this.zahb = new zaaz(this, looper);
        this.zace = googleApiAvailability;
        this.zacc = n;
        if (this.zacc >= 0) {
            this.zahh = n2;
        }
        this.zaew = map;
        this.zahd = map2;
        this.zahg = arrayList;
        this.zahj = new zacp(this.zahd);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zagw.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zagw.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zafa = clientSettings;
        this.zacf = abstractClientBuilder;
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        Preconditions.checkArgument((t.getClientKey() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.getApi() != null ? t.getApi().getName() : "the API";
        Preconditions.checkArgument((boolean)this.zahd.containsKey(t.getClientKey()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zaer.lock();
        try {
            if (this.zagx == null) {
                this.zafd.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zagx.enqueue(t);
            return (T)string2;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        Preconditions.checkArgument((t.getClientKey() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.getApi() != null ? t.getApi().getName() : "the API";
        Preconditions.checkArgument((boolean)this.zahd.containsKey(t.getClientKey()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zaer.lock();
        try {
            if (this.zagx == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zagy) {
                this.zafd.add(t);
                while (!this.zafd.isEmpty()) {
                    object = this.zafd.remove();
                    this.zahj.zac((BasePendingResult<? extends Result>)object);
                    ((BaseImplementation.ApiMethodImpl)object).setFailedResult(Status.RESULT_INTERNAL_ERROR);
                }
                object = t;
                return (T)object;
            }
            object = this.zagx.execute(t);
            return (T)object;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final <L> ListenerHolder<L> registerListener(@NonNull L l) {
        this.zaer.lock();
        try {
            Looper looper = this.zabl;
            L l2 = l;
            ListenerHolder<L> listenerHolder = this.zahf.zaa(l2, looper, "NO_TYPE");
            return listenerHolder;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.Client> C getClient(@NonNull Api.AnyClientKey<C> anyClientKey) {
        Api.Client client = this.zahd.get(anyClientKey);
        Preconditions.checkNotNull((Object)client, (Object)"Appropriate Api was not requested.");
        return (C)client;
    }

    @Override
    public final boolean hasApi(@NonNull Api<?> api) {
        return this.zahd.containsKey(api.getClientKey());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((GoogleApiClient)this).isConnected()) {
            return false;
        }
        Api.Client client = this.zahd.get(api.getClientKey());
        return client != null && client.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zaer.lock();
                    if (!((GoogleApiClient)this).isConnected() && !this.zagy) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zahd.containsKey(api.getClientKey())) break block6;
                    connectionResult = this.zagx.getConnectionResult(api);
                    if (connectionResult != null) break block7;
                    if (!this.zagy) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.RESULT_SUCCESS;
                    this.zaer.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zaaw());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zaer.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zaer.lock();
        try {
            if (this.zacc >= 0) {
                Preconditions.checkState((this.zahh != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zahh == null) {
                this.zahh = zaaw.zaa(this.zahd.values(), false);
            } else if (this.zahh == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            ((GoogleApiClient)this).connect(this.zahh);
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zaer.lock();
        try {
            Preconditions.checkArgument((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zae(n);
            this.zaas();
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        Preconditions.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zaer.lock();
        try {
            if (this.zacc >= 0) {
                Preconditions.checkState((this.zahh != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zahh == null) {
                this.zahh = zaaw.zaa(this.zahd.values(), false);
            } else if (this.zahh == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zae(this.zahh);
            this.zagw.enableCallbacks();
            ConnectionResult connectionResult = this.zagx.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        Preconditions.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zaer.lock();
        try {
            if (this.zahh == null) {
                this.zahh = zaaw.zaa(this.zahd.values(), false);
            } else if (this.zahh == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zae(this.zahh);
            this.zagw.enableCallbacks();
            ConnectionResult connectionResult = this.zagx.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zaer.lock();
        try {
            this.zahj.release();
            if (this.zagx != null) {
                this.zagx.disconnect();
            }
            this.zahf.release();
            for (BaseImplementation.ApiMethodImpl apiMethodImpl : this.zafd) {
                apiMethodImpl.zaa(null);
                ((PendingResult)apiMethodImpl).cancel();
            }
            this.zafd.clear();
            if (this.zagx == null) {
                return;
            }
            this.zaau();
            this.zagw.disableCallbacks();
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final void reconnect() {
        ((GoogleApiClient)this).disconnect();
        ((GoogleApiClient)this).connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        Preconditions.checkState((boolean)((GoogleApiClient)this).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        Preconditions.checkState((this.zahh != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        StatusPendingResult statusPendingResult = new StatusPendingResult(this);
        if (this.zahd.containsKey(Common.CLIENT_KEY)) {
            this.zaa(this, statusPendingResult, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zaay zaay2 = new zaay(this, atomicReference, statusPendingResult);
            zaax zaax2 = new zaax(this, statusPendingResult);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(Common.API).addConnectionCallbacks(zaay2).addOnConnectionFailedListener(zaax2).setHandler(this.zahb).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return statusPendingResult;
    }

    private final void zaa(GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        Common.zapw.zaa(googleApiClient).setResultCallback(new zaba(this, statusPendingResult, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        LifecycleActivity lifecycleActivity = new LifecycleActivity((Activity)fragmentActivity);
        zaaw zaaw2 = this;
        if (zaaw2.zacc >= 0) {
            zai.zaa(lifecycleActivity).zaa(zaaw2.zacc);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zagx != null && this.zagx.isConnected();
    }

    @Override
    public final boolean isConnecting() {
        return this.zagx != null && this.zagx.isConnecting();
    }

    private final void zae(int n) {
        if (this.zahh == null) {
            this.zahh = n;
        } else if (this.zahh != n) {
            String string2 = zaaw.zaf(n);
            String string3 = zaaw.zaf(this.zahh);
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zagx != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.Client client : this.zahd.values()) {
            if (client.requiresSignIn()) {
                bl = true;
            }
            if (!client.providesSignIn()) continue;
            bl2 = true;
        }
        switch (this.zahh) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zaci) {
                    this.zagx = new zav(this.mContext, this.zaer, this.zabl, this.zace, this.zahd, this.zafa, this.zaew, this.zacf, this.zahg, this, true);
                    return;
                }
                this.zagx = zaq.zaa(this.mContext, this, this.zaer, this.zabl, this.zace, this.zahd, this.zafa, this.zaew, this.zacf, this.zahg);
                return;
            }
        }
        if (this.zaci && !bl2) {
            this.zagx = new zav(this.mContext, this.zaer, this.zabl, this.zace, this.zahd, this.zafa, this.zaew, this.zacf, this.zahg, this, false);
            return;
        }
        this.zagx = new zabe(this.mContext, this, this.zaer, this.zabl, this.zace, this.zahd, this.zafa, this.zaew, this.zacf, this.zahg, this);
    }

    @GuardedBy(value="mLock")
    private final void zaas() {
        this.zagw.enableCallbacks();
        this.zagx.connect();
    }

    private final void resume() {
        this.zaer.lock();
        try {
            if (this.zagy) {
                this.zaas();
            }
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    private final void zaat() {
        this.zaer.lock();
        try {
            if (this.zaau()) {
                this.zaas();
            }
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @GuardedBy(value="mLock")
    final boolean zaau() {
        if (!this.zagy) {
            return false;
        }
        this.zagy = false;
        this.zahb.removeMessages(2);
        this.zahb.removeMessages(1);
        if (this.zahc != null) {
            this.zahc.unregister();
            this.zahc = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zagw.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zagw.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zagw.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zagw.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zagw.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zagw.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zab(Bundle bundle) {
        while (!this.zafd.isEmpty()) {
            ((GoogleApiClient)this).execute(this.zafd.remove());
        }
        this.zagw.onConnectionSuccess(bundle);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zac(ConnectionResult connectionResult) {
        if (!this.zace.isPlayServicesPossiblyUpdating(this.mContext, connectionResult.getErrorCode())) {
            this.zaau();
        }
        if (!this.zagy) {
            this.zagw.onConnectionFailure(connectionResult);
            this.zagw.disableCallbacks();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zab(int n, boolean bl) {
        if (n == 1 && !bl) {
            zaaw zaaw2 = this;
            if (!zaaw2.zagy) {
                zaaw2.zagy = true;
                if (zaaw2.zahc == null && !ClientLibraryUtils.isPackageSide()) {
                    try {
                        zaaw2.zahc = zaaw2.zace.zaa(zaaw2.mContext.getApplicationContext(), new zabc(zaaw2));
                    }
                    catch (SecurityException securityException) {}
                }
                zaaw2.zahb.sendMessageDelayed(zaaw2.zahb.obtainMessage(1), zaaw2.zagz);
                zaaw2.zahb.sendMessageDelayed(zaaw2.zahb.obtainMessage(2), zaaw2.zaha);
            }
        }
        this.zahj.zabv();
        this.zagw.onUnintentionalDisconnection(n);
        this.zagw.disableCallbacks();
        if (n == 2) {
            this.zaas();
        }
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zabl;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        return this.zagx != null && this.zagx.maybeSignIn(signInConnectionListener);
    }

    @Override
    public final void maybeSignOut() {
        if (this.zagx != null) {
            this.zagx.maybeSignOut();
        }
    }

    @Override
    public final void zaa(zack zack2) {
        this.zaer.lock();
        try {
            if (this.zahi == null) {
                this.zahi = new HashSet<zack>();
            }
            this.zahi.add(zack2);
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final void zab(zack zack2) {
        this.zaer.lock();
        try {
            if (this.zahi == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zahi.remove(zack2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zaav()) {
                this.zagx.zau();
            }
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    final boolean zaav() {
        this.zaer.lock();
        try {
            if (this.zahi == null) {
                return false;
            }
            boolean bl = !this.zahi.isEmpty();
            return bl;
        }
        finally {
            this.zaer.unlock();
        }
    }

    final String zaaw() {
        StringWriter stringWriter = new StringWriter();
        ((GoogleApiClient)this).dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zagy);
        printWriter.append(" mWorkQueue.size()=").print(this.zafd.size());
        PrintWriter printWriter2 = printWriter;
        zacp zacp2 = this.zahj;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zacp2.zald.size());
        if (this.zagx != null) {
            this.zagx.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zaa(Iterable<Api.Client> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.Client client : iterable) {
            if (client.requiresSignIn()) {
                bl2 = true;
            }
            if (!client.providesSignIn()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zaf(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zaa(zaaw zaaw2) {
        zaaw2.resume();
    }

    static /* synthetic */ void zab(zaaw zaaw2) {
        zaaw2.zaat();
    }

    static /* synthetic */ void zaa(zaaw zaaw2, GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        zaaw2.zaa(googleApiClient, statusPendingResult, true);
    }

    static /* synthetic */ Context zac(zaaw zaaw2) {
        return zaaw2.mContext;
    }
}

