/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaaf;
import com.google.android.gms.common.api.internal.zaak;
import com.google.android.gms.common.api.internal.zaat;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zabb;
import com.google.android.gms.common.api.internal.zabd;
import com.google.android.gms.common.api.internal.zabg;
import com.google.android.gms.common.api.internal.zabr;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zap;
import com.google.android.gms.common.api.internal.zar;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zac;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zabe
implements zabr,
zar {
    private final Lock zaer;
    private final Condition zahr;
    private final Context mContext;
    private final GoogleApiAvailabilityLight zaey;
    private final zabg zahs;
    final Map<Api.AnyClientKey<?>, Api.Client> zahd;
    final Map<Api.AnyClientKey<?>, ConnectionResult> zaht = new HashMap();
    private final ClientSettings zafa;
    private final Map<Api<?>, Boolean> zaew;
    private final Api.AbstractClientBuilder<? extends zac, SignInOptions> zacf;
    private volatile zabb zahu;
    private ConnectionResult zahv = null;
    int zahw;
    final zaaw zaeh;
    final zabs zahx;

    public zabe(Context context, zaaw zaaw2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends zac, SignInOptions> abstractClientBuilder, ArrayList<zap> arrayList, zabs zabs2) {
        this.mContext = context;
        this.zaer = lock;
        this.zaey = googleApiAvailabilityLight;
        this.zahd = map;
        this.zafa = clientSettings;
        this.zaew = map2;
        this.zacf = abstractClientBuilder;
        this.zaeh = zaaw2;
        this.zahx = zabs2;
        ArrayList<zap> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zap zap2 = arrayList2.get(i);
            zap2.zaa(this);
        }
        this.zahs = new zabg(this, looper);
        this.zahr = lock.newCondition();
        this.zahu = new zaat(this);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        t.zar();
        return this.zahu.enqueue(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        t.zar();
        return this.zahu.execute(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void connect() {
        this.zahu.connect();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zahr.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zahv != null) {
            return this.zahv;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zahr.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zahv != null) {
            return this.zahv;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void disconnect() {
        if (this.zahu.disconnect()) {
            this.zaht.clear();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.AnyClientKey<?> anyClientKey = api.getClientKey();
        if (this.zahd.containsKey(anyClientKey)) {
            if (this.zahd.get(anyClientKey).isConnected()) {
                return ConnectionResult.RESULT_SUCCESS;
            }
            if (this.zaht.containsKey(anyClientKey)) {
                return this.zaht.get(anyClientKey);
            }
        }
        return null;
    }

    final void zaax() {
        this.zaer.lock();
        try {
            this.zahu = new zaak(this, this.zafa, this.zaew, this.zaey, this.zacf, this.zaer, this.mContext);
            this.zahu.begin();
            this.zahr.signalAll();
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    final void zaay() {
        this.zaer.lock();
        try {
            this.zaeh.zaau();
            this.zahu = new zaaf(this);
            this.zahu.begin();
            this.zahr.signalAll();
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    final void zaf(ConnectionResult connectionResult) {
        this.zaer.lock();
        try {
            this.zahv = connectionResult;
            this.zahu = new zaat(this);
            this.zahu.begin();
            this.zahr.signalAll();
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zahu instanceof zaaf;
    }

    @Override
    public final boolean isConnecting() {
        return this.zahu instanceof zaak;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        return false;
    }

    @Override
    public final void maybeSignOut() {
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zau() {
        if (this.isConnected()) {
            ((zaaf)this.zahu).zaak();
        }
    }

    @Override
    public final void zaa(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zaer.lock();
        try {
            this.zahu.zaa(connectionResult, api, bl);
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zaer.lock();
        try {
            this.zahu.onConnected(bundle);
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zaer.lock();
        try {
            this.zahu.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zaer.unlock();
        }
    }

    final void zaa(zabd zabd2) {
        Message message = this.zahs.obtainMessage(1, zabd2);
        this.zahs.sendMessage(message);
    }

    final void zab(RuntimeException runtimeException) {
        Message message = this.zahs.obtainMessage(2, runtimeException);
        this.zahs.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zahu);
        for (Api<?> api : this.zaew.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zahd.get(api.getClientKey()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zab(zabe zabe2) {
        return zabe2.zaer;
    }

    static /* synthetic */ zabb zac(zabe zabe2) {
        return zabe2.zahu;
    }
}

