/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zacb;
import com.google.android.gms.common.api.internal.zacm;
import com.google.android.gms.common.api.internal.zacn;
import com.google.android.gms.common.internal.Preconditions;
import java.lang.ref.WeakReference;
import javax.annotation.concurrent.GuardedBy;

public final class zack<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zakr = null;
    private zack<? extends Result> zaks = null;
    private volatile ResultCallbacks<? super R> zakt = null;
    private PendingResult<R> zaku = null;
    private final Object zadp = new Object();
    private Status zakv = null;
    private final WeakReference<GoogleApiClient> zadr;
    private final zacm zakw;
    private boolean zakx = false;

    public zack(WeakReference<GoogleApiClient> weakReference) {
        Preconditions.checkNotNull(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zadr = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zadr.get();
        this.zakw = new zacm(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zadp;
        synchronized (object) {
            Preconditions.checkState((this.zakr == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            Preconditions.checkState((this.zakt == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zakr = resultTransform;
            zack<R> zack2 = new zack<R>(this.zadr);
            this.zaks = zack2;
            this.zabs();
            return zack2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zadp;
        synchronized (object) {
            Preconditions.checkState((this.zakt == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            Preconditions.checkState((this.zakr == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zakt = resultCallbacks;
            this.zabs();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zadp;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zakr != null) {
                    zacb.zaaz().submit(new zacn(this, (Result)r));
                } else if (this.zabu()) {
                    this.zakt.onSuccess(r);
                }
            } else {
                this.zad(r.getStatus());
                zack.zab(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zaa(PendingResult<?> pendingResult) {
        Object object = this.zadp;
        synchronized (object) {
            this.zaku = pendingResult;
            this.zabs();
            return;
        }
    }

    @GuardedBy(value="mSyncToken")
    private final void zabs() {
        if (this.zakr == null && this.zakt == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zadr.get();
        if (!this.zakx && this.zakr != null && googleApiClient != null) {
            googleApiClient.zaa(this);
            this.zakx = true;
        }
        if (this.zakv != null) {
            this.zae(this.zakv);
            return;
        }
        if (this.zaku != null) {
            this.zaku.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zad(Status status) {
        Object object = this.zadp;
        synchronized (object) {
            this.zakv = status;
            this.zae(this.zakv);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zae(Status status) {
        Object object = this.zadp;
        synchronized (object) {
            if (this.zakr != null) {
                Status status2 = this.zakr.onFailure(status);
                Preconditions.checkNotNull((Object)status2, (Object)"onFailure must not return null");
                super.zad(status2);
            } else if (this.zabu()) {
                this.zakt.onFailure(status);
            }
            return;
        }
    }

    final void zabt() {
        this.zakt = null;
    }

    @GuardedBy(value="mSyncToken")
    private final boolean zabu() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zadr.get();
        return this.zakt != null && googleApiClient != null;
    }

    private static void zab(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zac(zack zack2) {
        return zack2.zakr;
    }

    static /* synthetic */ zacm zad(zack zack2) {
        return zack2.zakw;
    }

    static /* synthetic */ void zaa(zack zack2, Result result) {
        zack.zab(result);
    }

    static /* synthetic */ WeakReference zae(zack zack2) {
        return zack2.zadr;
    }

    static /* synthetic */ Object zaf(zack zack2) {
        return zack2.zadp;
    }

    static /* synthetic */ zack zag(zack zack2) {
        return zack2.zaks;
    }

    static /* synthetic */ void zaa(zack zack2, Status status) {
        zack2.zad(status);
    }
}

