/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.content.Context;
import android.view.View;
import androidx.collection.ArraySet;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.signin.SignInOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@VisibleForTesting
@KeepForSdk
public final class ClientSettings {
    private final Account account;
    private final Set<Scope> zaof;
    private final Set<Scope> zaog;
    private final Map<Api<?>, OptionalApiSettings> zaoh;
    private final int zaoi;
    private final View zaoj;
    private final String zaok;
    private final String zaol;
    private final SignInOptions zaom;
    private final boolean zaon;
    private Integer zaoo;
    public static final String KEY_CLIENT_SESSION_ID = "com.google.android.gms.common.internal.ClientSettings.sessionId";

    @KeepForSdk
    public static ClientSettings createDefault(Context context) {
        return new GoogleApiClient.Builder(context).buildClientSettings();
    }

    @KeepForSdk
    public ClientSettings(Account account, Set<Scope> set, Map<Api<?>, OptionalApiSettings> map, int n, View view, String string2, String string3, SignInOptions signInOptions) {
        this(account, set, map, n, view, string2, string3, signInOptions, false);
    }

    public ClientSettings(Account account, Set<Scope> set, Map<Api<?>, OptionalApiSettings> map, int n, View view, String string2, String string3, SignInOptions signInOptions, boolean bl) {
        this.account = account;
        this.zaof = set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
        this.zaoh = map == null ? Collections.emptyMap() : map;
        this.zaoj = view;
        this.zaoi = n;
        this.zaok = string2;
        this.zaol = string3;
        this.zaom = signInOptions;
        this.zaon = bl;
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zaof);
        for (OptionalApiSettings optionalApiSettings : this.zaoh.values()) {
            hashSet.addAll(optionalApiSettings.mScopes);
        }
        this.zaog = Collections.unmodifiableSet(hashSet);
    }

    @Deprecated
    @Nullable
    @KeepForSdk
    public final String getAccountName() {
        if (this.account != null) {
            return this.account.name;
        }
        return null;
    }

    @Nullable
    @KeepForSdk
    public final Account getAccount() {
        return this.account;
    }

    @KeepForSdk
    public final Account getAccountOrDefault() {
        if (this.account != null) {
            return this.account;
        }
        return new Account("<<default account>>", "com.google");
    }

    @KeepForSdk
    public final int getGravityForPopups() {
        return this.zaoi;
    }

    @KeepForSdk
    public final Set<Scope> getRequiredScopes() {
        return this.zaof;
    }

    @KeepForSdk
    public final Set<Scope> getAllRequestedScopes() {
        return this.zaog;
    }

    public final Map<Api<?>, OptionalApiSettings> getOptionalApiSettings() {
        return this.zaoh;
    }

    @Nullable
    @KeepForSdk
    public final String getRealClientPackageName() {
        return this.zaok;
    }

    @Nullable
    public final String getRealClientClassName() {
        return this.zaol;
    }

    @Nullable
    @KeepForSdk
    public final View getViewForPopups() {
        return this.zaoj;
    }

    @Nullable
    public final SignInOptions getSignInOptions() {
        return this.zaom;
    }

    @Nullable
    public final Integer getClientSessionId() {
        return this.zaoo;
    }

    public final void setClientSessionId(Integer n) {
        this.zaoo = n;
    }

    @KeepForSdk
    public final Set<Scope> getApplicableScopes(Api<?> api) {
        OptionalApiSettings optionalApiSettings = this.zaoh.get(api);
        if (optionalApiSettings == null || optionalApiSettings.mScopes.isEmpty()) {
            return this.zaof;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zaof);
        hashSet.addAll(optionalApiSettings.mScopes);
        return hashSet;
    }

    public final boolean isSignInClientDisconnectFixEnabled() {
        return this.zaon;
    }

    @KeepForSdk
    public static final class Builder {
        private Account account;
        private ArraySet<Scope> zaop;
        private Map<Api<?>, OptionalApiSettings> zaoh;
        private int zaoi = 0;
        private View zaoj;
        private String zaok;
        private String zaol;
        private SignInOptions zaom = SignInOptions.DEFAULT;
        private boolean zaoq;

        public final Builder setAccount(Account account) {
            this.account = account;
            return this;
        }

        public final Builder addRequiredScope(Scope scope) {
            if (this.zaop == null) {
                this.zaop = new ArraySet();
            }
            this.zaop.add((Object)scope);
            return this;
        }

        public final Builder addAllRequiredScopes(Collection<Scope> collection) {
            if (this.zaop == null) {
                this.zaop = new ArraySet();
            }
            this.zaop.addAll(collection);
            return this;
        }

        public final Builder setOptionalApiSettingsMap(Map<Api<?>, OptionalApiSettings> map) {
            this.zaoh = map;
            return this;
        }

        public final Builder setGravityForPopups(int n) {
            this.zaoi = n;
            return this;
        }

        public final Builder setViewForPopups(View view) {
            this.zaoj = view;
            return this;
        }

        @KeepForSdk
        public final Builder setRealClientPackageName(String string2) {
            this.zaok = string2;
            return this;
        }

        public final Builder setRealClientClassName(String string2) {
            this.zaol = string2;
            return this;
        }

        public final Builder setSignInOptions(SignInOptions signInOptions) {
            this.zaom = signInOptions;
            return this;
        }

        public final Builder enableSignInClientDisconnectFix() {
            this.zaoq = true;
            return this;
        }

        @KeepForSdk
        public final ClientSettings build() {
            return new ClientSettings(this.account, (Set<Scope>)this.zaop, this.zaoh, this.zaoi, this.zaoj, this.zaok, this.zaol, this.zaom, this.zaoq);
        }
    }

    public static final class OptionalApiSettings {
        public final Set<Scope> mScopes;

        public OptionalApiSettings(Set<Scope> set) {
            Preconditions.checkNotNull(set);
            this.mScopes = Collections.unmodifiableSet(set);
        }
    }
}

