/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.DialogInterface;
import android.content.Intent;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.internal.zac;
import com.google.android.gms.common.internal.zad;
import com.google.android.gms.common.internal.zae;

public abstract class DialogRedirect
implements DialogInterface.OnClickListener {
    public static DialogRedirect getInstance(Activity activity, Intent intent, int n) {
        return new zad(intent, activity, n);
    }

    public static DialogRedirect getInstance(@NonNull Fragment fragment, Intent intent, int n) {
        return new zac(intent, fragment, n);
    }

    public static DialogRedirect getInstance(@NonNull LifecycleFragment lifecycleFragment, Intent intent, int n) {
        return new zae(intent, lifecycleFragment, n);
    }

    public void onClick(DialogInterface dialogInterface, int n) {
        try {
            this.redirect();
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.e((String)"DialogRedirect", (String)"Failed to start resolution intent", (Throwable)activityNotFoundException);
            return;
        }
        finally {
            dialogInterface.dismiss();
        }
    }

    protected abstract void redirect();
}

