/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.server.response.zab;
import com.google.android.gms.common.server.response.zac;
import com.google.android.gms.common.server.response.zad;
import com.google.android.gms.common.server.response.zae;
import com.google.android.gms.common.server.response.zaf;
import com.google.android.gms.common.server.response.zag;
import com.google.android.gms.common.server.response.zah;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

@ShowFirstParty
@KeepForSdk
public class FastParser<T extends FastJsonResponse> {
    private final char[] zaqp = new char[1];
    private final char[] zaqq = new char[32];
    private final char[] zaqr = new char[1024];
    private final StringBuilder zaqs = new StringBuilder(32);
    private final StringBuilder zaqt = new StringBuilder(1024);
    private static final char[] zaqu = new char[]{'u', 'l', 'l'};
    private static final char[] zaqv = new char[]{'r', 'u', 'e'};
    private static final char[] zaqw = new char[]{'r', 'u', 'e', '\"'};
    private static final char[] zaqx = new char[]{'a', 'l', 's', 'e'};
    private static final char[] zaqy = new char[]{'a', 'l', 's', 'e', '\"'};
    private static final char[] zaqz = new char[]{'\n'};
    private final Stack<Integer> zara = new Stack();
    private static final zaa<Integer> zarb = new zab();
    private static final zaa<Long> zarc = new com.google.android.gms.common.server.response.zaa();
    private static final zaa<Float> zard = new zad();
    private static final zaa<Double> zare = new zac();
    private static final zaa<Boolean> zarf = new zaf();
    private static final zaa<String> zarg = new zae();
    private static final zaa<BigInteger> zarh = new zah();
    private static final zaa<BigDecimal> zari = new zag();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public void parse(InputStream inputStream, T t) throws ParseException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 1024);
        try {
            this.zara.push(0);
            T t2 = t;
            BufferedReader bufferedReader2 = bufferedReader;
            FastParser fastParser = this;
            char c = fastParser.zaj(bufferedReader2);
            switch (c) {
                case '{': {
                    fastParser.zara.push(1);
                    fastParser.zaa(bufferedReader2, (FastJsonResponse)t2);
                    break;
                }
                case '[': {
                    fastParser.zara.push(5);
                    T t3 = t2;
                    BufferedReader bufferedReader3 = bufferedReader2;
                    FastParser fastParser2 = fastParser;
                    Map<String, FastJsonResponse.Field<?, ?>> map = ((FastJsonResponse)t3).getFieldMappings();
                    if (map.size() != 1) {
                        throw new ParseException("Object array response class must have a single Field");
                    }
                    FastJsonResponse.Field<?, ?> field = map.entrySet().iterator().next().getValue();
                    ArrayList<T> arrayList = fastParser2.zaa(bufferedReader3, field);
                    ((FastJsonResponse)t3).addConcreteTypeArrayInternal(field, field.zaqj, arrayList);
                    break;
                }
                case '\u0000': {
                    throw new ParseException("No data to parse");
                }
                default: {
                    throw new ParseException(new StringBuilder(19).append("Unexpected token: ").append(c).toString());
                }
            }
            this.zak(0);
        }
        catch (IOException iOException) {
            try {
                throw new ParseException(iOException);
            }
            catch (Throwable throwable) {
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    Log.w((String)"FastParser", (String)"Failed to close reader while parsing.");
                }
                throw throwable;
            }
        }
        try {
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            Log.w((String)"FastParser", (String)"Failed to close reader while parsing.");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zaa(BufferedReader bufferedReader, FastJsonResponse fastJsonResponse) throws ParseException, IOException {
        char c;
        Map<String, FastJsonResponse.Field<?, ?>> map = fastJsonResponse.getFieldMappings();
        String string2 = this.zaa(bufferedReader);
        if (string2 == null) {
            this.zak(1);
            return false;
        }
        block26: while (true) {
            if (string2 == null) {
                this.zak(1);
                return true;
            }
            FastJsonResponse.Field<?, ?> field = map.get(string2);
            if (field == null) {
                string2 = this.zab(bufferedReader);
                continue;
            }
            this.zara.push(4);
            switch (field.zaqf) {
                case 0: {
                    if (field.zaqg) {
                        fastJsonResponse.zaa(field, this.zaa(bufferedReader, zarb));
                        break;
                    }
                    fastJsonResponse.zaa(field, this.zad(bufferedReader));
                    break;
                }
                case 1: {
                    if (field.zaqg) {
                        fastJsonResponse.zab(field, this.zaa(bufferedReader, zarh));
                        break;
                    }
                    fastJsonResponse.zaa(field, this.zaf(bufferedReader));
                    break;
                }
                case 2: {
                    if (field.zaqg) {
                        fastJsonResponse.zac(field, this.zaa(bufferedReader, zarc));
                        break;
                    }
                    fastJsonResponse.zaa(field, this.zae(bufferedReader));
                    break;
                }
                case 3: {
                    if (field.zaqg) {
                        fastJsonResponse.zad(field, this.zaa(bufferedReader, zard));
                        break;
                    }
                    fastJsonResponse.zaa(field, this.zag(bufferedReader));
                    break;
                }
                case 4: {
                    if (field.zaqg) {
                        fastJsonResponse.zae(field, this.zaa(bufferedReader, zare));
                        break;
                    }
                    fastJsonResponse.zaa(field, this.zah(bufferedReader));
                    break;
                }
                case 5: {
                    if (field.zaqg) {
                        fastJsonResponse.zaf(field, this.zaa(bufferedReader, zari));
                        break;
                    }
                    fastJsonResponse.zaa(field, this.zai(bufferedReader));
                    break;
                }
                case 6: {
                    if (field.zaqg) {
                        fastJsonResponse.zag(field, this.zaa(bufferedReader, zarf));
                        break;
                    }
                    fastJsonResponse.zaa(field, this.zaa(bufferedReader, false));
                    break;
                }
                case 7: {
                    if (field.zaqg) {
                        fastJsonResponse.zah(field, this.zaa(bufferedReader, zarg));
                        break;
                    }
                    fastJsonResponse.zaa(field, this.zac(bufferedReader));
                    break;
                }
                case 8: {
                    fastJsonResponse.zaa(field, Base64Utils.decode((String)this.zaa(bufferedReader, this.zaqr, this.zaqt, zaqz)));
                    break;
                }
                case 9: {
                    fastJsonResponse.zaa(field, Base64Utils.decodeUrlSafe((String)this.zaa(bufferedReader, this.zaqr, this.zaqt, zaqz)));
                    break;
                }
                case 10: {
                    HashMap<String, String> hashMap;
                    BufferedReader bufferedReader2 = bufferedReader;
                    FastParser fastParser = this;
                    char c2 = fastParser.zaj(bufferedReader2);
                    if (c2 == 'n') {
                        fastParser.zab(bufferedReader2, zaqu);
                        hashMap = null;
                    } else {
                        if (c2 != '{') {
                            throw new ParseException("Expected start of a map object");
                        }
                        fastParser.zara.push(1);
                        HashMap<String, String> hashMap2 = new HashMap<String, String>();
                        block27: while (true) {
                            switch (fastParser.zaj(bufferedReader2)) {
                                case '\"': {
                                    String string3 = FastParser.zab(bufferedReader2, fastParser.zaqq, fastParser.zaqs, null);
                                    if (fastParser.zaj(bufferedReader2) != ':') {
                                        String string4;
                                        String string5 = String.valueOf(string3);
                                        if (string5.length() != 0) {
                                            string4 = "No map value found for key ".concat(string5);
                                            throw new ParseException(string4);
                                        }
                                        string4 = new String("No map value found for key ");
                                        throw new ParseException(string4);
                                    }
                                    if (fastParser.zaj(bufferedReader2) != '\"') {
                                        String string6;
                                        String string7 = String.valueOf(string3);
                                        if (string7.length() != 0) {
                                            string6 = "Expected String value for key ".concat(string7);
                                            throw new ParseException(string6);
                                        }
                                        string6 = new String("Expected String value for key ");
                                        throw new ParseException(string6);
                                    }
                                    String string8 = FastParser.zab(bufferedReader2, fastParser.zaqq, fastParser.zaqs, null);
                                    hashMap2.put(string3, string8);
                                    c2 = fastParser.zaj(bufferedReader2);
                                    if (c2 == ',') break;
                                    if (c2 != '}') {
                                        char c3 = c2;
                                        throw new ParseException(new StringBuilder(48).append("Unexpected character while parsing string map: ").append(c3).toString());
                                    }
                                    fastParser.zak(1);
                                    hashMap = hashMap2;
                                    break block27;
                                }
                                case '}': {
                                    fastParser.zak(1);
                                    hashMap = hashMap2;
                                    break block27;
                                }
                                case '\u0000': {
                                    throw new ParseException("Unexpected EOF");
                                }
                            }
                        }
                    }
                    fastJsonResponse.zaa(field, (Map<String, String>)hashMap);
                    break;
                }
                case 11: {
                    if (field.zaqg) {
                        c = this.zaj(bufferedReader);
                        if (c == 'n') {
                            this.zab(bufferedReader, zaqu);
                            fastJsonResponse.addConcreteTypeArrayInternal(field, field.zaqj, null);
                            break;
                        }
                        this.zara.push(5);
                        if (c != '[') {
                            throw new ParseException("Expected array start");
                        }
                        fastJsonResponse.addConcreteTypeArrayInternal(field, field.zaqj, this.zaa(bufferedReader, field));
                        break;
                    }
                    c = this.zaj(bufferedReader);
                    if (c == 'n') {
                        this.zab(bufferedReader, zaqu);
                        fastJsonResponse.addConcreteTypeInternal(field, field.zaqj, null);
                        break;
                    }
                    this.zara.push(1);
                    if (c != '{') {
                        throw new ParseException("Expected start of object");
                    }
                    try {
                        FastJsonResponse fastJsonResponse2 = field.zacn();
                        this.zaa(bufferedReader, fastJsonResponse2);
                        fastJsonResponse.addConcreteTypeInternal(field, field.zaqj, fastJsonResponse2);
                        break;
                    }
                    catch (InstantiationException instantiationException) {
                        throw new ParseException("Error instantiating inner object", instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new ParseException("Error instantiating inner object", illegalAccessException);
                    }
                }
                default: {
                    int n = field.zaqf;
                    throw new ParseException(new StringBuilder(30).append("Invalid field type ").append(n).toString());
                }
            }
            this.zak(4);
            this.zak(2);
            c = this.zaj(bufferedReader);
            switch (c) {
                case '}': {
                    string2 = null;
                    continue block26;
                }
                case ',': {
                    string2 = this.zaa(bufferedReader);
                    continue block26;
                }
            }
            break;
        }
        throw new ParseException(new StringBuilder(55).append("Expected end of object or field separator, but found: ").append(c).toString());
    }

    private final String zaa(BufferedReader bufferedReader) throws ParseException, IOException {
        this.zara.push(2);
        char c = this.zaj(bufferedReader);
        switch (c) {
            case '}': {
                this.zak(2);
                return null;
            }
            case ']': {
                this.zak(2);
                this.zak(1);
                this.zak(5);
                return null;
            }
            case '\"': {
                this.zara.push(3);
                String string2 = FastParser.zab(bufferedReader, this.zaqq, this.zaqs, null);
                this.zak(3);
                if (this.zaj(bufferedReader) != ':') {
                    throw new ParseException("Expected key/value separator");
                }
                return string2;
            }
        }
        throw new ParseException(new StringBuilder(19).append("Unexpected token: ").append(c).toString());
    }

    private final String zab(BufferedReader bufferedReader) throws ParseException, IOException {
        char c;
        char c2;
        bufferedReader.mark(1024);
        switch (this.zaj(bufferedReader)) {
            case '\"': {
                c2 = '\u0000';
                if (bufferedReader.read(this.zaqp) == -1) {
                    throw new ParseException("Unexpected EOF while parsing string");
                }
                char c3 = this.zaqp[0];
                while (c3 != '\"' || c2 != '\u0000') {
                    c2 = c3 == '\\' ? (c2 == '\u0000' ? (char)'\u0001' : '\u0000') : (char)'\u0000';
                    if (bufferedReader.read(this.zaqp) == -1) {
                        throw new ParseException("Unexpected EOF while parsing string");
                    }
                    c3 = this.zaqp[0];
                    if (!Character.isISOControl(c3)) continue;
                    throw new ParseException("Unexpected control character while reading string");
                }
                break;
            }
            case '{': {
                this.zara.push(1);
                bufferedReader.mark(32);
                c = this.zaj(bufferedReader);
                if (c == '}') {
                    this.zak(1);
                    break;
                }
                if (c == '\"') {
                    bufferedReader.reset();
                    this.zaa(bufferedReader);
                    while (this.zab(bufferedReader) != null) {
                    }
                    this.zak(1);
                    break;
                }
                char c4 = c;
                throw new ParseException(new StringBuilder(18).append("Unexpected token ").append(c4).toString());
            }
            case '[': {
                this.zara.push(5);
                bufferedReader.mark(32);
                if (this.zaj(bufferedReader) == ']') {
                    this.zak(5);
                    break;
                }
                bufferedReader.reset();
                c2 = '\u0000';
                boolean bl = false;
                int n = 1;
                while (n > 0) {
                    char c5 = this.zaj(bufferedReader);
                    if (c5 == '\u0000') {
                        throw new ParseException("Unexpected EOF while parsing array");
                    }
                    if (Character.isISOControl(c5)) {
                        throw new ParseException("Unexpected control character while reading array");
                    }
                    if (c5 == '\"' && c2 == '\u0000') {
                        boolean bl2 = bl = !bl;
                    }
                    if (c5 == '[' && !bl) {
                        ++n;
                    }
                    if (c5 == ']' && !bl) {
                        --n;
                    }
                    if (c5 == '\\' && bl) {
                        c2 = c2 == '\u0000' ? (char)'\u0001' : '\u0000';
                        continue;
                    }
                    c2 = '\u0000';
                }
                this.zak(5);
                break;
            }
            case ',': {
                throw new ParseException("Missing value");
            }
            default: {
                bufferedReader.reset();
                this.zaa(bufferedReader, this.zaqr);
            }
        }
        c = this.zaj(bufferedReader);
        switch (c) {
            case ',': {
                this.zak(2);
                return this.zaa(bufferedReader);
            }
            case '}': {
                this.zak(2);
                return null;
            }
        }
        c2 = c;
        throw new ParseException(new StringBuilder(18).append("Unexpected token ").append(c2).toString());
    }

    private final String zac(BufferedReader bufferedReader) throws ParseException, IOException {
        return this.zaa(bufferedReader, this.zaqq, this.zaqs, null);
    }

    private final <O> ArrayList<O> zaa(BufferedReader bufferedReader, zaa<O> zaa2) throws ParseException, IOException {
        char c = this.zaj(bufferedReader);
        if (c == 'n') {
            this.zab(bufferedReader, zaqu);
            return null;
        }
        if (c != '[') {
            throw new ParseException("Expected start of array");
        }
        this.zara.push(5);
        ArrayList<O> arrayList = new ArrayList<O>();
        block5: while (true) {
            bufferedReader.mark(1024);
            switch (this.zaj(bufferedReader)) {
                case ',': {
                    continue block5;
                }
                case ']': {
                    this.zak(5);
                    return arrayList;
                }
                case '\u0000': {
                    throw new ParseException("Unexpected EOF");
                }
            }
            bufferedReader.reset();
            arrayList.add(zaa2.zah(this, bufferedReader));
        }
    }

    private final String zaa(BufferedReader bufferedReader, char[] cArray, StringBuilder stringBuilder, char[] cArray2) throws ParseException, IOException {
        switch (this.zaj(bufferedReader)) {
            case '\"': {
                return FastParser.zab(bufferedReader, cArray, stringBuilder, cArray2);
            }
            case 'n': {
                this.zab(bufferedReader, zaqu);
                return null;
            }
        }
        throw new ParseException("Expected string");
    }

    private static String zab(BufferedReader bufferedReader, char[] cArray, StringBuilder stringBuilder, char[] cArray2) throws ParseException, IOException {
        int n;
        stringBuilder.setLength(0);
        boolean bl = false;
        boolean bl2 = false;
        bufferedReader.mark(cArray.length);
        while ((n = bufferedReader.read(cArray)) != -1) {
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                if (Character.isISOControl(c)) {
                    boolean bl3;
                    char c2 = c;
                    char[] cArray3 = cArray2;
                    if (cArray2 != null) {
                        for (int j = 0; j < cArray3.length; ++j) {
                            if (cArray3[j] != c2) continue;
                            bl3 = true;
                            break;
                        }
                    } else {
                        bl3 = false;
                    }
                    if (!bl3) {
                        throw new ParseException("Unexpected control character while reading string");
                    }
                }
                if (c == '\"' && !bl) {
                    stringBuilder.append(cArray, 0, i);
                    bufferedReader.reset();
                    bufferedReader.skip(i + 1);
                    if (bl2) {
                        return JsonUtils.unescapeString((String)stringBuilder.toString());
                    }
                    return stringBuilder.toString();
                }
                if (c == '\\') {
                    bl = !bl;
                    bl2 = true;
                    continue;
                }
                bl = false;
            }
            stringBuilder.append(cArray, 0, n);
            bufferedReader.mark(cArray.length);
        }
        throw new ParseException("Unexpected EOF while parsing string");
    }

    private final int zad(BufferedReader bufferedReader) throws ParseException, IOException {
        int n = this.zaa(bufferedReader, this.zaqr);
        if (n == 0) {
            return 0;
        }
        int n2 = n;
        char[] cArray = this.zaqr;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        if (n2 > 0) {
            int n5;
            int n6;
            if (cArray[0] == '-') {
                bl = true;
                n6 = Integer.MIN_VALUE;
                ++n4;
            } else {
                n6 = -2147483647;
            }
            if (n4 < n2) {
                if ((n5 = Character.digit(cArray[n4++], 10)) < 0) {
                    throw new ParseException("Unexpected non-digit character");
                }
                n3 = -n5;
            }
            while (n4 < n2) {
                if ((n5 = Character.digit(cArray[n4++], 10)) < 0) {
                    throw new ParseException("Unexpected non-digit character");
                }
                if (n3 < -214748364) {
                    throw new ParseException("Number too large");
                }
                if ((n3 *= 10) < n6 + n5) {
                    throw new ParseException("Number too large");
                }
                n3 -= n5;
            }
        } else {
            throw new ParseException("No number to parse");
        }
        if (bl) {
            if (n4 > 1) {
                return n3;
            }
            throw new ParseException("No digits to parse");
        }
        return -n3;
    }

    private final long zae(BufferedReader bufferedReader) throws ParseException, IOException {
        int n = this.zaa(bufferedReader, this.zaqr);
        if (n == 0) {
            return 0L;
        }
        int n2 = n;
        char[] cArray = this.zaqr;
        long l = 0L;
        boolean bl = false;
        int n3 = 0;
        if (n2 > 0) {
            int n4;
            long l2;
            if (cArray[0] == '-') {
                bl = true;
                l2 = Long.MIN_VALUE;
                ++n3;
            } else {
                l2 = -9223372036854775807L;
            }
            if (n3 < n2) {
                if ((n4 = Character.digit(cArray[n3++], 10)) < 0) {
                    throw new ParseException("Unexpected non-digit character");
                }
                l = -n4;
            }
            while (n3 < n2) {
                if ((n4 = Character.digit(cArray[n3++], 10)) < 0) {
                    throw new ParseException("Unexpected non-digit character");
                }
                if (l < -922337203685477580L) {
                    throw new ParseException("Number too large");
                }
                if ((l *= 10L) < l2 + (long)n4) {
                    throw new ParseException("Number too large");
                }
                l -= (long)n4;
            }
        } else {
            throw new ParseException("No number to parse");
        }
        if (bl) {
            if (n3 > 1) {
                return l;
            }
            throw new ParseException("No digits to parse");
        }
        return -l;
    }

    private final BigInteger zaf(BufferedReader bufferedReader) throws ParseException, IOException {
        int n = this.zaa(bufferedReader, this.zaqr);
        if (n == 0) {
            return null;
        }
        return new BigInteger(new String(this.zaqr, 0, n));
    }

    private final boolean zaa(BufferedReader bufferedReader, boolean bl) throws ParseException, IOException {
        char c;
        block6: while (true) {
            c = this.zaj(bufferedReader);
            switch (c) {
                case 'n': {
                    this.zab(bufferedReader, zaqu);
                    return false;
                }
                case 't': {
                    this.zab(bufferedReader, bl ? zaqw : zaqv);
                    return true;
                }
                case 'f': {
                    this.zab(bufferedReader, bl ? zaqy : zaqx);
                    return false;
                }
                case '\"': {
                    if (bl) {
                        throw new ParseException("No boolean value found in string");
                    }
                    bl = true;
                    continue block6;
                }
            }
            break;
        }
        throw new ParseException(new StringBuilder(19).append("Unexpected token: ").append(c).toString());
    }

    private final float zag(BufferedReader bufferedReader) throws ParseException, IOException {
        int n = this.zaa(bufferedReader, this.zaqr);
        if (n == 0) {
            return 0.0f;
        }
        return Float.parseFloat(new String(this.zaqr, 0, n));
    }

    private final double zah(BufferedReader bufferedReader) throws ParseException, IOException {
        int n = this.zaa(bufferedReader, this.zaqr);
        if (n == 0) {
            return 0.0;
        }
        return Double.parseDouble(new String(this.zaqr, 0, n));
    }

    private final BigDecimal zai(BufferedReader bufferedReader) throws ParseException, IOException {
        int n = this.zaa(bufferedReader, this.zaqr);
        if (n == 0) {
            return null;
        }
        return new BigDecimal(new String(this.zaqr, 0, n));
    }

    private final <T extends FastJsonResponse> ArrayList<T> zaa(BufferedReader bufferedReader, FastJsonResponse.Field<?, ?> field) throws ParseException, IOException {
        ArrayList<FastJsonResponse> arrayList;
        block14: {
            arrayList = new ArrayList<FastJsonResponse>();
            char c = this.zaj(bufferedReader);
            switch (c) {
                case ']': {
                    this.zak(5);
                    return arrayList;
                }
                case '{': {
                    this.zara.push(1);
                    break;
                }
                case 'n': {
                    this.zab(bufferedReader, zaqu);
                    this.zak(5);
                    return null;
                }
                default: {
                    char c2 = c;
                    throw new ParseException(new StringBuilder(19).append("Unexpected token: ").append(c2).toString());
                }
            }
            block12: while (true) {
                try {
                    FastJsonResponse fastJsonResponse = field.zacn();
                    if (!this.zaa(bufferedReader, fastJsonResponse)) break block14;
                    arrayList.add(fastJsonResponse);
                }
                catch (InstantiationException instantiationException) {
                    throw new ParseException("Error instantiating inner object", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ParseException("Error instantiating inner object", illegalAccessException);
                }
                c = this.zaj(bufferedReader);
                switch (c) {
                    case ',': {
                        if (this.zaj(bufferedReader) != '{') {
                            throw new ParseException("Expected start of next object in array");
                        }
                        this.zara.push(1);
                        continue block12;
                    }
                    case ']': {
                        this.zak(5);
                        return arrayList;
                    }
                }
                break;
            }
            char c3 = c;
            throw new ParseException(new StringBuilder(19).append("Unexpected token: ").append(c3).toString());
        }
        return arrayList;
    }

    private final char zaj(BufferedReader bufferedReader) throws ParseException, IOException {
        if (bufferedReader.read(this.zaqp) == -1) {
            return '\u0000';
        }
        while (Character.isWhitespace(this.zaqp[0])) {
            if (bufferedReader.read(this.zaqp) != -1) continue;
            return '\u0000';
        }
        return this.zaqp[0];
    }

    private final int zaa(BufferedReader bufferedReader, char[] cArray) throws ParseException, IOException {
        int n;
        char c = this.zaj(bufferedReader);
        if (c == '\u0000') {
            throw new ParseException("Unexpected EOF");
        }
        if (c == ',') {
            throw new ParseException("Missing value");
        }
        if (c == 'n') {
            this.zab(bufferedReader, zaqu);
            return 0;
        }
        bufferedReader.mark(1024);
        if (c == '\"') {
            boolean bl = false;
            for (n = 0; n < cArray.length && bufferedReader.read(cArray, n, 1) != -1; ++n) {
                char c2 = cArray[n];
                if (Character.isISOControl(c2)) {
                    throw new ParseException("Unexpected control character while reading string");
                }
                if (c2 == '\"' && !bl) {
                    bufferedReader.reset();
                    bufferedReader.skip(n + 1);
                    return n;
                }
                bl = c2 == '\\' ? !bl : false;
            }
        } else {
            cArray[0] = c;
            for (n = 1; n < cArray.length && bufferedReader.read(cArray, n, 1) != -1; ++n) {
                if (cArray[n] != '}' && cArray[n] != ',' && !Character.isWhitespace(cArray[n]) && cArray[n] != ']') continue;
                bufferedReader.reset();
                bufferedReader.skip(n - 1);
                cArray[n] = '\u0000';
                return n;
            }
        }
        if (n == cArray.length) {
            throw new ParseException("Absurdly long value");
        }
        throw new ParseException("Unexpected EOF");
    }

    private final void zab(BufferedReader bufferedReader, char[] cArray) throws ParseException, IOException {
        int n;
        for (int i = 0; i < cArray.length; i += n) {
            n = bufferedReader.read(this.zaqq, 0, cArray.length - i);
            if (n == -1) {
                throw new ParseException("Unexpected EOF");
            }
            for (int j = 0; j < n; ++j) {
                if (cArray[j + i] == this.zaqq[j]) continue;
                throw new ParseException("Unexpected character");
            }
        }
    }

    private final void zak(int n) throws ParseException {
        if (this.zara.isEmpty()) {
            throw new ParseException(new StringBuilder(46).append("Expected state ").append(n).append(" but had empty stack").toString());
        }
        int n2 = this.zara.pop();
        if (n2 != n) {
            throw new ParseException(new StringBuilder(46).append("Expected state ").append(n).append(" but had ").append(n2).toString());
        }
    }

    static /* synthetic */ int zaa(FastParser fastParser, BufferedReader bufferedReader) throws ParseException, IOException {
        return fastParser.zad(bufferedReader);
    }

    static /* synthetic */ long zab(FastParser fastParser, BufferedReader bufferedReader) throws ParseException, IOException {
        return fastParser.zae(bufferedReader);
    }

    static /* synthetic */ float zac(FastParser fastParser, BufferedReader bufferedReader) throws ParseException, IOException {
        return fastParser.zag(bufferedReader);
    }

    static /* synthetic */ double zad(FastParser fastParser, BufferedReader bufferedReader) throws ParseException, IOException {
        return fastParser.zah(bufferedReader);
    }

    static /* synthetic */ boolean zaa(FastParser fastParser, BufferedReader bufferedReader, boolean bl) throws ParseException, IOException {
        return fastParser.zaa(bufferedReader, false);
    }

    static /* synthetic */ String zae(FastParser fastParser, BufferedReader bufferedReader) throws ParseException, IOException {
        return fastParser.zac(bufferedReader);
    }

    static /* synthetic */ BigInteger zaf(FastParser fastParser, BufferedReader bufferedReader) throws ParseException, IOException {
        return fastParser.zaf(bufferedReader);
    }

    static /* synthetic */ BigDecimal zag(FastParser fastParser, BufferedReader bufferedReader) throws ParseException, IOException {
        return fastParser.zai(bufferedReader);
    }

    private static interface zaa<O> {
        public O zah(FastParser var1, BufferedReader var2) throws ParseException, IOException;
    }

    @ShowFirstParty
    @KeepForSdk
    public static class ParseException
    extends Exception {
        public ParseException(String string2) {
            super(string2);
        }

        public ParseException(String string2, Throwable throwable) {
            super(string2, throwable);
        }

        public ParseException(Throwable throwable) {
            super(throwable);
        }
    }
}

