/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cloudmessaging;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.cloudmessaging.CloudMessage;
import com.google.android.gms.cloudmessaging.zzd;
import com.google.android.gms.cloudmessaging.zze;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.internal.cloudmessaging.zza;
import com.google.android.gms.internal.cloudmessaging.zzf;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class CloudMessagingReceiver
extends BroadcastReceiver {
    private final ExecutorService zza = com.google.android.gms.internal.cloudmessaging.zza.zza().zza((ThreadFactory)new NamedThreadFactory("firebase-iid-executor"), zzf.zza);

    @NonNull
    protected Executor getBroadcastExecutor() {
        return this.zza;
    }

    @WorkerThread
    protected abstract int onMessageReceive(@NonNull Context var1, @NonNull CloudMessage var2);

    @WorkerThread
    protected void onNotificationOpen(@NonNull Context context, @NonNull Bundle bundle) {
    }

    @WorkerThread
    protected void onNotificationDismissed(@NonNull Context context, @NonNull Bundle bundle) {
    }

    public final void onReceive(@NonNull Context context, @NonNull Intent intent) {
        if (intent == null) {
            return;
        }
        boolean bl = this.isOrderedBroadcast();
        BroadcastReceiver.PendingResult pendingResult = this.goAsync();
        this.getBroadcastExecutor().execute(new zzd(this, intent, context, bl, pendingResult));
    }

    @WorkerThread
    private final int zza(@NonNull Context context, @NonNull Intent intent) {
        Bundle bundle;
        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra("pending_intent");
        if (pendingIntent != null) {
            try {
                pendingIntent.send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.e((String)"CloudMessagingReceiver", (String)"Notification pending intent canceled");
            }
        }
        if ((bundle = intent.getExtras()) != null) {
            bundle.remove("pending_intent");
        } else {
            bundle = new Bundle();
        }
        if ("com.google.firebase.messaging.NOTIFICATION_OPEN".equals(intent.getAction())) {
            this.onNotificationOpen(context, bundle);
        } else if ("com.google.firebase.messaging.NOTIFICATION_DISMISS".equals(intent.getAction())) {
            this.onNotificationDismissed(context, bundle);
        } else {
            Log.e((String)"CloudMessagingReceiver", (String)"Unknown notification action");
            return 500;
        }
        return -1;
    }

    @WorkerThread
    private final int zzb(@NonNull Context context, @NonNull Intent intent) {
        Task<Void> task;
        String string;
        if (intent.getExtras() == null) {
            return 500;
        }
        String string2 = string = intent.getStringExtra("google.message_id");
        Context context2 = context;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            task = Tasks.forResult(null);
        } else {
            Bundle bundle = new Bundle();
            bundle.putString("google.message_id", string2);
            task = zze.zza(context2).zza(2, bundle);
        }
        Task<Void> task2 = task;
        int n = this.onMessageReceive(context, new CloudMessage(intent));
        try {
            Tasks.await(task2, (long)TimeUnit.SECONDS.toMillis(1L), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            String string3 = String.valueOf(exception);
            Log.w((String)"CloudMessagingReceiver", (String)new StringBuilder(20 + String.valueOf(string3).length()).append("Message ack failed: ").append(string3).toString());
        }
        return n;
    }

    final /* synthetic */ void zza(Intent intent, Context context, boolean bl, BroadcastReceiver.PendingResult pendingResult) {
        try {
            Parcelable parcelable = intent.getParcelableExtra("wrapped_intent");
            Intent intent2 = parcelable instanceof Intent ? (Intent)parcelable : null;
            int n = intent2 != null ? this.zza(context, intent2) : this.zzb(context, intent);
            if (bl) {
                pendingResult.setResultCode(n);
            }
            return;
        }
        finally {
            pendingResult.finish();
        }
    }

    public static final class IntentKeys {
        @NonNull
        public static final String PENDING_INTENT = "pending_intent";
        @NonNull
        public static final String WRAPPED_INTENT = "wrapped_intent";

        private IntentKeys() {
        }
    }

    public static final class IntentActionKeys {
        @NonNull
        public static final String NOTIFICATION_OPEN = "com.google.firebase.messaging.NOTIFICATION_OPEN";
        @NonNull
        public static final String NOTIFICATION_DISMISS = "com.google.firebase.messaging.NOTIFICATION_DISMISS";

        private IntentActionKeys() {
        }
    }
}

