/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzlj;
import com.google.android.gms.internal.measurement.zzni;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzkv;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzae
extends zzgp {
    private Boolean zza;
    private zzad zzb = zzac.zza;
    private Boolean zzc;

    zzae(zzfw zzfw2) {
        super(zzfw2);
    }

    final void zza(zzad zzad2) {
        this.zzb = zzad2;
    }

    final String zzb() {
        this.zzx.zzas();
        return "FA";
    }

    public final int zzc() {
        zzlj.zzb();
        if (zzgp2.zzx.zzc().zzn(null, zzeh.zzaw)) {
            zzgp zzgp2 = zzgp2.zzx.zzl();
            Boolean bl = ((zzkv)zzgp2).zzx.zzy().zzC();
            if (((zzkv)zzgp2).zzZ() >= 201500 || bl != null && !bl.booleanValue()) {
                return 100;
            }
            return 25;
        }
        return 25;
    }

    public final int zzd(@Size(min=1L) String string) {
        return this.zzl(string, zzeh.zzH, 25, 100);
    }

    final int zze(@Size(min=1L) String string) {
        zzlj.zzb();
        if (this.zzn(null, zzeh.zzav)) {
            return this.zzl(string, zzeh.zzG, 500, 2000);
        }
        return 500;
    }

    public final long zzf() {
        this.zzx.zzas();
        return 37000L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EnsuresNonNull(value={"this.isMainProcess"})
    public final boolean zzh() {
        if (this.zzc != null) return this.zzc;
        synchronized (this) {
            Object object;
            Object object2 = this.zzc;
            if (object2 != null) return this.zzc;
            object2 = this.zzx.zzaw();
            object2 = object2.getApplicationInfo();
            String string = ProcessUtils.getMyProcessName();
            if (object2 != null) {
                boolean bl;
                object2 = ((ApplicationInfo)object2).processName;
                bl = object2 != null ? (bl = ((String)object2).equals(string)) : false;
                this.zzc = bl;
            }
            if ((object = this.zzc) != null) return this.zzc;
            this.zzc = Boolean.TRUE;
            object = this.zzx.zzat();
            ((zzet)object).zzb().zza("My process not in the list of running processes");
            return this.zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final String zzi(String string, zzeg<String> zzeg2) {
        if (string == null) {
            return zzeg2.zzb(null);
        }
        return zzeg2.zzb(this.zzb.zza(string, zzeg2.zza()));
    }

    @WorkerThread
    public final long zzj(String string, zzeg<Long> zzeg2) {
        if (string == null) {
            return zzeg2.zzb(null);
        }
        String string2 = ((zzae)((Object)string2)).zzb.zza(string, zzeg2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeg2.zzb(null);
        }
        try {
            long l = zzeg2.zzb(Long.parseLong(string2));
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return zzeg2.zzb(null);
        }
    }

    @WorkerThread
    public final int zzk(String string, zzeg<Integer> zzeg2) {
        if (string == null) {
            return zzeg2.zzb(null);
        }
        String string2 = ((zzae)((Object)string2)).zzb.zza(string, zzeg2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeg2.zzb(null);
        }
        try {
            int n = zzeg2.zzb(Integer.parseInt(string2));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return zzeg2.zzb(null);
        }
    }

    @WorkerThread
    public final int zzl(String string, zzeg<Integer> zzeg2, int n, int n2) {
        return Math.max(Math.min(this.zzk(string, zzeg2), n2), n);
    }

    @WorkerThread
    public final double zzm(String string, zzeg<Double> zzeg2) {
        if (string == null) {
            return zzeg2.zzb(null);
        }
        String string2 = ((zzae)((Object)string2)).zzb.zza(string, zzeg2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeg2.zzb(null);
        }
        try {
            double d = zzeg2.zzb(Double.parseDouble(string2));
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return zzeg2.zzb(null);
        }
    }

    @WorkerThread
    public final boolean zzn(String string, zzeg<Boolean> zzeg2) {
        if (string == null) {
            return zzeg2.zzb(null);
        }
        String string2 = ((zzae)((Object)string2)).zzb.zza(string, zzeg2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeg2.zzb(null);
        }
        return zzeg2.zzb(Boolean.parseBoolean(string2));
    }

    @VisibleForTesting
    final Bundle zzo() {
        Object object;
        block7: {
            block6: {
                try {
                    object = this.zzx.zzaw();
                    object = object.getPackageManager();
                    if (object != null) break block6;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    this.zzx.zzat().zzb().zzb("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
                    return null;
                }
                object = this.zzx.zzat();
                ((zzet)object).zzb().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            object = this.zzx.zzaw();
            object = Wrappers.packageManager((Context)object);
            Context context = this.zzx.zzaw();
            object = object.getApplicationInfo(context.getPackageName(), 128);
            if (object != null) break block7;
            object = this.zzx.zzat();
            ((zzet)object).zzb().zza("Failed to load metadata: ApplicationInfo is null");
            return null;
        }
        object = ((ApplicationInfo)object).metaData;
        return object;
    }

    @VisibleForTesting
    final Boolean zzp(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzo();
        if (bundle == null) {
            this.zzx.zzat().zzb().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    final List<String> zzq(@Size(min=1L) String object) {
        void var1_4;
        String string = "analytics.safelisted_events";
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzo();
        if (bundle == null) {
            this.zzx.zzat().zzb().zza("Failed to load metadata: Metadata bundle is null");
            Object var1_3 = null;
        } else if (!bundle.containsKey(string)) {
            Object var1_7 = null;
        } else {
            Integer n = bundle.getInt(string);
        }
        if (var1_4 == null) {
            return null;
        }
        try {
            bundle = this.zzx.zzaw();
            String[] stringArray = bundle.getResources().getStringArray(var1_4.intValue());
            if (stringArray != null) return Arrays.asList(stringArray);
            return null;
        }
        catch (Resources.NotFoundException notFoundException) {
            this.zzx.zzat().zzb().zzb("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    public final boolean zzr() {
        ((zzgp)((Object)bl)).zzx.zzas();
        Boolean bl = ((zzae)((Object)bl)).zzp("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final boolean zzs() {
        return (this = ((zzae)this).zzp("google_analytics_adid_collection_enabled")) == null || ((Boolean)this).booleanValue();
    }

    public final boolean zzt() {
        zzni.zzb();
        if (!((zzae)this).zzn(null, zzeh.zzas)) {
            return true;
        }
        return (this = ((zzae)this).zzp("google_analytics_automatic_screen_reporting_enabled")) == null || ((Boolean)this).booleanValue();
    }

    public final String zzu() {
        return this.zzB("debug.firebase.analytics.app", "");
    }

    public final String zzv() {
        return this.zzB("debug.deferred.deeplink", "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String zzB(String string, String string2) {
        string2 = "";
        try {
            GenericDeclaration genericDeclaration = Class.forName("android.os.SystemProperties");
            Object[] objectArray = new Class[]{String.class, String.class};
            genericDeclaration = ((Class)genericDeclaration).getMethod("get", (Class<?>[])objectArray);
            objectArray = new Object[]{string, string2};
            string = (String)((Method)genericDeclaration).invoke(null, objectArray);
            Preconditions.checkNotNull((Object)string);
            return string;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzx.zzat().zzb().zzb("Could not find SystemProperties class", classNotFoundException);
            return string2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.zzx.zzat().zzb().zzb("Could not find SystemProperties.get() method", noSuchMethodException);
            return string2;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.zzx.zzat().zzb().zzb("Could not access SystemProperties.get()", illegalAccessException);
            return string2;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.zzx.zzat().zzb().zzb("SystemProperties.get() threw an exception", invocationTargetException);
            return string2;
        }
    }

    public final boolean zzw(String string) {
        return "1".equals(this.zzb.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zzx(String string) {
        return "1".equals(this.zzb.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzy() {
        if (this.zza == null) {
            this.zza = this.zzp("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzx.zzu();
    }

    public static final long zzz() {
        return zzeh.zzc.zzb(null);
    }

    public static final long zzA() {
        return zzeh.zzC.zzb(null);
    }
}

