/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzff;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgq;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzfi
extends zzgq {
    @VisibleForTesting
    static final Pair<String, Long> zza;
    private SharedPreferences zzy;
    public zzfg zzb;
    public final zzff zzc;
    public final zzff zzd;
    public final zzff zze;
    public final zzff zzf;
    public final zzff zzg;
    public final zzff zzh;
    public final zzff zzi;
    public final zzfh zzj;
    private String zzz;
    private boolean zzA;
    private long zzB;
    public final zzff zzk;
    public final zzfd zzl;
    public final zzfh zzm;
    public final zzfd zzn;
    public final zzff zzo;
    public boolean zzp;
    public final zzfd zzq;
    public final zzfd zzr;
    public final zzff zzs;
    public final zzfh zzt;
    public final zzfh zzu;
    public final zzff zzv;
    public final zzfe zzw;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair<String, Boolean> zzb(String string) {
        this.zzg();
        long l = this.zzx.zzax().elapsedRealtime();
        String string2 = this.zzz;
        if (string2 != null && l < this.zzB) {
            return new Pair((Object)string2, (Object)this.zzA);
        }
        this.zzB = l + this.zzx.zzc().zzj(string, zzeh.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = this.zzx.zzaw();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            if (string != null) {
                this.zzz = string.getId();
                this.zzA = string.isLimitAdTrackingEnabled();
            }
            if ((string = this.zzz) == null) {
                this.zzz = "";
            }
        }
        catch (Exception exception) {
            this.zzx.zzat().zzj().zzb("Unable to get advertising id", exception);
            this.zzz = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzz, (Object)this.zzA);
    }

    zzfi(zzfw object) {
        super((zzfw)object);
        this.zzc = object = new zzff(this, "last_upload", 0L);
        this.zzd = object = new zzff(this, "last_upload_attempt", 0L);
        this.zze = object = new zzff(this, "backoff", 0L);
        this.zzf = object = new zzff(this, "last_delete_stale", 0L);
        this.zzk = object = new zzff(this, "session_timeout", 1800000L);
        this.zzl = object = new zzfd(this, "start_new_session", true);
        this.zzo = object = new zzff(this, "last_pause_time", 0L);
        this.zzm = object = new zzfh(this, "non_personalized_ads", null);
        this.zzn = object = new zzfd(this, "allow_remote_dynamite", false);
        this.zzg = object = new zzff(this, "midnight_offset", 0L);
        this.zzh = object = new zzff(this, "first_open_time", 0L);
        this.zzi = object = new zzff(this, "app_install_time", 0L);
        this.zzj = object = new zzfh(this, "app_instance_id", null);
        this.zzq = object = new zzfd(this, "app_backgrounded", false);
        this.zzr = object = new zzfd(this, "deep_link_retrieval_complete", false);
        this.zzs = object = new zzff(this, "deep_link_retrieval_attempts", 0L);
        this.zzt = object = new zzfh(this, "firebase_feature_rollouts", null);
        this.zzu = object = new zzfh(this, "deferred_attribution_cache", null);
        this.zzv = object = new zzff(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzw = object = new zzfe(this, "default_event_parameters", null);
    }

    @Override
    protected final boolean zza() {
        return true;
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzay() {
        zzfg zzfg2;
        boolean bl;
        this.zzy = this.zzx.zzaw().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzp = bl = this.zzy.getBoolean("has_been_opened", false);
        if (!bl) {
            SharedPreferences.Editor editor = this.zzy.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzx.zzc();
        this.zzb = zzfg2 = new zzfg(this, "health_monitor", Math.max(0L, (Long)zzeh.zzb.zzb(null)), null);
    }

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zzd() {
        this.zzg();
        this.zzv();
        Preconditions.checkNotNull((Object)this.zzy);
        return this.zzy;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zze(Boolean bl) {
        zzfi2.zzg();
        zzfi zzfi2 = zzfi2.zzd().edit();
        if (bl != null) {
            zzfi2.putBoolean("measurement_enabled", bl);
        } else {
            zzfi2.remove("measurement_enabled");
        }
        zzfi2.apply();
    }

    @WorkerThread
    final Boolean zzf() {
        this.zzg();
        if (this.zzd().contains("measurement_enabled")) {
            return this.zzd().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    final boolean zzh(int n) {
        return zzaf.zzm(n, this.zzd().getInt("consent_source", 100));
    }

    @WorkerThread
    final zzaf zzi() {
        this.zzg();
        return zzaf.zzc(this.zzd().getString("consent_settings", "G1"));
    }

    @WorkerThread
    final void zzj(boolean bl) {
        zzfi2.zzg();
        zzfi2.zzx.zzat().zzk().zzb("App measurement setting deferred collection", bl);
        zzfi zzfi2 = zzfi2.zzd().edit();
        zzfi2.putBoolean("deferred_analytics_collection", bl);
        zzfi2.apply();
    }

    @WorkerThread
    final boolean zzk() {
        zzfi zzfi2 = zzfi2.zzy;
        if (zzfi2 == null) {
            return false;
        }
        return zzfi2.contains("deferred_analytics_collection");
    }

    final boolean zzl(long l) {
        return l - this.zzk.zza() > this.zzo.zza();
    }

    static {
        Pair pair;
        zza = pair = new Pair((Object)"", (Object)0L);
    }
}

