/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzlm;
import com.google.android.gms.internal.measurement.zzmz;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzko;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public final class zzgo
extends zzej {
    private final zzko zza;
    private Boolean zzb;
    private String zzc;

    public zzgo(zzko zzko2, String string) {
        Preconditions.checkNotNull((Object)zzko2);
        this.zza = zzko2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzh(zzp zzp2) {
        this.zzx(zzp2, false);
        zzgf zzgf2 = new zzgf(this, zzp2);
        this.zzc(zzgf2);
    }

    @BinderThread
    public final void zzu(zzp zzp2) {
        zzlm.zzb();
        if (this.zza.zzd().zzn(null, zzeh.zzaG)) {
            Preconditions.checkNotEmpty((String)zzp2.zza);
            Preconditions.checkNotNull((Object)zzp2.zzv);
            zzgg zzgg2 = new zzgg(this, zzp2);
            Preconditions.checkNotNull((Object)zzgg2);
            if (this.zza.zzau().zzd()) {
                zzgg2.run();
                return;
            }
            this.zza.zzau().zzj((Runnable)zzgg2);
            return;
        }
    }

    @BinderThread
    public final void zzd(zzas zzas2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzas2);
        this.zzx(zzp2, false);
        zzgh zzgh2 = new zzgh(this, zzas2, zzp2);
        this.zzc(zzgh2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final zzas zzb(zzas zzas2, zzp object) {
        if (!"_cmp".equals(zzas2.zza)) return zzas2;
        zzaq zzaq2 = zzas2.zzb;
        if (zzaq2 == null) return zzas2;
        if (zzaq2.zze() == 0) {
            return zzas2;
        }
        String string = zzas2.zzb.zzd("_cis");
        if (!"referrer broadcast".equals(string)) {
            if (!"referrer API".equals(string)) return zzas2;
        }
        this.zza.zzat().zzi().zzb("Event has been filtered ", (Object)zzas2.toString());
        return new zzas("_cmpx", zzas2.zzb, zzas2.zzc, zzas2.zzd);
    }

    @BinderThread
    public final void zzg(zzas zzas2, String string, String object) {
        Preconditions.checkNotNull((Object)zzas2);
        Preconditions.checkNotEmpty((String)string);
        this.zzy(string, true);
        object = new zzgi(this, zzas2, string);
        this.zzc((Runnable)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final byte[] zzj(zzas zzas2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzas2);
        this.zzy(string, true);
        this.zza.zzat().zzj().zzb("Log and bundle. event", (Object)this.zza.zzq().zzc(zzas2.zza));
        long l = this.zza.zzax().nanoTime() / 1000000L;
        Object object = this.zza;
        object = ((zzko)object).zzau();
        Object object2 = new zzgj(this, zzas2, string);
        object = object.zzf((Callable)object2);
        try {
            object = (byte[])object.get();
            if (object == null) {
                this.zza.zzat().zzb().zzb("Log and bundle returned null. appId", zzet.zzl((String)string));
                object = new byte[0];
            }
            object2 = this.zza;
            object2 = ((zzko)object2).zzax();
            long l2 = object2.nanoTime();
            this.zza.zzat().zzj().zzd("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzq().zzc(zzas2.zza), (Object)((Object)object).length, (Object)(l2 / 1000000L - l));
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzat().zzb().zzd("Failed to log and bundle. appId, event, error", zzet.zzl((String)string), (Object)this.zza.zzq().zzc(zzas2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zze(zzkr zzkr2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzkr2);
        this.zzx(zzp2, false);
        zzgk zzgk2 = new zzgk(this, zzkr2, zzp2);
        this.zzc(zzgk2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkr> zzi(zzp zzp2, boolean bl) {
        this.zzx(zzp2, false);
        Iterator iterator = this.zza;
        iterator = ((zzko)((Object)iterator)).zzau();
        ArrayList<zzkr> arrayList = new ArrayList<zzkr>(this, zzp2);
        iterator = iterator.zze((Callable)((Object)arrayList));
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkr>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                String string;
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzkt zzkt2 = (zzkt)iterator.next();
                if (!bl && (bl2 = zzkv.zzR((String)(string = zzkt2.zzc)))) continue;
                zzkr zzkr2 = new zzkr(zzkt2);
                arrayList.add(zzkr2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzat().zzb().zzc("Failed to get user properties. appId", zzet.zzl((String)zzp2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zzf(zzp zzp2) {
        this.zzx(zzp2, false);
        zzgm zzgm2 = new zzgm(this, zzp2);
        this.zzc(zzgm2);
    }

    @BinderThread
    private final void zzx(zzp zzp2, boolean bl) {
        Preconditions.checkNotNull((Object)zzp2);
        this.zzy(zzp2.zza, false);
        this.zza.zzr().zzA(zzp2.zzb, zzp2.zzq, zzp2.zzu);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    private final void zzy(String string, boolean bl) {
        block12: {
            boolean bl2;
            boolean bl3;
            String string2;
            int n;
            void var1_2;
            block11: {
                boolean bl4;
                block8: {
                    boolean bl5;
                    block10: {
                        block9: {
                            if (TextUtils.isEmpty((CharSequence)var1_2)) {
                                this.zza.zzat().zzb().zza("Measurement Service called without app package");
                                SecurityException securityException = new SecurityException("Measurement Service called without app package");
                                throw securityException;
                            }
                            if (!bl4) break block11;
                            try {
                                Context context;
                                Boolean bl6 = this.zzb;
                                if (bl6 != null) break block8;
                                bl5 = "com.google.android.gms".equals(this.zzc);
                                if (bl5) break block9;
                                Context context2 = this.zza.zzaw();
                                bl5 = UidVerifier.isGooglePlayServicesUid((Context)context2, (int)(n = Binder.getCallingUid()));
                                bl5 = !bl5 ? (bl5 = GoogleSignatureVerifier.getInstance((Context)(context = this.zza.zzaw())).isUidGoogleSigned(Binder.getCallingUid())) : true;
                                break block10;
                            }
                            catch (SecurityException securityException) {
                                this.zza.zzat().zzb().zzb("Measurement Service called with invalid calling package. appId", zzet.zzl((String)var1_2));
                                throw securityException;
                            }
                        }
                        bl5 = true;
                    }
                    this.zzb = bl5;
                }
                if (bl4 = this.zzb.booleanValue()) break block12;
            }
            if ((string2 = this.zzc) == null && (bl3 = GooglePlayServicesUtilLight.uidHasPackageName((Context)(string2 = this.zza.zzaw()), (int)(n = Binder.getCallingUid()), (String)var1_2))) {
                this.zzc = var1_2;
            }
            if (!(bl2 = var1_2.equals(this.zzc))) {
                Object[] objectArray = new Object[]{var1_2};
                SecurityException securityException = new SecurityException(String.format("Unknown calling package name '%s'.", objectArray));
                throw securityException;
            }
        }
    }

    @BinderThread
    public final void zzk(long l, String string, String string2, String string3) {
        zzgn zzgn2 = new zzgn(this, string2, string3, string, l);
        this.zzc(zzgn2);
    }

    @BinderThread
    public final void zzt(Bundle bundle, zzp zzp2) {
        zzmz.zzb();
        if (this.zza.zzd().zzn(null, zzeh.zzaz)) {
            this.zzx(zzp2, false);
            zzfx zzfx2 = new zzfx(this, zzp2, bundle);
            this.zzc(zzfx2);
            return;
        }
    }

    @BinderThread
    public final String zzl(zzp zzp2) {
        this.zzx(zzp2, false);
        return this.zza.zzY(zzp2);
    }

    @BinderThread
    public final void zzm(zzaa object, zzp zzp2) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        this.zzx(zzp2, false);
        zzaa zzaa2 = new zzaa(object);
        zzaa2.zza = zzp2.zza;
        object = new zzfy(this, zzaa2, zzp2);
        this.zzc((Runnable)object);
    }

    @BinderThread
    public final void zzn(zzaa object) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        this.zzy(object.zza, true);
        zzaa zzaa2 = new zzaa(object);
        object = new zzfz(this, zzaa2);
        this.zzc((Runnable)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkr> zzo(String iterator, String arrayList, boolean bl, zzp zzp2) {
        this.zzx(zzp2, false);
        zzko zzko2 = this.zza;
        zzko2 = zzko2.zzau();
        zzga zzga2 = new zzga(this, zzp2, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzko2.zze(zzga2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkr>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                String string;
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzko2 = (zzkt)iterator.next();
                if (!bl && (bl2 = zzkv.zzR((String)(string = ((zzkt)zzko2).zzc)))) continue;
                zzkr zzkr2 = new zzkr((zzkt)zzko2);
                arrayList.add(zzkr2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzat().zzb().zzc("Failed to query user properties. appId", zzet.zzl((String)zzp2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkr> zzp(String string, String iterator, String arrayList, boolean bl) {
        this.zzy(string, true);
        zzko zzko2 = this.zza;
        zzko2 = zzko2.zzau();
        zzgb zzgb2 = new zzgb(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzko2.zze(zzgb2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkr>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                String string2;
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzko2 = (zzkt)iterator.next();
                if (!bl && (bl2 = zzkv.zzR((String)(string2 = ((zzkt)zzko2).zzc)))) continue;
                zzkr zzkr2 = new zzkr((zzkt)zzko2);
                arrayList.add(zzkr2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzat().zzb().zzc("Failed to get user properties as. appId", zzet.zzl((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzaa> zzq(String object, String string, zzp zzp2) {
        this.zzx(zzp2, false);
        zzko zzko2 = this.zza;
        zzko2 = zzko2.zzau();
        zzgc zzgc2 = new zzgc(this, zzp2, (String)object, string);
        object = zzko2.zze(zzgc2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzat().zzb().zzb("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzaa> zzr(String object, String string, String string2) {
        this.zzy((String)object, true);
        zzko zzko2 = this.zza;
        zzko2 = zzko2.zzau();
        zzgd zzgd2 = new zzgd(this, (String)object, string, string2);
        object = zzko2.zze(zzgd2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzat().zzb().zzb("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzs(zzp zzp2) {
        this.zzy(zzp2.zza, false);
        zzge zzge2 = new zzge(this, zzp2);
        this.zzc(zzge2);
    }

    @VisibleForTesting
    final void zzc(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzau().zzd()) {
            runnable.run();
            return;
        }
        this.zza.zzau().zzh(runnable);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ void zzv(zzp object, Bundle object2) {
        void var2_3;
        zzai zzai2 = ((zzgo)((Object)zzai2)).zza.zzi();
        String string = object.zza;
        zzai2.zzg();
        zzai2.zzX();
        zzan zzan2 = new zzan(zzai2.zzx, "", string, "dep", 0L, 0L, (Bundle)var2_3);
        byte[] byArray = zzai2.zza.zzn().zzf(zzan2).zzbp();
        zzai2.zzx.zzat().zzk().zzc("Saving default event parameters, appId, data size", (Object)zzai2.zzx.zzm().zzc(string), (Object)byArray.length);
        zzan2 = new ContentValues();
        zzan2.put("app_id", string);
        zzan2.put("parameters", byArray);
        try {
            long l = zzai2.zze().insertWithOnConflict("default_event_params", null, (ContentValues)zzan2, 5);
            if (l != -1L) return;
        }
        catch (SQLiteException sQLiteException) {
            zzai2.zzx.zzat().zzb().zzc("Error storing default event parameters. appId", zzet.zzl((String)string), (Object)sQLiteException);
            return;
        }
        zzet zzet2 = zzai2.zzx.zzat();
        zzet2.zzb().zzb("Failed to insert default event parameters (got -1). appId", zzet.zzl((String)string));
    }

    static /* synthetic */ zzko zzw(zzgo zzgo2) {
        return zzgo2.zza;
    }
}

