/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Key;
import dagger.shaded.auto.common.MoreElements;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

abstract class Binding {
    Binding() {
    }

    static Optional<String> bindingPackageFor(Iterable<? extends Binding> bindings) {
        ImmutableSet.Builder bindingPackagesBuilder = ImmutableSet.builder();
        for (Binding binding : bindings) {
            bindingPackagesBuilder.addAll((Iterable)binding.bindingPackage().asSet());
        }
        ImmutableSet bindingPackages = bindingPackagesBuilder.build();
        switch (bindingPackages.size()) {
            case 0: {
                return Optional.absent();
            }
            case 1: {
                return Optional.of((Object)bindingPackages.iterator().next());
            }
        }
        throw new IllegalArgumentException();
    }

    protected abstract Key key();

    abstract Element bindingElement();

    TypeElement bindingTypeElement() {
        return this.bindingElement().accept(new SimpleElementVisitor6<TypeElement, Void>(){

            @Override
            protected TypeElement defaultAction(Element e, Void p) {
                return MoreElements.asType(Binding.this.bindingElement().getEnclosingElement());
            }

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }
        }, null);
    }

    abstract ImmutableSet<DependencyRequest> dependencies();

    abstract ImmutableSet<DependencyRequest> implicitDependencies();

    abstract Optional<String> bindingPackage();

    protected static Optional<String> findBindingPackage(Key bindingKey) {
        Set<String> packages = Binding.nonPublicPackageUse(bindingKey.type());
        switch (packages.size()) {
            case 0: {
                return Optional.absent();
            }
            case 1: {
                return Optional.of((Object)packages.iterator().next());
            }
        }
        throw new IllegalStateException();
    }

    private static Set<String> nonPublicPackageUse(TypeMirror typeMirror) {
        ImmutableSet.Builder packages = ImmutableSet.builder();
        typeMirror.accept(new SimpleTypeVisitor6<Void, ImmutableSet.Builder<String>>(){

            @Override
            public Void visitArray(ArrayType t, ImmutableSet.Builder<String> p) {
                return t.getComponentType().accept(this, p);
            }

            @Override
            public Void visitDeclared(DeclaredType t, ImmutableSet.Builder<String> p) {
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    typeMirror.accept(this, p);
                }
                TypeElement typeElement = MoreElements.asType(t.asElement());
                if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    PackageElement packageElement = MoreElements.getPackage(typeElement);
                    Name qualifiedName = packageElement.getQualifiedName();
                    p.add((Object)qualifiedName.toString());
                }
                typeElement.getEnclosingElement().asType().accept(this, p);
                return null;
            }

            @Override
            public Void visitWildcard(WildcardType t, ImmutableSet.Builder<String> p) {
                if (t.getExtendsBound() != null) {
                    t.getExtendsBound().accept(this, p);
                }
                if (t.getSuperBound() != null) {
                    t.getSuperBound().accept(this, p);
                }
                return null;
            }
        }, packages);
        return packages.build();
    }

    abstract boolean hasNonDefaultTypeParameters();

    /*
     * WARNING - void declaration
     */
    static boolean hasNonDefaultTypeParameters(TypeElement element, TypeMirror type, Types types) {
        void var5_7;
        if (element.getTypeParameters().isEmpty()) {
            return false;
        }
        ArrayList defaultTypes = Lists.newArrayList();
        for (TypeParameterElement typeParameterElement : element.getTypeParameters()) {
            defaultTypes.add(typeParameterElement.asType());
        }
        List<TypeMirror> actualTypes = type.accept(new SimpleTypeVisitor6<List<TypeMirror>, Void>(){

            @Override
            protected List<TypeMirror> defaultAction(TypeMirror e, Void p) {
                return ImmutableList.of();
            }

            @Override
            public List<TypeMirror> visitDeclared(DeclaredType t, Void p) {
                return ImmutableList.copyOf(t.getTypeArguments());
            }
        }, null);
        if (defaultTypes.size() != actualTypes.size()) {
            return true;
        }
        boolean bl = false;
        while (var5_7 < defaultTypes.size()) {
            if (!types.isSameType((TypeMirror)defaultTypes.get((int)var5_7), actualTypes.get((int)var5_7))) {
                return true;
            }
            ++var5_7;
        }
        return false;
    }
}

