/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.Component;
import dagger.Lazy;
import dagger.MembersInjector;
import dagger.Subcomponent;
import dagger.internal.codegen.AutoValue_ComponentDescriptor;
import dagger.internal.codegen.AutoValue_ComponentDescriptor_ComponentMethodDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.Util;
import dagger.producers.ProductionComponent;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class ComponentDescriptor {
    ComponentDescriptor() {
    }

    abstract Kind kind();

    abstract AnnotationMirror componentAnnotation();

    abstract TypeElement componentDefinitionType();

    abstract ImmutableSet<TypeElement> dependencies();

    abstract ImmutableMap<ExecutableElement, TypeElement> dependencyMethodIndex();

    abstract Optional<TypeElement> executorDependency();

    Optional<AnnotationMirror> scope() {
        return Util.unwrapOptionalEquivalence(this.wrappedScope());
    }

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedScope();

    abstract ImmutableMap<ExecutableElement, ComponentDescriptor> subcomponents();

    abstract ImmutableSet<ComponentMethodDescriptor> componentMethods();

    static boolean isComponentContributionMethod(Elements elements, ExecutableElement method) {
        return method.getParameters().isEmpty() && !method.getReturnType().getKind().equals((Object)TypeKind.VOID) && !elements.getTypeElement(Object.class.getCanonicalName()).equals(method.getEnclosingElement());
    }

    static boolean isComponentProductionMethod(Elements elements, ExecutableElement method) {
        return ComponentDescriptor.isComponentContributionMethod(elements, method) && MoreTypes.isTypeOf(ListenableFuture.class, method.getReturnType());
    }

    private static void findLocalAndInheritedMethods(Elements elements, TypeElement type, List<ExecutableElement> methods) {
        for (TypeMirror typeMirror : type.getInterfaces()) {
            ComponentDescriptor.findLocalAndInheritedMethods(elements, MoreElements.asType(MoreTypes.asElement(typeMirror)), methods);
        }
        if (type.getSuperclass().getKind() != TypeKind.NONE) {
            ComponentDescriptor.findLocalAndInheritedMethods(elements, MoreElements.asType(MoreTypes.asElement(type.getSuperclass())), methods);
        }
        List<ExecutableElement> theseMethods = ElementFilter.methodsIn(type.getEnclosedElements());
        for (ExecutableElement method : theseMethods) {
            if (method.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            boolean alreadySeen = false;
            Iterator<ExecutableElement> methodIter = methods.iterator();
            while (methodIter.hasNext()) {
                ExecutableElement otherMethod = methodIter.next();
                if (elements.overrides(method, otherMethod, type)) {
                    methodIter.remove();
                    continue;
                }
                if (!method.getSimpleName().equals(otherMethod.getSimpleName()) || !method.getParameters().equals(otherMethod.getParameters())) continue;
                alreadySeen = true;
            }
            if (alreadySeen) continue;
            methods.add(method);
        }
    }

    private static ImmutableSet<ExecutableElement> getUnimplementedMethods(Elements elements, TypeElement type) {
        ImmutableSet.Builder unimplementedMethods = ImmutableSet.builder();
        ArrayList methods = Lists.newArrayList();
        ComponentDescriptor.findLocalAndInheritedMethods(elements, type, methods);
        for (ExecutableElement method : methods) {
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            unimplementedMethods.add((Object)method);
        }
        return unimplementedMethods.build();
    }

    static final class Factory {
        private final Elements elements;
        private final Types types;
        private final DependencyRequest.Factory dependencyRequestFactory;

        Factory(Elements elements, Types types, DependencyRequest.Factory dependencyRequestFactory) {
            this.elements = elements;
            this.types = types;
            this.dependencyRequestFactory = dependencyRequestFactory;
        }

        ComponentDescriptor forComponent(TypeElement componentDefinitionType) {
            return this.create(componentDefinitionType, Kind.COMPONENT);
        }

        ComponentDescriptor forProductionComponent(TypeElement componentDefinitionType) {
            return this.create(componentDefinitionType, Kind.PRODUCTION_COMPONENT);
        }

        private ComponentDescriptor create(TypeElement componentDefinitionType, Kind kind) {
            AnnotationMirror componentMirror = (AnnotationMirror)MoreElements.getAnnotationMirror(componentDefinitionType, kind.annotationType()).or(MoreElements.getAnnotationMirror(componentDefinitionType, Subcomponent.class)).get();
            ImmutableSet<TypeElement> componentDependencyTypes = ConfigurationAnnotations.isComponent(componentDefinitionType) ? MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies(componentMirror)) : ImmutableSet.of();
            ImmutableMap.Builder dependencyMethodIndex = ImmutableMap.builder();
            for (TypeElement componentDependency : componentDependencyTypes) {
                List<ExecutableElement> dependencyMethods = ElementFilter.methodsIn(this.elements.getAllMembers(componentDependency));
                for (ExecutableElement dependencyMethod : dependencyMethods) {
                    if (!ComponentDescriptor.isComponentContributionMethod(this.elements, dependencyMethod)) continue;
                    dependencyMethodIndex.put((Object)dependencyMethod, (Object)componentDependency);
                }
            }
            Optional executorDependency = kind.equals((Object)Kind.PRODUCTION_COMPONENT) ? Optional.of((Object)this.elements.getTypeElement(Executor.class.getCanonicalName())) : Optional.absent();
            ImmutableSet unimplementedMethods = ComponentDescriptor.getUnimplementedMethods(this.elements, componentDefinitionType);
            ImmutableSet.Builder componentMethodsBuilder = ImmutableSet.builder();
            ImmutableMap.Builder subcomponentDescriptors = ImmutableMap.builder();
            for (ExecutableElement componentMethod : unimplementedMethods) {
                ComponentMethodDescriptor componentMethodDescriptor = this.getDescriptorForComponentMethod(componentDefinitionType, kind, componentMethod);
                componentMethodsBuilder.add((Object)componentMethodDescriptor);
                if (!componentMethodDescriptor.kind().equals((Object)ComponentMethodKind.SUBCOMPONENT)) continue;
                subcomponentDescriptors.put((Object)componentMethod, (Object)this.create(MoreElements.asType(MoreTypes.asElement(componentMethod.getReturnType())), Kind.COMPONENT));
            }
            Optional<AnnotationMirror> scope = InjectionAnnotations.getScopeAnnotation(componentDefinitionType);
            return new AutoValue_ComponentDescriptor(kind, componentMirror, componentDefinitionType, componentDependencyTypes, (ImmutableMap<ExecutableElement, TypeElement>)dependencyMethodIndex.build(), (Optional<TypeElement>)executorDependency, Util.wrapOptionalInEquivalence(AnnotationMirrors.equivalence(), scope), (ImmutableMap<ExecutableElement, ComponentDescriptor>)subcomponentDescriptors.build(), (ImmutableSet<ComponentMethodDescriptor>)componentMethodsBuilder.build());
        }

        private ComponentMethodDescriptor getDescriptorForComponentMethod(TypeElement componentElement, Kind componentKind, ExecutableElement componentMethod) {
            ExecutableType resolvedComponentMethod = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(componentElement.asType()), componentMethod));
            TypeMirror returnType = resolvedComponentMethod.getReturnType();
            if (returnType.getKind().equals((Object)TypeKind.DECLARED)) {
                if (MoreTypes.isTypeOf(Provider.class, returnType) || MoreTypes.isTypeOf(Lazy.class, returnType)) {
                    return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(ComponentMethodKind.PROVISON, (Optional<DependencyRequest>)Optional.of((Object)this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod)), componentMethod);
                }
                if (MoreTypes.isTypeOf(MembersInjector.class, returnType)) {
                    return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(ComponentMethodKind.MEMBERS_INJECTION, (Optional<DependencyRequest>)Optional.of((Object)this.dependencyRequestFactory.forComponentMembersInjectionMethod(componentMethod, resolvedComponentMethod)), componentMethod);
                }
                if (MoreElements.getAnnotationMirror(MoreTypes.asElement(returnType), Subcomponent.class).isPresent()) {
                    return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(ComponentMethodKind.SUBCOMPONENT, (Optional<DependencyRequest>)Optional.absent(), componentMethod);
                }
            }
            if (componentMethod.getParameters().isEmpty() && !componentMethod.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                switch (componentKind) {
                    case COMPONENT: {
                        return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(ComponentMethodKind.PROVISON, (Optional<DependencyRequest>)Optional.of((Object)this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod)), componentMethod);
                    }
                    case PRODUCTION_COMPONENT: {
                        return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(ComponentMethodKind.PRODUCTION, (Optional<DependencyRequest>)Optional.of((Object)this.dependencyRequestFactory.forComponentProductionMethod(componentMethod, resolvedComponentMethod)), componentMethod);
                    }
                }
                throw new AssertionError();
            }
            List<? extends TypeMirror> parameterTypes = resolvedComponentMethod.getParameterTypes();
            if (parameterTypes.size() == 1 && (returnType.getKind().equals((Object)TypeKind.VOID) || MoreTypes.equivalence().equivalent((Object)returnType, (Object)parameterTypes.get(0)))) {
                return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(ComponentMethodKind.MEMBERS_INJECTION, (Optional<DependencyRequest>)Optional.of((Object)this.dependencyRequestFactory.forComponentMembersInjectionMethod(componentMethod, resolvedComponentMethod)), componentMethod);
            }
            throw new IllegalArgumentException("not a valid component method: " + componentMethod);
        }
    }

    static enum ComponentMethodKind {
        PROVISON,
        PRODUCTION,
        MEMBERS_INJECTION,
        SUBCOMPONENT;

    }

    static abstract class ComponentMethodDescriptor {
        ComponentMethodDescriptor() {
        }

        abstract ComponentMethodKind kind();

        abstract Optional<DependencyRequest> dependencyRequest();

        abstract ExecutableElement methodElement();
    }

    static enum Kind {
        COMPONENT(Component.class),
        PRODUCTION_COMPONENT(ProductionComponent.class);

        private final Class<? extends Annotation> annotationType;

        private Kind(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        Class<? extends Annotation> annotationType() {
            return this.annotationType;
        }
    }
}

